/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ColumnarBinaryHiveRecordCursorProvider;
import com.facebook.presto.hive.ColumnarTextHiveRecordCursorProvider;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.ForHiveMetastore;
import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HadoopDirectoryLister;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationUpdater;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCluster;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveHandleResolver;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HiveMetastoreClientFactory;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveRecordSinkProvider;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplitManager;
import com.facebook.presto.hive.HiveTableProperties;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.ParquetRecordCursorProvider;
import com.facebook.presto.hive.PrestoS3FileSystem;
import com.facebook.presto.hive.PrestoS3FileSystemStats;
import com.facebook.presto.hive.StaticHiveCluster;
import com.facebook.presto.hive.StaticMetastoreConfig;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.orc.DwrfPageSourceFactory;
import com.facebook.presto.hive.orc.DwrfRecordCursorProvider;
import com.facebook.presto.hive.orc.OrcPageSourceFactory;
import com.facebook.presto.hive.orc.OrcRecordCursorProvider;
import com.facebook.presto.hive.rcfile.RcFilePageSourceFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorPageSourceProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.type.TypeManager;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class HiveClientModule
implements Module {
    private final String connectorId;
    private final HiveMetastore metastore;
    private final TypeManager typeManager;

    public HiveClientModule(String connectorId, HiveMetastore metastore, TypeManager typeManager) {
        this.connectorId = connectorId;
        this.metastore = metastore;
        this.typeManager = typeManager;
    }

    public void configure(Binder binder) {
        binder.bind(HiveConnectorId.class).toInstance((Object)new HiveConnectorId(this.connectorId));
        binder.bind(HdfsConfigurationUpdater.class).in(Scopes.SINGLETON);
        binder.bind(HdfsConfiguration.class).to(HiveHdfsConfiguration.class).in(Scopes.SINGLETON);
        binder.bind(HdfsEnvironment.class).in(Scopes.SINGLETON);
        binder.bind(DirectoryLister.class).to(HadoopDirectoryLister.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HiveClientConfig.class);
        binder.bind(HiveSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(HiveTableProperties.class).in(Scopes.SINGLETON);
        if (this.metastore != null) {
            binder.bind(HiveMetastore.class).toInstance((Object)this.metastore);
        } else {
            binder.bind(HiveMetastore.class).to(CachingHiveMetastore.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(HiveMetastore.class).as(ObjectNames.generatedNameOf(CachingHiveMetastore.class, (String)this.connectorId));
        }
        binder.bind(NamenodeStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(NamenodeStats.class).as(ObjectNames.generatedNameOf(NamenodeStats.class));
        binder.bind(HiveMetastoreClientFactory.class).in(Scopes.SINGLETON);
        binder.bind(HiveCluster.class).to(StaticHiveCluster.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(StaticMetastoreConfig.class);
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        Multibinder recordCursorProviderBinder = Multibinder.newSetBinder((Binder)binder, HiveRecordCursorProvider.class);
        recordCursorProviderBinder.addBinding().to(OrcRecordCursorProvider.class).in(Scopes.SINGLETON);
        recordCursorProviderBinder.addBinding().to(ParquetRecordCursorProvider.class).in(Scopes.SINGLETON);
        recordCursorProviderBinder.addBinding().to(DwrfRecordCursorProvider.class).in(Scopes.SINGLETON);
        recordCursorProviderBinder.addBinding().to(ColumnarTextHiveRecordCursorProvider.class).in(Scopes.SINGLETON);
        recordCursorProviderBinder.addBinding().to(ColumnarBinaryHiveRecordCursorProvider.class).in(Scopes.SINGLETON);
        recordCursorProviderBinder.addBinding().to(GenericHiveRecordCursorProvider.class).in(Scopes.SINGLETON);
        binder.bind(HivePartitionManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorMetadata.class).to(HiveMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(HiveSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSourceProvider.class).to(HivePageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorRecordSinkProvider.class).to(HiveRecordSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorHandleResolver.class).to(HiveHandleResolver.class).in(Scopes.SINGLETON);
        Multibinder pageSourceFactoryBinder = Multibinder.newSetBinder((Binder)binder, HivePageSourceFactory.class);
        pageSourceFactoryBinder.addBinding().to(RcFilePageSourceFactory.class).in(Scopes.SINGLETON);
        pageSourceFactoryBinder.addBinding().to(OrcPageSourceFactory.class).in(Scopes.SINGLETON);
        pageSourceFactoryBinder.addBinding().to(DwrfPageSourceFactory.class).in(Scopes.SINGLETON);
        binder.bind(PrestoS3FileSystemStats.class).toInstance((Object)PrestoS3FileSystem.getFileSystemStats());
        ExportBinder.newExporter((Binder)binder).export(PrestoS3FileSystemStats.class).as(ObjectNames.generatedNameOf(PrestoS3FileSystem.class, (String)this.connectorId));
    }

    @ForHiveClient
    @Singleton
    @Provides
    public ExecutorService createHiveClientExecutor(HiveConnectorId hiveClientId) {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-" + hiveClientId + "-%s")));
    }

    @ForHiveMetastore
    @Singleton
    @Provides
    public ExecutorService createCachingHiveMetastoreExecutor(HiveConnectorId hiveClientId, HiveClientConfig hiveClientConfig) {
        return Executors.newFixedThreadPool(hiveClientConfig.getMaxMetastoreRefreshThreads(), Threads.daemonThreadsNamed((String)("hive-metastore-" + hiveClientId + "-%s")));
    }
}

