/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorPageSourceProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class HiveConnector
implements Connector {
    private static final Logger log = Logger.get(HiveConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final ConnectorMetadata metadata;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final ConnectorRecordSinkProvider recordSinkProvider;
    private final ConnectorHandleResolver handleResolver;
    private final Set<SystemTable> systemTables;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> tableProperties;

    public HiveConnector(LifeCycleManager lifeCycleManager, ConnectorMetadata metadata, ConnectorSplitManager splitManager, ConnectorPageSourceProvider pageSourceProvider, ConnectorRecordSinkProvider recordSinkProvider, ConnectorHandleResolver handleResolver, Set<SystemTable> systemTables, List<PropertyMetadata<?>> sessionProperties, List<PropertyMetadata<?>> tableProperties) {
        this.lifeCycleManager = (LifeCycleManager)Preconditions.checkNotNull((Object)lifeCycleManager, (Object)"lifeCycleManager is null");
        this.metadata = (ConnectorMetadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.splitManager = (ConnectorSplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
        this.pageSourceProvider = (ConnectorPageSourceProvider)Preconditions.checkNotNull((Object)pageSourceProvider, (Object)"pageSourceProvider is null");
        this.recordSinkProvider = (ConnectorRecordSinkProvider)Preconditions.checkNotNull((Object)recordSinkProvider, (Object)"recordSinkProvider is null");
        this.handleResolver = (ConnectorHandleResolver)Preconditions.checkNotNull((Object)handleResolver, (Object)"handleResolver is null");
        this.systemTables = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(systemTables, (Object)"systemTables is null")));
        this.sessionProperties = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sessionProperties, (Object)"sessionProperties is null")));
        this.tableProperties = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(tableProperties, (Object)"tableProperties is null")));
    }

    public ConnectorMetadata getMetadata() {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorRecordSinkProvider getRecordSinkProvider() {
        return this.recordSinkProvider;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return this.handleResolver;
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

