/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;

public enum HiveErrorCode implements ErrorCodeSupplier
{
    HIVE_METASTORE_ERROR(0x1000000),
    HIVE_CURSOR_ERROR(0x1000001),
    HIVE_TABLE_OFFLINE(0x1000002),
    HIVE_CANNOT_OPEN_SPLIT(0x1000003),
    HIVE_FILE_NOT_FOUND(0x1000004),
    HIVE_UNKNOWN_ERROR(0x1000005),
    HIVE_PARTITION_OFFLINE(0x1000006),
    HIVE_BAD_DATA(0x1000007),
    HIVE_PARTITION_SCHEMA_MISMATCH(0x1000008),
    HIVE_MISSING_DATA(0x1000009),
    HIVE_INVALID_PARTITION_VALUE(0x100000A),
    HIVE_TIMEZONE_MISMATCH(0x100000B),
    HIVE_INVALID_METADATA(0x100000C),
    HIVE_INVALID_VIEW_DATA(0x100000D),
    HIVE_DATABASE_LOCATION_ERROR(0x100000E),
    HIVE_PATH_ALREADY_EXISTS(0x100000F),
    HIVE_FILESYSTEM_ERROR(0x1000010),
    HIVE_WRITER_ERROR(0x1000011),
    HIVE_SERDE_NOT_FOUND(0x1000012),
    HIVE_UNSUPPORTED_FORMAT(0x1000013);

    private final ErrorCode errorCode;

    private HiveErrorCode(int code) {
        this.errorCode = new ErrorCode(code, this.name());
    }

    public ErrorCode toErrorCode() {
        return this.errorCode;
    }
}

