/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationUpdater;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class HiveHdfsConfiguration
implements HdfsConfiguration {
    private static final Configuration DEFAULT_CONFIGURATION = new Configuration();
    private final ThreadLocal<Configuration> hadoopConfiguration = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            Configuration config = new Configuration(false);
            for (Map.Entry entry : DEFAULT_CONFIGURATION) {
                config.set((String)entry.getKey(), (String)entry.getValue());
            }
            HiveHdfsConfiguration.this.updater.updateConfiguration(config);
            return config;
        }
    };
    private final HdfsConfigurationUpdater updater;

    @Inject
    public HiveHdfsConfiguration(HdfsConfigurationUpdater updater) {
        this.updater = (HdfsConfigurationUpdater)Preconditions.checkNotNull((Object)updater, (Object)"updater is null");
    }

    @Override
    public Configuration getConfiguration(URI uri) {
        return this.hadoopConfiguration.get();
    }
}

