/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HiveRecordSink;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTableProperties;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.HiveViewNotSupportedException;
import com.facebook.presto.hive.PrestoS3FileSystem;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.ViewAlreadyExistsException;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.joda.time.DateTimeZone;

public class HiveMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(HiveMetadata.class);
    private final String connectorId;
    private final boolean allowDropTable;
    private final boolean allowRenameTable;
    private final boolean allowCorruptWritesForTesting;
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final DateTimeZone timeZone;
    private final TypeManager typeManager;

    @Inject
    public HiveMetadata(HiveConnectorId connectorId, HiveClientConfig hiveClientConfig, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, @ForHiveClient ExecutorService executorService, TypeManager typeManager) {
        this(connectorId, metastore, hdfsEnvironment, partitionManager, hiveClientConfig.getDateTimeZone(), hiveClientConfig.getAllowDropTable(), hiveClientConfig.getAllowRenameTable(), hiveClientConfig.getAllowCorruptWritesForTesting(), typeManager);
    }

    public HiveMetadata(HiveConnectorId connectorId, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager patitionManager, DateTimeZone timeZone, boolean allowDropTable, boolean allowRenameTable, boolean allowCorruptWritesForTesting, TypeManager typeManager) {
        this.connectorId = ((HiveConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.allowDropTable = allowDropTable;
        this.allowRenameTable = allowRenameTable;
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        this.metastore = (HiveMetastore)Preconditions.checkNotNull((Object)metastore, (Object)"metastore is null");
        this.hdfsEnvironment = (HdfsEnvironment)Preconditions.checkNotNull((Object)hdfsEnvironment, (Object)"hdfsEnvironment is null");
        this.partitionManager = (HivePartitionManager)Preconditions.checkNotNull((Object)patitionManager, (Object)"patitionManager is null");
        this.timeZone = (DateTimeZone)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone is null");
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
        if (!allowCorruptWritesForTesting && !timeZone.equals((Object)DateTimeZone.getDefault())) {
            log.warn("Hive writes are disabled. To write data to Hive, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments", new Object[]{timeZone.getID()});
        }
    }

    public HiveMetastore getMetastore() {
        return this.metastore;
    }

    public HivePartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metastore.getAllDatabases();
    }

    public HiveTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        if (!this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).isPresent()) {
            return null;
        }
        return new HiveTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        return this.getTableMetadata(tableName);
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent() || table.get().getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new TableNotFoundException(tableName);
        }
        List<HiveColumnHandle> handles = HiveUtil.hiveColumnHandles(this.typeManager, this.connectorId, table.get(), false);
        ImmutableList columns = ImmutableList.copyOf((Iterable)Iterables.transform(handles, HiveMetadata.columnMetadataGetter(table.get(), this.typeManager)));
        ImmutableMap.Builder properties = ImmutableMap.builder();
        try {
            HiveStorageFormat format = HiveMetadata.extractHiveStorageFormat(table.get());
            properties.put((Object)"format", (Object)format);
        }
        catch (PrestoException prestoException) {
            // empty catch block
        }
        return new ConnectorTableMetadata(tableName, (List)columns, (Map)properties.build(), table.get().getOwner());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            for (String tableName : this.metastore.getAllTables(schemaName).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return this.listSchemaNames(session);
        }
        return ImmutableList.of((Object)schemaNameOrNull);
    }

    public ColumnHandle getSampleWeightColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles(this.typeManager, this.connectorId, table.get(), true)) {
            if (!columnHandle.getName().equals("__presto__sample_weight__")) continue;
            return columnHandle;
        }
        return null;
    }

    public boolean canCreateSampledTables(ConnectorSession session) {
        return true;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles(this.typeManager, this.connectorId, table.get(), false)) {
            columnHandles.put((Object)columnHandle.getName(), (Object)columnHandle);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (HiveViewNotSupportedException hiveViewNotSupportedException) {
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null || prefix.getTableName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        return Types.checkType(columnHandle, HiveColumnHandle.class, "columnHandle").getColumnMetadata(this.typeManager);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableMetadata.getOwner()) ? 1 : 0) != 0, (Object)"Table owner is null or empty");
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        ImmutableList.Builder columnNames = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        HiveMetadata.buildColumnInfo(tableMetadata, (ImmutableList.Builder<String>)columnNames, (ImmutableList.Builder<Type>)columnTypes);
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        ImmutableList.Builder columns = ImmutableList.builder();
        ImmutableList names = columnNames.build();
        List typeNames = columnTypes.build().stream().map(HiveType::toHiveType).map(HiveType::getHiveTypeName).collect(Collectors.toList());
        for (int i = 0; i < names.size(); ++i) {
            if (((ColumnMetadata)tableMetadata.getColumns().get(i)).isPartitionKey()) {
                partitionKeys.add((Object)new FieldSchema((String)names.get(i), (String)typeNames.get(i), null));
                continue;
            }
            columns.add((Object)new FieldSchema((String)names.get(i), (String)typeNames.get(i), null));
        }
        Path targetPath = this.getTargetPath(schemaName, tableName, schemaTableName);
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setName(tableName);
        serdeInfo.setSerializationLib(hiveStorageFormat.getSerDe());
        serdeInfo.setParameters((Map)ImmutableMap.of());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(targetPath.toString());
        sd.setCols((List)columns.build());
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(hiveStorageFormat.getInputFormat());
        sd.setOutputFormat(hiveStorageFormat.getOutputFormat());
        sd.setParameters((Map)ImmutableMap.of());
        Table table = new Table();
        table.setDbName(schemaName);
        table.setTableName(tableName);
        table.setOwner(tableMetadata.getOwner());
        table.setTableType(TableType.MANAGED_TABLE.toString());
        String tableComment = "Created by Presto";
        table.setParameters((Map)ImmutableMap.of((Object)"comment", (Object)tableComment));
        table.setPartitionKeys((List)partitionKeys.build());
        table.setSd(sd);
        this.metastore.createTable(table);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        if (!this.allowRenameTable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "Renaming tables is disabled in this Hive catalog");
        }
        HiveTableHandle handle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        this.metastore.renameTable(handle.getSchemaName(), handle.getTableName(), newTableName.getSchemaName(), newTableName.getTableName());
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        if (!this.allowDropTable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "DROP TABLE is disabled in this Hive catalog");
        }
        Optional<Table> target = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        Table table = target.get();
        if (!session.getUser().equals(table.getOwner())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, String.format("Unable to drop table '%s': owner of the table is different from session user", table));
        }
        this.metastore.dropTable(handle.getSchemaName(), handle.getTableName());
    }

    public HiveOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        this.verifyJvmTimeZone();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableMetadata.getOwner()) ? 1 : 0) != 0, (Object)"Table owner is null or empty");
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        ImmutableList.Builder columnNames = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        HiveMetadata.buildColumnInfo(tableMetadata, (ImmutableList.Builder<String>)columnNames, (ImmutableList.Builder<Type>)columnTypes);
        Path targetPath = this.getTargetPath(schemaName, tableName, schemaTableName);
        if (!this.useTemporaryDirectory(targetPath)) {
            return new HiveOutputTableHandle(this.connectorId, schemaName, tableName, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), tableMetadata.getOwner(), targetPath.toString(), targetPath.toString(), hiveStorageFormat);
        }
        String temporaryPrefix = "/tmp/presto-" + StandardSystemProperty.USER_NAME.value();
        Path temporaryRoot = new Path(targetPath, temporaryPrefix);
        Path temporaryPath = new Path(temporaryRoot, UUID.randomUUID().toString());
        this.createDirectories(temporaryPath);
        return new HiveOutputTableHandle(this.connectorId, schemaName, tableName, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), tableMetadata.getOwner(), targetPath.toString(), temporaryPath.toString(), hiveStorageFormat);
    }

    public void commitCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments) {
        HiveOutputTableHandle handle = Types.checkType(tableHandle, HiveOutputTableHandle.class, "tableHandle");
        Path targetPath = new Path(handle.getTargetPath());
        if (handle.hasTemporaryPath()) {
            if (this.pathExists(targetPath)) {
                SchemaTableName table = new SchemaTableName(handle.getSchemaName(), handle.getTableName());
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Unable to commit creation of table '%s': target directory already exists: %s", table, targetPath));
            }
            this.rename(new Path(handle.getTemporaryPath()), targetPath);
        }
        List types = handle.getColumnTypes().stream().map(HiveType::toHiveType).map(HiveType::getHiveTypeName).collect(Collectors.toList());
        boolean sampled = false;
        ImmutableList.Builder columns = ImmutableList.builder();
        for (int i = 0; i < handle.getColumnNames().size(); ++i) {
            String name = handle.getColumnNames().get(i);
            String type = (String)types.get(i);
            if (name.equals("__presto__sample_weight__")) {
                columns.add((Object)new FieldSchema(name, type, "Presto sample weight column"));
                sampled = true;
                continue;
            }
            columns.add((Object)new FieldSchema(name, type, null));
        }
        HiveStorageFormat hiveStorageFormat = handle.getHiveStorageFormat();
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setName(handle.getTableName());
        serdeInfo.setSerializationLib(hiveStorageFormat.getSerDe());
        serdeInfo.setParameters((Map)ImmutableMap.of());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(targetPath.toString());
        sd.setCols((List)columns.build());
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(hiveStorageFormat.getInputFormat());
        sd.setOutputFormat(hiveStorageFormat.getOutputFormat());
        sd.setParameters((Map)ImmutableMap.of());
        Table table = new Table();
        table.setDbName(handle.getSchemaName());
        table.setTableName(handle.getTableName());
        table.setOwner(handle.getTableOwner());
        table.setTableType(TableType.MANAGED_TABLE.toString());
        String tableComment = "Created by Presto";
        if (sampled) {
            tableComment = "Sampled table created by Presto. Only query this table from Hive if you understand how Presto implements sampling.";
        }
        table.setParameters((Map)ImmutableMap.of((Object)"comment", (Object)tableComment));
        table.setPartitionKeys((List)ImmutableList.of());
        table.setSd(sd);
        this.metastore.createTable(table);
    }

    private Path getTargetPath(String schemaName, String tableName, SchemaTableName schemaTableName) {
        String location = this.getDatabase(schemaName).getLocationUri();
        if (Strings.isNullOrEmpty((String)location)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location is not set", schemaName));
        }
        Path databasePath = new Path(location);
        if (!this.pathExists(databasePath)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location does not exist: %s", schemaName, databasePath));
        }
        if (!this.isDirectory(databasePath)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_DATABASE_LOCATION_ERROR, String.format("Database '%s' location is not a directory: %s", schemaName, databasePath));
        }
        Path targetPath = new Path(databasePath, tableName);
        if (this.pathExists(targetPath)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s' already exists: %s", schemaTableName, targetPath));
        }
        return targetPath;
    }

    private Database getDatabase(String database) {
        return this.metastore.getDatabase(database).orElseThrow(() -> new SchemaNotFoundException(database));
    }

    private boolean useTemporaryDirectory(Path path) {
        try {
            return !(this.hdfsEnvironment.getFileSystem(path) instanceof PrestoS3FileSystem);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    private static HiveStorageFormat extractHiveStorageFormat(Table table) {
        StorageDescriptor descriptor = table.getSd();
        if (descriptor == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        SerDeInfo serdeInfo = descriptor.getSerdeInfo();
        if (serdeInfo == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table storage descriptor is missing SerDe info");
        }
        String outputFormat = descriptor.getOutputFormat();
        String serializationLib = serdeInfo.getSerializationLib();
        for (HiveStorageFormat format : HiveStorageFormat.values()) {
            if (!format.getOutputFormat().equals(outputFormat) || !format.getSerDe().equals(serializationLib)) continue;
            return format;
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Output format %s with SerDe %s is not supported", outputFormat, serializationLib));
    }

    private boolean pathExists(Path path) {
        try {
            return this.hdfsEnvironment.getFileSystem(path).exists(path);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    private boolean isDirectory(Path path) {
        try {
            return this.hdfsEnvironment.getFileSystem(path).isDirectory(path);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    private void createDirectories(Path path) {
        try {
            if (!this.hdfsEnvironment.getFileSystem(path).mkdirs(path)) {
                throw new IOException("mkdirs returned false");
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to create directory: " + path, (Throwable)e);
        }
    }

    private void rename(Path source, Path target) {
        try {
            if (!this.hdfsEnvironment.getFileSystem(source).rename(source, target)) {
                throw new IOException("rename returned false");
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to rename %s to %s", source, target), (Throwable)e);
        }
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, String viewData, boolean replace) {
        if (replace) {
            try {
                this.dropView(session, viewName);
            }
            catch (ViewNotFoundException viewNotFoundException) {
                // empty catch block
            }
        }
        ImmutableMap properties = ImmutableMap.builder().put((Object)"comment", (Object)"Presto View").put((Object)"presto_view", (Object)"true").build();
        FieldSchema dummyColumn = new FieldSchema("dummy", "string", null);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols((List)ImmutableList.of((Object)dummyColumn));
        sd.setSerdeInfo(new SerDeInfo());
        Table table = new Table();
        table.setDbName(viewName.getSchemaName());
        table.setTableName(viewName.getTableName());
        table.setOwner(session.getUser());
        table.setTableType(TableType.VIRTUAL_VIEW.name());
        table.setParameters((Map)properties);
        table.setViewOriginalText(HiveUtil.encodeViewData(viewData));
        table.setViewExpandedText("/* Presto View */");
        table.setSd(sd);
        try {
            this.metastore.createTable(table);
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        String view = this.getViews(session, viewName.toSchemaTablePrefix()).get(viewName);
        if (view == null) {
            throw new ViewNotFoundException(viewName);
        }
        try {
            this.metastore.dropTable(viewName.getSchemaName(), viewName.getTableName());
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            for (String tableName : this.metastore.getAllViews(schemaName).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    public Map<SchemaTableName, String> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getTableName() != null ? ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName())) : this.listViews(session, prefix.getSchemaName());
        for (SchemaTableName schemaTableName : tableNames) {
            Optional<Table> table = this.metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
            if (!table.isPresent() || !HiveUtil.isPrestoView(table.get())) continue;
            views.put((Object)schemaTableName, (Object)HiveUtil.decodeViewData(table.get().getViewOriginalText()));
        }
        return views.build();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.verifyJvmTimeZone();
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "INSERT not yet supported for Hive");
    }

    public void commitInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "INSERT not yet supported for Hive");
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        HiveTableHandle handle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        HivePartitionResult hivePartitionResult = this.partitionManager.getPartitions(session, this.metastore, tableHandle, (TupleDomain<ColumnHandle>)constraint.getSummary());
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(this.getTableLayout(session, new HiveTableLayoutHandle(handle.getClientId(), hivePartitionResult.getPartitions())), hivePartitionResult.getUnenforcedConstraint()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle layoutHandle) {
        HiveTableLayoutHandle hiveLayoutHandle = Types.checkType(layoutHandle, HiveTableLayoutHandle.class, "layoutHandle");
        List partitionDomains = hiveLayoutHandle.getPartitions().stream().map(HivePartition::getTupleDomain).collect(Collectors.toList());
        TupleDomain predicate = TupleDomain.none();
        if (!partitionDomains.isEmpty()) {
            predicate = TupleDomain.columnWiseUnion(partitionDomains);
        }
        return new ConnectorTableLayout((ConnectorTableLayoutHandle)hiveLayoutHandle, Optional.empty(), predicate, Optional.empty(), Optional.of(partitionDomains), (List)ImmutableList.of());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.connectorId).toString();
    }

    private void verifyJvmTimeZone() {
        if (!this.allowCorruptWritesForTesting && !this.timeZone.equals((Object)DateTimeZone.getDefault())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TIMEZONE_MISMATCH, String.format("To write Hive data, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments.", this.timeZone.getID()));
        }
    }

    private static void buildColumnInfo(ConnectorTableMetadata tableMetadata, ImmutableList.Builder<String> names, ImmutableList.Builder<Type> types) {
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            if (!HiveRecordSink.isTypeSupported(column.getType())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Cannot create table with unsupported type: %s", column.getType().getDisplayName()));
            }
            names.add((Object)column.getName());
            types.add((Object)column.getType());
        }
        if (tableMetadata.isSampled()) {
            names.add((Object)"__presto__sample_weight__");
            types.add((Object)BigintType.BIGINT);
        }
    }

    private static Function<HiveColumnHandle, ColumnMetadata> columnMetadataGetter(Table table, TypeManager typeManager) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (FieldSchema field : Iterables.concat((Iterable)table.getSd().getCols(), (Iterable)table.getPartitionKeys())) {
            if (field.getComment() == null) continue;
            builder.put((Object)field.getName(), (Object)field.getComment());
        }
        ImmutableMap columnComment = builder.build();
        return arg_0 -> HiveMetadata.lambda$columnMetadataGetter$40(typeManager, (Map)columnComment, arg_0);
    }

    private static /* synthetic */ ColumnMetadata lambda$columnMetadataGetter$40(TypeManager typeManager, Map columnComment, HiveColumnHandle input) {
        return new ColumnMetadata(input.getName(), typeManager.getType(input.getTypeSignature()), input.isPartitionKey(), (String)columnComment.get(input.getName()), false);
    }
}

