/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class HiveOutputTableHandle
implements ConnectorOutputTableHandle {
    private final String clientId;
    private final String schemaName;
    private final String tableName;
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private final String tableOwner;
    private final String targetPath;
    private final String temporaryPath;
    private final HiveStorageFormat hiveStorageFormat;

    @JsonCreator
    public HiveOutputTableHandle(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="columnTypes") List<Type> columnTypes, @JsonProperty(value="tableOwner") String tableOwner, @JsonProperty(value="targetPath") String targetPath, @JsonProperty(value="temporaryPath") String temporaryPath, @JsonProperty(value="hiveStorageFormat") HiveStorageFormat hiveStorageFormat) {
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId is null");
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName, (Object)"schemaName is null");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        this.tableOwner = (String)Preconditions.checkNotNull((Object)tableOwner, (Object)"tableOwner is null");
        this.targetPath = (String)Preconditions.checkNotNull((Object)targetPath, (Object)"targetPath is null");
        this.temporaryPath = (String)Preconditions.checkNotNull((Object)temporaryPath, (Object)"temporaryPath is null");
        this.hiveStorageFormat = (HiveStorageFormat)((Object)Preconditions.checkNotNull((Object)((Object)hiveStorageFormat), (Object)"hiveStorageFormat is null"));
        Preconditions.checkNotNull(columnNames, (Object)"columnNames is null");
        Preconditions.checkNotNull(columnTypes, (Object)"columnTypes is null");
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes sizes don't match");
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.columnTypes = ImmutableList.copyOf(columnTypes);
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @JsonProperty
    public String getTableOwner() {
        return this.tableOwner;
    }

    @JsonProperty
    public String getTargetPath() {
        return this.targetPath;
    }

    @JsonProperty
    public String getTemporaryPath() {
        return this.temporaryPath;
    }

    @JsonProperty
    public HiveStorageFormat getHiveStorageFormat() {
        return this.hiveStorageFormat;
    }

    public String toString() {
        return "hive:" + this.schemaName + "." + this.tableName;
    }

    public boolean hasTemporaryPath() {
        return !this.temporaryPath.equals(this.targetPath);
    }
}

