/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class HivePartitionKey {
    public static final String HIVE_DEFAULT_DYNAMIC_PARTITION = "__HIVE_DEFAULT_PARTITION__";
    private final String name;
    private final HiveType hiveType;
    private final String value;

    @JsonCreator
    public HivePartitionKey(@JsonProperty(value="name") String name, @JsonProperty(value="hiveType") HiveType hiveType, @JsonProperty(value="value") String value) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)hiveType, (Object)"hiveType is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        this.name = name;
        this.hiveType = hiveType;
        this.value = value.equals(HIVE_DEFAULT_DYNAMIC_PARTITION) ? "\\N" : value;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public HiveType getHiveType() {
        return this.hiveType;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("hiveType", (Object)this.hiveType).add("value", (Object)this.value).toString();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.hiveType, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HivePartitionKey other = (HivePartitionKey)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.hiveType, other.hiveType) && Objects.equals(this.value, other.value);
    }
}

