/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveConnectorFactory;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class HivePlugin
implements Plugin {
    private final String name;
    private Map<String, String> optionalConfig = ImmutableMap.of();
    private HiveMetastore metastore;
    private TypeManager typeManager;

    public HivePlugin(String name) {
        this(name, null);
    }

    public HivePlugin(String name, HiveMetastore metastore) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.metastore = metastore;
    }

    @Inject
    public void setTypeManager(TypeManager typeManager) {
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
    }

    public void setOptionalConfig(Map<String, String> optionalConfig) {
        this.optionalConfig = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(optionalConfig, (Object)"optionalConfig is null")));
    }

    public <T> List<T> getServices(Class<T> type) {
        if (type == ConnectorFactory.class) {
            return ImmutableList.of(type.cast(new HiveConnectorFactory(this.name, this.optionalConfig, HivePlugin.getClassLoader(), this.metastore, this.typeManager)));
        }
        return ImmutableList.of();
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = HivePlugin.class.getClassLoader();
        }
        return classLoader;
    }
}

