/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public final class HiveTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final String clientId;
    private final List<HivePartition> partitions;

    @JsonCreator
    public HiveTableLayoutHandle(@JsonProperty(value="clientId") String clientId) {
        this.clientId = Objects.requireNonNull(clientId, "clientId is null");
        this.partitions = null;
    }

    public HiveTableLayoutHandle(String clientId, List<HivePartition> partitions) {
        this.clientId = Objects.requireNonNull(clientId, "clientId is null");
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonIgnore
    public List<HivePartition> getPartitions() {
        Preconditions.checkState((this.partitions != null ? 1 : 0) != 0, (Object)"Partitions dropped by serialization");
        return this.partitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTableLayoutHandle that = (HiveTableLayoutHandle)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.partitions);
    }

    public String toString() {
        return this.clientId.toString();
    }
}

