/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.RetryDriver;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SerializableNativeValue;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.ISODateTimeFormat;

public final class HiveUtil {
    public static final String PRESTO_VIEW_FLAG = "presto_view";
    private static final String VIEW_PREFIX = "/* Presto View: ";
    private static final String VIEW_SUFFIX = " */";
    private static final DateTimeFormatter HIVE_DATE_PARSER = ISODateTimeFormat.date().withZoneUTC();
    private static final DateTimeFormatter HIVE_TIMESTAMP_PARSER;

    private HiveUtil() {
    }

    public static RecordReader<?, ?> createRecordReader(Configuration configuration, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns) {
        ImmutableList readColumns = ImmutableList.copyOf((Iterable)Iterables.filter(columns, (Predicate)Predicates.not(HiveColumnHandle::isPartitionKey)));
        ImmutableList readHiveColumnIndexes = ImmutableList.copyOf((Collection)Lists.transform((List)readColumns, HiveColumnHandle::getHiveColumnIndex));
        HiveUtil.setReadColumns(configuration, (List<Integer>)readHiveColumnIndexes);
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, schema, true);
        JobConf jobConf = new JobConf(configuration);
        FileSplit fileSplit = new FileSplit(path, start, length, (String[])null);
        schema.stringPropertyNames().stream().filter(name -> name.startsWith("serialization.")).forEach(name -> jobConf.set(name, schema.getProperty((String)name)));
        try {
            return RetryDriver.retry().stopOnIllegalExceptions().run("createRecordReader", () -> inputFormat.getRecordReader((InputSplit)fileSplit, jobConf, Reporter.NULL));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, String.format("Error opening Hive split %s (offset=%s, length=%s) using %s: %s", path, start, length, HiveUtil.getInputFormatName(schema), e.getMessage()), (Throwable)e);
        }
    }

    public static void setReadColumns(Configuration configuration, List<Integer> readHiveColumnIndexes) {
        configuration.set("hive.io.file.readcolumn.ids", Joiner.on((char)',').join(readHiveColumnIndexes));
        configuration.setBoolean("hive.io.file.read.all.columns", false);
    }

    static InputFormat<?, ?> getInputFormat(Configuration configuration, Properties schema, boolean symlinkTarget) {
        String inputFormatName = HiveUtil.getInputFormatName(schema);
        try {
            JobConf jobConf = new JobConf(configuration);
            Class<? extends InputFormat<?, ?>> inputFormatClass = HiveUtil.getInputFormatClass(jobConf, inputFormatName);
            if (symlinkTarget && inputFormatClass == SymlinkTextInputFormat.class) {
                inputFormatClass = TextInputFormat.class;
            }
            return (InputFormat)ReflectionUtils.newInstance(inputFormatClass, (Configuration)jobConf);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            throw new RuntimeException("Unable to create input format " + inputFormatName, e);
        }
    }

    private static Class<? extends InputFormat<?, ?>> getInputFormatClass(JobConf conf, String inputFormatName) throws ClassNotFoundException {
        if ("parquet.hive.DeprecatedParquetInputFormat".equals(inputFormatName) || "parquet.hive.MapredParquetInputFormat".equals(inputFormatName)) {
            return MapredParquetInputFormat.class;
        }
        Class clazz = conf.getClassByName(inputFormatName);
        return clazz.asSubclass(InputFormat.class);
    }

    static String getInputFormatName(Properties schema) {
        String name = schema.getProperty("file.inputformat");
        HiveUtil.checkCondition(name != null, HiveErrorCode.HIVE_INVALID_METADATA, "Table or partition is missing Hive input format property: %s", "file.inputformat");
        return name;
    }

    public static long parseHiveDate(String value) {
        long millis = HIVE_DATE_PARSER.parseMillis(value);
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    public static long parseHiveTimestamp(String value, DateTimeZone timeZone) {
        return HIVE_TIMESTAMP_PARSER.withZone(timeZone).parseMillis(value);
    }

    static boolean isSplittable(InputFormat<?, ?> inputFormat, FileSystem fileSystem, Path path) {
        if (inputFormat.getClass().getSimpleName().equals("OrcInputFormat")) {
            return true;
        }
        Method method = null;
        for (Class<?> clazz = inputFormat.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod("isSplitable", FileSystem.class, Path.class);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (method == null) {
            return false;
        }
        try {
            method.setAccessible(true);
            return (Boolean)method.invoke(inputFormat, fileSystem, path);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static StructObjectInspector getTableObjectInspector(Properties schema) {
        return HiveUtil.getTableObjectInspector(HiveUtil.getDeserializer(schema));
    }

    public static StructObjectInspector getTableObjectInspector(Deserializer deserializer) {
        try {
            ObjectInspector inspector = deserializer.getObjectInspector();
            Preconditions.checkArgument((inspector.getCategory() == ObjectInspector.Category.STRUCT ? 1 : 0) != 0, (String)"expected STRUCT: %s", (Object[])new Object[]{inspector.getCategory()});
            return (StructObjectInspector)inspector;
        }
        catch (SerDeException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static List<? extends StructField> getTableStructFields(Table table) {
        return HiveUtil.getTableObjectInspector(MetaStoreUtils.getTableMetadata((Table)table)).getAllStructFieldRefs();
    }

    public static boolean isDeserializerClass(Properties schema, Class<?> deserializerClass) {
        return HiveUtil.getDeserializerClassName(schema).equals(deserializerClass.getName());
    }

    public static String getDeserializerClassName(Properties schema) {
        String name = schema.getProperty("serialization.lib");
        HiveUtil.checkCondition(name != null, HiveErrorCode.HIVE_INVALID_METADATA, "Table or partition is missing Hive deserializer property: %s", "serialization.lib");
        return name;
    }

    public static Deserializer getDeserializer(Properties schema) {
        String name = HiveUtil.getDeserializerClassName(schema);
        Deserializer deserializer = HiveUtil.createDeserializer(HiveUtil.getDeserializerClass(name));
        HiveUtil.initializeDeserializer(deserializer, schema);
        return deserializer;
    }

    private static Class<? extends Deserializer> getDeserializerClass(String name) {
        if ("parquet.hive.serde.ParquetHiveSerDe".equals(name)) {
            return ParquetHiveSerDe.class;
        }
        try {
            return Class.forName(name, true, JavaUtils.getClassLoader()).asSubclass(Deserializer.class);
        }
        catch (ClassNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_SERDE_NOT_FOUND, "deserializer does not exist: " + name);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("invalid deserializer class: " + name);
        }
    }

    private static Deserializer createDeserializer(Class<? extends Deserializer> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("error creating deserializer: " + clazz.getName(), e);
        }
    }

    private static void initializeDeserializer(Deserializer deserializer, Properties schema) {
        try {
            deserializer.initialize(new Configuration(false), schema);
        }
        catch (SerDeException e) {
            throw new RuntimeException("error initializing deserializer: " + deserializer.getClass().getName());
        }
    }

    public static boolean isHiveNull(byte[] bytes) {
        return bytes.length == 2 && bytes[0] == 92 && bytes[1] == 78;
    }

    public static SerializableNativeValue parsePartitionValue(String partitionName, String value, HiveType hiveType, DateTimeZone timeZone) {
        try {
            boolean isNull = "__HIVE_DEFAULT_PARTITION__".equals(value);
            if (HiveType.HIVE_BOOLEAN.equals(hiveType)) {
                if (isNull) {
                    return new SerializableNativeValue(Boolean.class, null);
                }
                if (value.isEmpty()) {
                    return new SerializableNativeValue(Boolean.class, (Comparable)Boolean.valueOf(false));
                }
                return new SerializableNativeValue(Boolean.class, (Comparable)Boolean.valueOf(Boolean.parseBoolean(value)));
            }
            if (HiveType.HIVE_BYTE.equals(hiveType) || HiveType.HIVE_SHORT.equals(hiveType) || HiveType.HIVE_INT.equals(hiveType) || HiveType.HIVE_LONG.equals(hiveType)) {
                if (isNull) {
                    return new SerializableNativeValue(Long.class, null);
                }
                if (value.isEmpty()) {
                    return new SerializableNativeValue(Long.class, (Comparable)Long.valueOf(0L));
                }
                return new SerializableNativeValue(Long.class, (Comparable)Long.valueOf(Long.parseLong(value)));
            }
            if (HiveType.HIVE_DATE.equals(hiveType)) {
                if (isNull) {
                    return new SerializableNativeValue(Long.class, null);
                }
                long dateInMillis = HiveUtil.parseHiveDate(value);
                return new SerializableNativeValue(Long.class, (Comparable)Long.valueOf(dateInMillis));
            }
            if (HiveType.HIVE_TIMESTAMP.equals(hiveType)) {
                if (isNull) {
                    return new SerializableNativeValue(Long.class, null);
                }
                return new SerializableNativeValue(Long.class, (Comparable)Long.valueOf(HiveUtil.parseHiveTimestamp(value, timeZone)));
            }
            if (HiveType.HIVE_FLOAT.equals(hiveType) || HiveType.HIVE_DOUBLE.equals(hiveType)) {
                if (isNull) {
                    return new SerializableNativeValue(Double.class, null);
                }
                if (value.isEmpty()) {
                    return new SerializableNativeValue(Double.class, (Comparable)Double.valueOf(0.0));
                }
                return new SerializableNativeValue(Double.class, (Comparable)Double.valueOf(Double.parseDouble(value)));
            }
            if (HiveType.HIVE_STRING.equals(hiveType)) {
                if (isNull) {
                    return new SerializableNativeValue(Slice.class, null);
                }
                return new SerializableNativeValue(Slice.class, (Comparable)Slices.utf8Slice((String)value));
            }
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for Hive type [%s] partition key: %s", value, hiveType, partitionName));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type [%s] for partition: %s", hiveType, partitionName));
    }

    public static boolean isPrestoView(Table table) {
        return "true".equals(table.getParameters().get(PRESTO_VIEW_FLAG));
    }

    public static String encodeViewData(String data) {
        return VIEW_PREFIX + Base64.getEncoder().encodeToString(data.getBytes(StandardCharsets.UTF_8)) + VIEW_SUFFIX;
    }

    public static String decodeViewData(String data) {
        HiveUtil.checkCondition(data.startsWith(VIEW_PREFIX), HiveErrorCode.HIVE_INVALID_VIEW_DATA, "View data missing prefix: %s", data);
        HiveUtil.checkCondition(data.endsWith(VIEW_SUFFIX), HiveErrorCode.HIVE_INVALID_VIEW_DATA, "View data missing suffix: %s", data);
        data = data.substring(VIEW_PREFIX.length());
        data = data.substring(0, data.length() - VIEW_SUFFIX.length());
        return new String(Base64.getDecoder().decode(data), StandardCharsets.UTF_8);
    }

    public static boolean isArrayType(Type type) {
        return type.getTypeSignature().getBase().equals("array");
    }

    public static boolean isMapType(Type type) {
        return type.getTypeSignature().getBase().equals("map");
    }

    public static boolean isStructuralType(Type type) {
        String baseName = type.getTypeSignature().getBase();
        return baseName.equals("map") || baseName.equals("array") || baseName.equals("row");
    }

    public static boolean isStructuralType(HiveType hiveType) {
        return hiveType.getCategory() == ObjectInspector.Category.LIST || hiveType.getCategory() == ObjectInspector.Category.MAP || hiveType.getCategory() == ObjectInspector.Category.STRUCT;
    }

    public static boolean booleanPartitionKey(String value, String name) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for BOOLEAN partition key: %s", value, name));
    }

    public static long bigintPartitionKey(String value, String name) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for BIGINT partition key: %s", value, name));
        }
    }

    public static double doublePartitionKey(String value, String name) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for DOUBLE partition key: %s", value, name));
        }
    }

    public static long datePartitionKey(String value, String name) {
        try {
            return HiveUtil.parseHiveDate(value);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for DATE partition key: %s", value, name));
        }
    }

    public static long timestampPartitionKey(String value, DateTimeZone zone, String name) {
        try {
            return HiveUtil.parseHiveTimestamp(value, zone);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for TIMESTAMP partition key: %s", value, name));
        }
    }

    public static SchemaTableName schemaTableName(ConnectorTableHandle tableHandle) {
        return Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle").getSchemaTableName();
    }

    public static List<HiveColumnHandle> hiveColumnHandles(TypeManager typeManager, String connectorId, Table table, boolean includeSampleWeight) {
        ImmutableList.Builder columns = ImmutableList.builder();
        int hiveColumnIndex = 0;
        for (StructField structField : HiveUtil.getTableStructFields(table)) {
            HiveType hiveType = HiveType.getHiveType(structField.getFieldObjectInspector());
            if (hiveType != null && (includeSampleWeight || !structField.getFieldName().equals("__presto__sample_weight__"))) {
                Type type = HiveType.getType(structField.getFieldObjectInspector(), typeManager);
                HiveUtil.checkCondition(type != null, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported Hive type: %s", structField.getFieldObjectInspector().getTypeName());
                columns.add((Object)new HiveColumnHandle(connectorId, structField.getFieldName(), hiveColumnIndex, hiveType, type.getTypeSignature(), hiveColumnIndex, false));
            }
            ++hiveColumnIndex;
        }
        columns.addAll(HiveUtil.getPartitionKeyColumnHandles(connectorId, table, hiveColumnIndex));
        return columns.build();
    }

    public static List<HiveColumnHandle> getPartitionKeyColumnHandles(String connectorId, Table table, int startOrdinal) {
        ImmutableList.Builder columns = ImmutableList.builder();
        List partitionKeys = table.getPartitionKeys();
        for (int i = 0; i < partitionKeys.size(); ++i) {
            FieldSchema field = (FieldSchema)partitionKeys.get(i);
            HiveType hiveType = HiveType.getSupportedHiveType(field.getType());
            columns.add((Object)new HiveColumnHandle(connectorId, field.getName(), startOrdinal + i, hiveType, HiveType.getType(field.getType()).getTypeSignature(), -1, true));
        }
        return columns.build();
    }

    public static String createPartitionName(Partition partition, Table table) {
        try {
            return Warehouse.makePartName((List)table.getPartitionKeys(), (List)partition.getValues());
        }
        catch (MetaException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, (Throwable)e);
        }
    }

    public static Slice base64Decode(byte[] bytes) {
        return Slices.wrappedBuffer((byte[])Base64.getDecoder().decode(bytes));
    }

    public static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String formatString, Object ... args) {
        if (!condition) {
            throw new PrestoException(errorCode, String.format(formatString, args));
        }
    }

    static {
        DateTimeParser[] timestampWithoutTimeZoneParser = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-M-d").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSSSSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSSSSSSS").getParser()};
        DateTimePrinter timestampWithoutTimeZonePrinter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSSSSSSS").getPrinter();
        HIVE_TIMESTAMP_PARSER = new DateTimeFormatterBuilder().append(timestampWithoutTimeZonePrinter, timestampWithoutTimeZoneParser).toFormatter().withZoneUTC();
    }
}

