/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import parquet.column.Dictionary;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.ParquetRecordReader;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ContextUtil;
import parquet.io.api.Binary;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;
import parquet.io.api.PrimitiveConverter;
import parquet.io.api.RecordMaterializer;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.Type;

class ParquetHiveRecordCursor
extends HiveRecordCursor {
    private final ParquetRecordReader<FakeParquetRecord> recordReader;
    private final String[] names;
    private final com.facebook.presto.spi.type.Type[] types;
    private final boolean[] isPartitionColumn;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final Object[] objects;
    private final boolean[] nulls;
    private final boolean[] nullsRowDefault;
    private final long totalBytes;
    private long completedBytes;
    private boolean closed;

    public ParquetHiveRecordCursor(Configuration configuration, Path path, long start, long length, Properties splitSchema, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, boolean useParquetColumnNames, TypeManager typeManager) {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Preconditions.checkNotNull((Object)splitSchema, (Object)"splitSchema is null");
        Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        this.totalBytes = length;
        int size = columns.size();
        this.names = new String[size];
        this.types = new com.facebook.presto.spi.type.Type[size];
        this.isPartitionColumn = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.objects = new Object[size];
        this.nulls = new boolean[size];
        this.nullsRowDefault = new boolean[size];
        for (int i = 0; i < columns.size(); ++i) {
            HiveColumnHandle column = columns.get(i);
            this.names[i] = column.getName();
            this.types[i] = typeManager.getType(column.getTypeSignature());
            this.isPartitionColumn[i] = column.isPartitionKey();
            this.nullsRowDefault[i] = !column.isPartitionKey();
        }
        this.recordReader = this.createParquetRecordReader(configuration, path, start, length, columns, useParquetColumnNames);
        ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            if (!column.isPartitionKey()) continue;
            HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(column.getName());
            Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"Unknown partition key %s", (Object[])new Object[]{column.getName()});
            byte[] bytes = partitionKey.getValue().getBytes(StandardCharsets.UTF_8);
            String name = this.names[columnIndex];
            com.facebook.presto.spi.type.Type type = this.types[columnIndex];
            if (HiveUtil.isHiveNull(bytes)) {
                this.nullsRowDefault[columnIndex] = true;
                continue;
            }
            if (type.equals(BooleanType.BOOLEAN)) {
                this.booleans[columnIndex] = HiveUtil.booleanPartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (type.equals(BigintType.BIGINT)) {
                this.longs[columnIndex] = HiveUtil.bigintPartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (type.equals(DoubleType.DOUBLE)) {
                this.doubles[columnIndex] = HiveUtil.doublePartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (type.equals(VarcharType.VARCHAR)) {
                this.slices[columnIndex] = Slices.wrappedBuffer((byte[])bytes);
                continue;
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for partition key: %s", type.getDisplayName(), name));
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException newCompletedBytes) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public com.facebook.presto.spi.type.Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            System.arraycopy(this.nullsRowDefault, 0, this.nulls, 0, this.isPartitionColumn.length);
            if (this.closed || !this.recordReader.nextKeyValue()) {
                this.close();
                return false;
            }
            return true;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Boolean.TYPE);
        return this.booleans[fieldId];
    }

    public long getLong(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Long.TYPE);
        return this.longs[fieldId];
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Double.TYPE);
        return this.doubles[fieldId];
    }

    public Slice getSlice(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Slice.class);
        return this.slices[fieldId];
    }

    public Object getObject(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Block.class);
        return this.objects[fieldId];
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        return this.nulls[fieldId];
    }

    private void validateType(int fieldId, Class<?> javaType) {
        if (this.types[fieldId].getJavaType() != javaType) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", javaType.getName(), this.types[fieldId].getJavaType().getName(), fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private ParquetRecordReader<FakeParquetRecord> createParquetRecordReader(Configuration configuration, Path path, long start, long length, List<HiveColumnHandle> columns, boolean useParquetColumnNames) {
        try {
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((Configuration)configuration, (Path)path);
            List blocks = parquetMetadata.getBlocks();
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            PrestoReadSupport readSupport = new PrestoReadSupport(useParquetColumnNames, columns, fileMetaData.getSchema());
            ReadSupport.ReadContext readContext = readSupport.init(configuration, fileMetaData.getKeyValueMetaData(), fileMetaData.getSchema());
            ArrayList<BlockMetaData> splitGroup = new ArrayList<BlockMetaData>();
            long splitStart = start;
            long splitLength = length;
            for (BlockMetaData block : blocks) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < splitStart || firstDataPage >= splitStart + splitLength) continue;
                splitGroup.add(block);
            }
            ParquetInputSplit split = new ParquetInputSplit(path, splitStart, splitLength, null, splitGroup, readContext.getRequestedSchema().toString(), fileMetaData.getSchema().toString(), fileMetaData.getKeyValueMetaData(), readContext.getReadSupportMetadata());
            TaskAttemptContext taskContext = ContextUtil.newTaskAttemptContext((Configuration)configuration, (TaskAttemptID)new TaskAttemptID());
            PrestoParquetRecordReader realReader = new PrestoParquetRecordReader(readSupport);
            realReader.initialize((InputSplit)split, taskContext);
            return realReader;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static BlockConverter createConverter(com.facebook.presto.spi.type.Type prestoType, String columnName, Type type) {
        if (type.isPrimitive()) {
            return new ParquetPrimitiveConverter();
        }
        if (type.getOriginalType() == OriginalType.LIST) {
            return new ParquetListConverter(prestoType, columnName, type.asGroupType());
        }
        if (type.getOriginalType() == OriginalType.MAP) {
            return new ParquetMapConverter(prestoType, columnName, type.asGroupType());
        }
        if (type.getOriginalType() == null) {
            return new ParquetStructConverter(prestoType, columnName, type.asGroupType());
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private static class ParquetPrimitiveConverter
    extends PrimitiveConverter
    implements BlockConverter {
        private BlockBuilder builder;
        private boolean wroteValue;

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = (BlockBuilder)Preconditions.checkNotNull((Object)builder, (Object)"parent builder is null");
            this.wroteValue = false;
        }

        @Override
        public void afterValue() {
            if (this.wroteValue) {
                return;
            }
            this.builder.appendNull();
        }

        public boolean isPrimitive() {
            return true;
        }

        public PrimitiveConverter asPrimitiveConverter() {
            return this;
        }

        public boolean hasDictionarySupport() {
            return false;
        }

        public void setDictionary(Dictionary dictionary) {
        }

        public void addValueFromDictionary(int dictionaryId) {
        }

        public void addBoolean(boolean value) {
            BooleanType.BOOLEAN.writeBoolean(this.builder, value);
            this.wroteValue = true;
        }

        public void addDouble(double value) {
            DoubleType.DOUBLE.writeDouble(this.builder, value);
            this.wroteValue = true;
        }

        public void addLong(long value) {
            BigintType.BIGINT.writeLong(this.builder, value);
            this.wroteValue = true;
        }

        public void addBinary(Binary value) {
            VarbinaryType.VARBINARY.writeSlice(this.builder, Slices.wrappedBuffer((byte[])value.getBytes()));
            this.wroteValue = true;
        }

        public void addFloat(float value) {
            DoubleType.DOUBLE.writeDouble(this.builder, (double)value);
            this.wroteValue = true;
        }

        public void addInt(int value) {
            BigintType.BIGINT.writeLong(this.builder, (long)value);
            this.wroteValue = true;
        }
    }

    private static class ParquetMapEntryConverter
    extends GroupConverter
    implements BlockConverter {
        private final BlockConverter keyConverter;
        private final BlockConverter valueConverter;
        private BlockBuilder builder;

        public ParquetMapEntryConverter(com.facebook.presto.spi.type.Type prestoType, String columnName, GroupType entryType) {
            GroupType entryGroupType;
            Preconditions.checkArgument((boolean)"map".equals(prestoType.getTypeSignature().getBase()));
            if (entryType.getOriginalType() != null) {
                Preconditions.checkArgument((entryType.getOriginalType() == OriginalType.MAP_KEY_VALUE ? 1 : 0) != 0, (String)"Expected MAP column '%s' field to be type %s, but is %s", (Object[])new Object[]{columnName, OriginalType.MAP_KEY_VALUE, entryType});
            }
            Preconditions.checkArgument(((entryGroupType = entryType.asGroupType()).getFieldCount() == 2 ? 1 : 0) != 0, (String)"Expected MAP column '%s' entry to have two fields, but has %s fields", (Object[])new Object[]{columnName, entryGroupType.getFieldCount()});
            Preconditions.checkArgument((boolean)entryGroupType.getFieldName(0).equals("key"), (String)"Expected MAP column '%s' entry field 0 to be named 'key', but is named %s", (Object[])new Object[]{columnName, entryGroupType.getFieldName(0)});
            Preconditions.checkArgument((boolean)entryGroupType.getFieldName(1).equals("value"), (String)"Expected MAP column '%s' entry field 1 to be named 'value', but is named %s", (Object[])new Object[]{columnName, entryGroupType.getFieldName(1)});
            Preconditions.checkArgument((boolean)entryGroupType.getType(0).isPrimitive(), (String)"Expected MAP column '%s' entry field 0 to be primitive, but is named %s", (Object[])new Object[]{columnName, entryGroupType.getType(0)});
            this.keyConverter = ParquetHiveRecordCursor.createConverter((com.facebook.presto.spi.type.Type)prestoType.getTypeParameters().get(0), columnName + ".key", (Type)entryGroupType.getFields().get(0));
            this.valueConverter = ParquetHiveRecordCursor.createConverter((com.facebook.presto.spi.type.Type)prestoType.getTypeParameters().get(1), columnName + ".value", (Type)entryGroupType.getFields().get(1));
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.keyConverter;
            }
            if (fieldIndex == 1) {
                return (Converter)this.valueConverter;
            }
            throw new IllegalArgumentException("Map entry field must be 0 or 1 not " + fieldIndex);
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public void start() {
            this.keyConverter.beforeValue(this.builder);
            this.valueConverter.beforeValue(this.builder);
        }

        public void end() {
            this.keyConverter.afterValue();
            this.valueConverter.afterValue();
        }

        @Override
        public void afterValue() {
        }
    }

    private static class ParquetMapConverter
    extends GroupedConverter {
        private static final int NULL_BUILDER_POSITIONS_THRESHOLD = 100;
        private static final int NULL_BUILDER_SIZE_IN_BYTES_THRESHOLD = 32768;
        private final com.facebook.presto.spi.type.Type mapType;
        private final ParquetMapEntryConverter entryConverter;
        private BlockBuilder builder;
        private BlockBuilder nullBuilder;
        private BlockBuilder currentEntryBuilder;

        public ParquetMapConverter(com.facebook.presto.spi.type.Type type, String columnName, GroupType mapType) {
            Preconditions.checkArgument((mapType.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Expected MAP column '%s' to only have one field, but has %s fields", (Object[])new Object[]{mapType.getName(), mapType.getFieldCount()});
            this.mapType = type;
            Type entryType = (Type)mapType.getFields().get(0);
            this.entryConverter = new ParquetMapEntryConverter(type, columnName + ".entry", entryType.asGroupType());
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return this.entryConverter;
            }
            throw new IllegalArgumentException("Map field must be 0 not " + fieldIndex);
        }

        public void start() {
            if (this.builder == null) {
                if (this.nullBuilder == null || this.nullBuilder.getPositionCount() >= 100 && this.nullBuilder.getSizeInBytes() >= 32768) {
                    this.nullBuilder = this.mapType.createBlockBuilder(new BlockBuilderStatus(), 100);
                }
                this.currentEntryBuilder = this.nullBuilder.beginBlockEntry();
            } else {
                this.currentEntryBuilder = this.builder.beginBlockEntry();
            }
            this.entryConverter.beforeValue(this.currentEntryBuilder);
        }

        public void end() {
            this.entryConverter.afterValue();
            if (this.builder == null) {
                this.nullBuilder.closeEntry();
            } else {
                this.builder.closeEntry();
            }
        }

        @Override
        public void afterValue() {
        }

        @Override
        public Block getBlock() {
            Preconditions.checkState((this.builder == null && this.nullBuilder != null ? 1 : 0) != 0);
            return (Block)this.nullBuilder.getObject(this.nullBuilder.getPositionCount() - 1, Block.class);
        }
    }

    private static class ParquetListEntryConverter
    extends GroupConverter
    implements BlockConverter {
        private final BlockConverter elementConverter;
        private BlockBuilder builder;

        public ParquetListEntryConverter(com.facebook.presto.spi.type.Type prestoType, String columnName, GroupType elementType) {
            Preconditions.checkArgument((elementType.getOriginalType() == null ? 1 : 0) != 0, (String)"Expected LIST column '%s' field to be type STRUCT, but is %s", (Object[])new Object[]{columnName, elementType});
            Preconditions.checkArgument((elementType.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Expected LIST column '%s' element to have one field, but has %s fields", (Object[])new Object[]{columnName, elementType.getFieldCount()});
            this.elementConverter = ParquetHiveRecordCursor.createConverter(prestoType, columnName + ".element", elementType.getType(0));
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.elementConverter;
            }
            throw new IllegalArgumentException("LIST entry field must be 0 not " + fieldIndex);
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public void start() {
            this.elementConverter.beforeValue(this.builder);
        }

        public void end() {
            this.elementConverter.afterValue();
        }

        @Override
        public void afterValue() {
        }
    }

    private static class ParquetListConverter
    extends GroupedConverter {
        private static final int NULL_BUILDER_POSITIONS_THRESHOLD = 100;
        private static final int NULL_BUILDER_SIZE_IN_BYTES_THRESHOLD = 32768;
        private final com.facebook.presto.spi.type.Type arrayType;
        private final BlockConverter elementConverter;
        private BlockBuilder builder;
        private BlockBuilder nullBuilder;
        private BlockBuilder currentEntryBuilder;

        public ParquetListConverter(com.facebook.presto.spi.type.Type prestoType, String columnName, GroupType listType) {
            Preconditions.checkArgument((listType.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Expected LIST column '%s' to only have one field, but has %s fields", (Object[])new Object[]{columnName, listType.getFieldCount()});
            Preconditions.checkArgument((boolean)"array".equals(prestoType.getTypeSignature().getBase()));
            this.arrayType = prestoType;
            Type elementType = listType.getType(0);
            this.elementConverter = this.isElementType(elementType, listType.getName()) ? ParquetHiveRecordCursor.createConverter((com.facebook.presto.spi.type.Type)prestoType.getTypeParameters().get(0), columnName + ".element", elementType) : new ParquetListEntryConverter((com.facebook.presto.spi.type.Type)prestoType.getTypeParameters().get(0), columnName, elementType.asGroupType());
        }

        private boolean isElementType(Type repeatedType, String parentName) {
            if (repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1) {
                return true;
            }
            if (repeatedType.getName().equals("array")) {
                return true;
            }
            return repeatedType.getName().equals(parentName + "_tuple");
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.elementConverter;
            }
            throw new IllegalArgumentException("LIST field must be 0 not " + fieldIndex);
        }

        public void start() {
            if (this.builder == null) {
                if (this.nullBuilder == null || this.nullBuilder.getPositionCount() >= 100 && this.nullBuilder.getSizeInBytes() >= 32768) {
                    this.nullBuilder = this.arrayType.createBlockBuilder(new BlockBuilderStatus(), 100);
                }
                this.currentEntryBuilder = this.nullBuilder.beginBlockEntry();
            } else {
                this.currentEntryBuilder = this.builder.beginBlockEntry();
            }
            this.elementConverter.beforeValue(this.currentEntryBuilder);
        }

        public void end() {
            this.elementConverter.afterValue();
            if (this.builder == null) {
                this.nullBuilder.closeEntry();
            } else {
                this.builder.closeEntry();
            }
        }

        @Override
        public void afterValue() {
        }

        @Override
        public Block getBlock() {
            Preconditions.checkState((this.builder == null && this.nullBuilder != null ? 1 : 0) != 0);
            return (Block)this.nullBuilder.getObject(this.nullBuilder.getPositionCount() - 1, Block.class);
        }
    }

    private static class ParquetStructConverter
    extends GroupedConverter {
        private static final int NULL_BUILDER_POSITIONS_THRESHOLD = 100;
        private static final int NULL_BUILDER_SIZE_IN_BYTES_THRESHOLD = 32768;
        private final com.facebook.presto.spi.type.Type rowType;
        private final List<BlockConverter> converters;
        private BlockBuilder builder;
        private BlockBuilder nullBuilder;
        private BlockBuilder currentEntryBuilder;

        public ParquetStructConverter(com.facebook.presto.spi.type.Type prestoType, String columnName, GroupType entryType) {
            Preconditions.checkArgument((boolean)"row".equals(prestoType.getTypeSignature().getBase()));
            List prestoTypeParameters = prestoType.getTypeParameters();
            List fieldTypes = entryType.getFields();
            Preconditions.checkArgument((prestoTypeParameters.size() == fieldTypes.size() ? 1 : 0) != 0);
            this.rowType = prestoType;
            ImmutableList.Builder converters = ImmutableList.builder();
            for (int i = 0; i < prestoTypeParameters.size(); ++i) {
                Type fieldType = (Type)fieldTypes.get(i);
                converters.add((Object)ParquetHiveRecordCursor.createConverter((com.facebook.presto.spi.type.Type)prestoTypeParameters.get(i), columnName + "." + fieldType.getName(), fieldType));
            }
            this.converters = converters.build();
        }

        public Converter getConverter(int fieldIndex) {
            return (Converter)this.converters.get(fieldIndex);
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public void start() {
            if (this.builder == null) {
                if (this.nullBuilder == null || this.nullBuilder.getPositionCount() >= 100 && this.nullBuilder.getSizeInBytes() >= 32768) {
                    this.nullBuilder = this.rowType.createBlockBuilder(new BlockBuilderStatus(), 100);
                }
                this.currentEntryBuilder = this.nullBuilder.beginBlockEntry();
            } else {
                this.currentEntryBuilder = this.builder.beginBlockEntry();
            }
            for (BlockConverter converter : this.converters) {
                converter.beforeValue(this.currentEntryBuilder);
            }
        }

        public void end() {
            for (BlockConverter converter : this.converters) {
                converter.afterValue();
            }
            if (this.builder == null) {
                this.nullBuilder.closeEntry();
            } else {
                this.builder.closeEntry();
            }
        }

        @Override
        public void afterValue() {
        }

        @Override
        public Block getBlock() {
            Preconditions.checkState((this.builder == null && this.nullBuilder != null ? 1 : 0) != 0);
            return (Block)this.nullBuilder.getObject(this.nullBuilder.getPositionCount() - 1, Block.class);
        }
    }

    private static abstract class GroupedConverter
    extends GroupConverter
    implements BlockConverter {
        private GroupedConverter() {
        }

        public abstract Block getBlock();
    }

    private static interface BlockConverter {
        public void beforeValue(BlockBuilder var1);

        public void afterValue();
    }

    public class ParquetColumnConverter
    extends GroupConverter {
        private final GroupedConverter groupedConverter;
        private final int fieldIndex;

        public ParquetColumnConverter(GroupedConverter groupedConverter, int fieldIndex) {
            this.groupedConverter = groupedConverter;
            this.fieldIndex = fieldIndex;
        }

        public Converter getConverter(int fieldIndex) {
            return this.groupedConverter.getConverter(fieldIndex);
        }

        public void start() {
            this.groupedConverter.beforeValue(null);
            this.groupedConverter.start();
        }

        public void end() {
            this.groupedConverter.afterValue();
            this.groupedConverter.end();
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).objects[this.fieldIndex] = this.groupedConverter.getBlock();
        }
    }

    private class ParquetPrimitiveColumnConverter
    extends PrimitiveConverter {
        private final int fieldIndex;

        private ParquetPrimitiveColumnConverter(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        public boolean isPrimitive() {
            return true;
        }

        public PrimitiveConverter asPrimitiveConverter() {
            return this;
        }

        public boolean hasDictionarySupport() {
            return false;
        }

        public void setDictionary(Dictionary dictionary) {
        }

        public void addValueFromDictionary(int dictionaryId) {
        }

        public void addBoolean(boolean value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).booleans[this.fieldIndex] = value;
        }

        public void addDouble(double value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).doubles[this.fieldIndex] = value;
        }

        public void addLong(long value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = value;
        }

        public void addBinary(Binary value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).slices[this.fieldIndex] = Slices.wrappedBuffer((byte[])value.getBytes());
        }

        public void addFloat(float value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).doubles[this.fieldIndex] = value;
        }

        public void addInt(int value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = value;
        }
    }

    public static class ParquetGroupConverter
    extends GroupConverter {
        private final List<Converter> converters;

        public ParquetGroupConverter(List<Converter> converters) {
            this.converters = converters;
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters.get(fieldIndex);
        }

        public void start() {
        }

        public void end() {
        }
    }

    private static enum FakeParquetRecord {
        MATERIALIZE_RECORD;

    }

    private static class ParquetRecordConverter
    extends RecordMaterializer<FakeParquetRecord> {
        private final ParquetGroupConverter groupConverter;

        public ParquetRecordConverter(List<Converter> converters) {
            this.groupConverter = new ParquetGroupConverter(converters);
        }

        public FakeParquetRecord getCurrentRecord() {
            return FakeParquetRecord.MATERIALIZE_RECORD;
        }

        public GroupConverter getRootConverter() {
            return this.groupConverter;
        }
    }

    public final class PrestoReadSupport
    extends ReadSupport<FakeParquetRecord> {
        private final boolean useParquetColumnNames;
        private final List<HiveColumnHandle> columns;
        private final List<Converter> converters;

        public PrestoReadSupport(boolean useParquetColumnNames, List<HiveColumnHandle> columns, MessageType messageType) {
            this.columns = columns;
            this.useParquetColumnNames = useParquetColumnNames;
            ImmutableList.Builder converters = ImmutableList.builder();
            block10: for (int i = 0; i < columns.size(); ++i) {
                Type parquetType;
                HiveColumnHandle column = columns.get(i);
                if (column.isPartitionKey() || (parquetType = this.getParquetType(column, messageType)) == null) continue;
                if (parquetType.isPrimitive()) {
                    converters.add((Object)new ParquetPrimitiveColumnConverter(i));
                    continue;
                }
                GroupType groupType = parquetType.asGroupType();
                switch (column.getTypeSignature().getBase()) {
                    case "array": {
                        ParquetColumnConverter listConverter = new ParquetColumnConverter(new ParquetListConverter(ParquetHiveRecordCursor.this.types[i], groupType.getName(), groupType), i);
                        converters.add((Object)listConverter);
                        continue block10;
                    }
                    case "map": {
                        ParquetColumnConverter mapConverter = new ParquetColumnConverter(new ParquetMapConverter(ParquetHiveRecordCursor.this.types[i], groupType.getName(), groupType), i);
                        converters.add((Object)mapConverter);
                        continue block10;
                    }
                    case "row": {
                        ParquetColumnConverter rowConverter = new ParquetColumnConverter(new ParquetStructConverter(ParquetHiveRecordCursor.this.types[i], groupType.getName(), groupType), i);
                        converters.add((Object)rowConverter);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Group column " + groupType.getName() + " type " + groupType.getOriginalType() + " not supported");
                    }
                }
            }
            this.converters = converters.build();
        }

        public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType messageType) {
            List fields = this.columns.stream().filter(column -> !column.isPartitionKey()).map(column -> this.getParquetType((HiveColumnHandle)column, messageType)).filter(Objects::nonNull).collect(Collectors.toList());
            MessageType requestedProjection = new MessageType(messageType.getName(), fields);
            return new ReadSupport.ReadContext(requestedProjection);
        }

        public RecordMaterializer<FakeParquetRecord> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
            return new ParquetRecordConverter(this.converters);
        }

        private Type getParquetType(HiveColumnHandle column, MessageType messageType) {
            if (this.useParquetColumnNames) {
                if (messageType.containsField(column.getName())) {
                    return messageType.getType(column.getName());
                }
                return null;
            }
            if (column.getHiveColumnIndex() < messageType.getFieldCount()) {
                return messageType.getType(column.getHiveColumnIndex());
            }
            return null;
        }
    }

    public class PrestoParquetRecordReader
    extends ParquetRecordReader<FakeParquetRecord> {
        public PrestoParquetRecordReader(PrestoReadSupport readSupport) {
            super((ReadSupport)readSupport);
        }
    }
}

