/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.amazonaws.AbortedException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.Upload;
import com.facebook.presto.hadoop.HadoopFileStatus;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.PrestoS3FileSystemMetricCollector;
import com.facebook.presto.hive.PrestoS3FileSystemStats;
import com.facebook.presto.hive.RetryDriver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.s3.S3Credentials;
import org.apache.hadoop.util.Progressable;

public class PrestoS3FileSystem
extends FileSystem {
    private static final Logger log = Logger.get(PrestoS3FileSystem.class);
    private static final PrestoS3FileSystemStats STATS = new PrestoS3FileSystemStats();
    private static final PrestoS3FileSystemMetricCollector METRIC_COLLECTOR = new PrestoS3FileSystemMetricCollector(STATS);
    private static final String DIRECTORY_SUFFIX = "_$folder$";
    public static final String S3_SSL_ENABLED = "presto.s3.ssl.enabled";
    public static final String S3_MAX_ERROR_RETRIES = "presto.s3.max-error-retries";
    public static final String S3_MAX_CLIENT_RETRIES = "presto.s3.max-client-retries";
    public static final String S3_MAX_BACKOFF_TIME = "presto.s3.max-backoff-time";
    public static final String S3_MAX_RETRY_TIME = "presto.s3.max-retry-time";
    public static final String S3_CONNECT_TIMEOUT = "presto.s3.connect-timeout";
    public static final String S3_SOCKET_TIMEOUT = "presto.s3.socket-timeout";
    public static final String S3_MAX_CONNECTIONS = "presto.s3.max-connections";
    public static final String S3_STAGING_DIRECTORY = "presto.s3.staging-directory";
    public static final String S3_MULTIPART_MIN_FILE_SIZE = "presto.s3.multipart.min-file-size";
    public static final String S3_MULTIPART_MIN_PART_SIZE = "presto.s3.multipart.min-part-size";
    public static final String S3_USE_INSTANCE_CREDENTIALS = "presto.s3.use-instance-credentials";
    private static final DataSize BLOCK_SIZE = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private static final DataSize MAX_SKIP_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private final TransferManagerConfiguration transferConfig = new TransferManagerConfiguration();
    private URI uri;
    private Path workingDirectory;
    private AmazonS3 s3;
    private File stagingDirectory;
    private int maxAttempts;
    private Duration maxBackoffTime;
    private Duration maxRetryTime;
    private boolean useInstanceCredentials;

    public static PrestoS3FileSystemStats getFileSystemStats() {
        return STATS;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        Preconditions.checkNotNull((Object)conf, (Object)"conf is null");
        super.initialize(uri, conf);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDirectory = new Path("/").makeQualified(this.uri, new Path("/"));
        HiveClientConfig defaults = new HiveClientConfig();
        this.stagingDirectory = new File(conf.get(S3_STAGING_DIRECTORY, defaults.getS3StagingDirectory().toString()));
        this.maxAttempts = conf.getInt(S3_MAX_CLIENT_RETRIES, defaults.getS3MaxClientRetries()) + 1;
        this.maxBackoffTime = Duration.valueOf((String)conf.get(S3_MAX_BACKOFF_TIME, defaults.getS3MaxBackoffTime().toString()));
        this.maxRetryTime = Duration.valueOf((String)conf.get(S3_MAX_RETRY_TIME, defaults.getS3MaxRetryTime().toString()));
        int maxErrorRetries = conf.getInt(S3_MAX_ERROR_RETRIES, defaults.getS3MaxErrorRetries());
        boolean sslEnabled = conf.getBoolean(S3_SSL_ENABLED, defaults.isS3SslEnabled());
        Duration connectTimeout = Duration.valueOf((String)conf.get(S3_CONNECT_TIMEOUT, defaults.getS3ConnectTimeout().toString()));
        Duration socketTimeout = Duration.valueOf((String)conf.get(S3_SOCKET_TIMEOUT, defaults.getS3SocketTimeout().toString()));
        int maxConnections = conf.getInt(S3_MAX_CONNECTIONS, defaults.getS3MaxConnections());
        long minFileSize = conf.getLong(S3_MULTIPART_MIN_FILE_SIZE, defaults.getS3MultipartMinFileSize().toBytes());
        long minPartSize = conf.getLong(S3_MULTIPART_MIN_PART_SIZE, defaults.getS3MultipartMinPartSize().toBytes());
        this.useInstanceCredentials = conf.getBoolean(S3_USE_INSTANCE_CREDENTIALS, defaults.isS3UseInstanceCredentials());
        ClientConfiguration configuration = new ClientConfiguration().withMaxErrorRetry(maxErrorRetries).withProtocol(sslEnabled ? Protocol.HTTPS : Protocol.HTTP).withConnectionTimeout(Ints.checkedCast((long)connectTimeout.toMillis())).withSocketTimeout(Ints.checkedCast((long)socketTimeout.toMillis())).withMaxConnections(maxConnections);
        this.s3 = this.createAmazonS3Client(uri, conf, configuration);
        this.transferConfig.setMultipartUploadThreshold(minFileSize);
        this.transferConfig.setMinimumUploadPartSize(minPartSize);
    }

    public URI getUri() {
        return this.uri;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Path path) {
        this.workingDirectory = path;
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        STATS.newListStatusCall();
        ArrayList<Object> list = new ArrayList<Object>();
        RemoteIterator<LocatedFileStatus> iterator = this.listLocatedStatus(path);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return (FileStatus[])Iterables.toArray(list, LocatedFileStatus.class);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path path) {
        STATS.newListLocatedStatusCall();
        return new RemoteIterator<LocatedFileStatus>(){
            private final Iterator<LocatedFileStatus> iterator;
            {
                this.iterator = PrestoS3FileSystem.this.listPrefix(path);
            }

            public boolean hasNext() throws IOException {
                try {
                    return this.iterator.hasNext();
                }
                catch (AmazonClientException e) {
                    throw new IOException(e);
                }
            }

            public LocatedFileStatus next() throws IOException {
                try {
                    return this.iterator.next();
                }
                catch (AmazonClientException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        if (path.getName().isEmpty()) {
            if (this.getS3ObjectMetadata(path) != null) {
                return new FileStatus(0L, true, 1, 0L, 0L, this.qualifiedPath(path));
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        ObjectMetadata metadata = this.getS3ObjectMetadata(path);
        if (metadata == null) {
            Iterator<LocatedFileStatus> iterator = this.listPrefix(path);
            if (iterator.hasNext()) {
                return new FileStatus(0L, true, 1, 0L, 0L, this.qualifiedPath(path));
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        return new FileStatus(metadata.getContentLength(), false, 1, BLOCK_SIZE.toBytes(), PrestoS3FileSystem.lastModifiedTime(metadata), this.qualifiedPath(path));
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new PrestoS3InputStream(this.s3, this.uri.getHost(), path, this.maxAttempts, this.maxBackoffTime, this.maxRetryTime), bufferSize));
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (!overwrite && this.exists(path)) {
            throw new IOException("File already exists:" + path);
        }
        Files.createDirectories(this.stagingDirectory.toPath(), new FileAttribute[0]);
        File tempFile = Files.createTempFile(this.stagingDirectory.toPath(), "presto-s3-", ".tmp", new FileAttribute[0]).toFile();
        String key = PrestoS3FileSystem.keyFromPath(this.qualifiedPath(path));
        return new FSDataOutputStream((OutputStream)new PrestoS3OutputStream(this.s3, this.transferConfig, this.uri.getHost(), key, tempFile), this.statistics);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
        throw new UnsupportedOperationException("append");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        boolean srcDirectory;
        try {
            srcDirectory = this.directory(src);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            if (!this.directory(dst)) {
                return PrestoS3FileSystem.keysEqual(src, dst);
            }
            dst = new Path(dst, src.getName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (PrestoS3FileSystem.keysEqual(src, dst)) {
            return true;
        }
        if (srcDirectory) {
            for (FileStatus file : this.listStatus(src)) {
                this.rename(file.getPath(), new Path(dst, file.getPath().getName()));
            }
            this.deleteObject(PrestoS3FileSystem.keyFromPath(src) + DIRECTORY_SUFFIX);
        } else {
            this.s3.copyObject(this.uri.getHost(), PrestoS3FileSystem.keyFromPath(src), this.uri.getHost(), PrestoS3FileSystem.keyFromPath(dst));
            this.delete(src, true);
        }
        return true;
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        try {
            if (!this.directory(path)) {
                return this.deleteObject(PrestoS3FileSystem.keyFromPath(path));
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (!recursive) {
            throw new IOException("Directory " + path + " is not empty");
        }
        for (FileStatus file : this.listStatus(path)) {
            this.delete(file.getPath(), true);
        }
        this.deleteObject(PrestoS3FileSystem.keyFromPath(path) + DIRECTORY_SUFFIX);
        return true;
    }

    private boolean directory(Path path) throws IOException {
        return HadoopFileStatus.isDirectory((FileStatus)this.getFileStatus(path));
    }

    private boolean deleteObject(String key) {
        try {
            this.s3.deleteObject(this.uri.getHost(), key);
            return true;
        }
        catch (AmazonClientException e) {
            return false;
        }
    }

    public boolean mkdirs(Path f, FsPermission permission) {
        return true;
    }

    private Iterator<LocatedFileStatus> listPrefix(Path path) {
        String key = PrestoS3FileSystem.keyFromPath(path);
        if (!key.isEmpty()) {
            key = key + "/";
        }
        ListObjectsRequest request = new ListObjectsRequest().withBucketName(this.uri.getHost()).withPrefix(key).withDelimiter("/");
        STATS.newListObjectsCall();
        AbstractSequentialIterator<ObjectListing> listings = new AbstractSequentialIterator<ObjectListing>(this.s3.listObjects(request)){

            protected ObjectListing computeNext(ObjectListing previous) {
                if (!previous.isTruncated()) {
                    return null;
                }
                return PrestoS3FileSystem.this.s3.listNextBatchOfObjects(previous);
            }
        };
        return Iterators.concat((Iterator)Iterators.transform((Iterator)listings, this::statusFromListing));
    }

    private Iterator<LocatedFileStatus> statusFromListing(ObjectListing listing) {
        return Iterators.concat(this.statusFromPrefixes(listing.getCommonPrefixes()), this.statusFromObjects(listing.getObjectSummaries()));
    }

    private Iterator<LocatedFileStatus> statusFromPrefixes(List<String> prefixes) {
        ArrayList<LocatedFileStatus> list = new ArrayList<LocatedFileStatus>();
        for (String prefix : prefixes) {
            Path path = this.qualifiedPath(new Path("/" + prefix));
            FileStatus status = new FileStatus(0L, true, 1, 0L, 0L, path);
            list.add(this.createLocatedFileStatus(status));
        }
        return list.iterator();
    }

    private Iterator<LocatedFileStatus> statusFromObjects(List<S3ObjectSummary> objects) {
        return objects.stream().filter(object -> !object.getKey().endsWith("/")).map(object -> new FileStatus(object.getSize(), false, 1, BLOCK_SIZE.toBytes(), object.getLastModified().getTime(), this.qualifiedPath(new Path("/" + object.getKey())))).map(this::createLocatedFileStatus).iterator();
    }

    @VisibleForTesting
    ObjectMetadata getS3ObjectMetadata(Path path) throws IOException {
        try {
            return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(new Duration(1.0, TimeUnit.SECONDS), this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class).onRetry(STATS::newGetMetadataRetry).run("getS3ObjectMetadata", () -> {
                try {
                    STATS.newMetadataCall();
                    return this.s3.getObjectMetadata(this.uri.getHost(), PrestoS3FileSystem.keyFromPath(path));
                }
                catch (RuntimeException e) {
                    STATS.newGetMetadataError();
                    if (e instanceof AmazonS3Exception) {
                        switch (((AmazonS3Exception)e).getStatusCode()) {
                            case 404: {
                                return null;
                            }
                            case 403: {
                                throw new UnrecoverableS3OperationException(e);
                            }
                        }
                    }
                    throw Throwables.propagate((Throwable)e);
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Path qualifiedPath(Path path) {
        return path.makeQualified(this.uri, this.getWorkingDirectory());
    }

    private LocatedFileStatus createLocatedFileStatus(FileStatus status) {
        try {
            BlockLocation[] fakeLocation = this.getFileBlockLocations(status, 0L, status.getLen());
            return new LocatedFileStatus(status, fakeLocation);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static long lastModifiedTime(ObjectMetadata metadata) {
        Date date = metadata.getLastModified();
        return date != null ? date.getTime() : 0L;
    }

    private static boolean keysEqual(Path p1, Path p2) {
        return PrestoS3FileSystem.keyFromPath(p1).equals(PrestoS3FileSystem.keyFromPath(p2));
    }

    private static String keyFromPath(Path path) {
        Preconditions.checkArgument((boolean)path.isAbsolute(), (String)"Path is not absolute: %s", (Object[])new Object[]{path});
        String key = Strings.nullToEmpty((String)path.toUri().getPath());
        if (key.startsWith("/")) {
            key = key.substring(1);
        }
        if (key.endsWith("/")) {
            key = key.substring(0, key.length() - 1);
        }
        return key;
    }

    private AmazonS3Client createAmazonS3Client(URI uri, Configuration hadoopConfig, ClientConfiguration clientConfig) {
        try {
            return new AmazonS3Client((AWSCredentialsProvider)new StaticCredentialsProvider(PrestoS3FileSystem.getAwsCredentials(uri, hadoopConfig)), clientConfig, (RequestMetricCollector)METRIC_COLLECTOR);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.useInstanceCredentials) {
                return new AmazonS3Client((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(), clientConfig, (RequestMetricCollector)METRIC_COLLECTOR);
            }
            throw new RuntimeException("S3 credentials not configured");
        }
    }

    private static AWSCredentials getAwsCredentials(URI uri, Configuration conf) {
        S3Credentials credentials = new S3Credentials();
        credentials.initialize(uri, conf);
        return new BasicAWSCredentials(credentials.getAccessKey(), credentials.getSecretAccessKey());
    }

    @VisibleForTesting
    AmazonS3 getS3Client() {
        return this.s3;
    }

    @VisibleForTesting
    void setS3Client(AmazonS3 client) {
        this.s3 = client;
    }

    private static class PrestoS3OutputStream
    extends FilterOutputStream {
        private final TransferManager transferManager;
        private final String host;
        private final String key;
        private final File tempFile;
        private boolean closed;

        public PrestoS3OutputStream(AmazonS3 s3, TransferManagerConfiguration config, String host, String key, File tempFile) throws IOException {
            super(new BufferedOutputStream(new FileOutputStream((File)Preconditions.checkNotNull((Object)tempFile, (Object)"tempFile is null"))));
            this.transferManager = new TransferManager((AmazonS3)Preconditions.checkNotNull((Object)s3, (Object)"s3 is null"));
            this.transferManager.setConfiguration((TransferManagerConfiguration)Preconditions.checkNotNull((Object)config, (Object)"config is null"));
            this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host is null");
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key is null");
            this.tempFile = tempFile;
            log.debug("OutputStream for key '%s' using file: %s", new Object[]{key, tempFile});
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() throws IOException {
            block4: {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    super.close();
                    this.uploadObject();
                    if (this.tempFile.delete()) break block4;
                }
                catch (Throwable throwable) {
                    if (!this.tempFile.delete()) {
                        log.warn("Could not delete temporary file: %s", new Object[]{this.tempFile});
                    }
                    this.transferManager.shutdownNow(false);
                    throw throwable;
                }
                log.warn("Could not delete temporary file: %s", new Object[]{this.tempFile});
            }
            this.transferManager.shutdownNow(false);
        }

        private void uploadObject() throws IOException {
            try {
                log.debug("Starting upload for host: %s, key: %s, file: %s, size: %s", new Object[]{this.host, this.key, this.tempFile, this.tempFile.length()});
                STATS.uploadStarted();
                Upload upload = this.transferManager.upload(this.host, this.key, this.tempFile);
                if (log.isDebugEnabled()) {
                    upload.addProgressListener(this.createProgressListener((Transfer)upload));
                }
                upload.waitForCompletion();
                STATS.uploadSuccessful();
                log.debug("Completed upload for host: %s, key: %s", new Object[]{this.host, this.key});
            }
            catch (AmazonClientException e) {
                STATS.uploadFailed();
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                STATS.uploadFailed();
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }

        private ProgressListener createProgressListener(final Transfer transfer) {
            return new ProgressListener(){
                private ProgressEventType previousType;
                private double previousTransferred;

                public synchronized void progressChanged(ProgressEvent progressEvent) {
                    double transferred;
                    ProgressEventType eventType = progressEvent.getEventType();
                    if (this.previousType != eventType) {
                        log.debug("Upload progress event (%s/%s): %s", new Object[]{host, key, eventType});
                        this.previousType = eventType;
                    }
                    if ((transferred = transfer.getProgress().getPercentTransferred()) >= this.previousTransferred + 10.0) {
                        log.debug("Upload percentage (%s/%s): %.0f%%", new Object[]{host, key, transferred});
                        this.previousTransferred = transferred;
                    }
                }
            };
        }
    }

    private static class PrestoS3InputStream
    extends FSInputStream {
        private final AmazonS3 s3;
        private final String host;
        private final Path path;
        private final int maxAttempts;
        private final Duration maxBackoffTime;
        private final Duration maxRetryTime;
        private boolean closed;
        private InputStream in;
        private long streamPosition;
        private long nextReadPosition;

        public PrestoS3InputStream(AmazonS3 s3, String host, Path path, int maxAttempts, Duration maxBackoffTime, Duration maxRetryTime) {
            this.s3 = (AmazonS3)Preconditions.checkNotNull((Object)s3, (Object)"s3 is null");
            this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host is null");
            this.path = (Path)Preconditions.checkNotNull((Object)path, (Object)"path is null");
            Preconditions.checkArgument((maxAttempts >= 0 ? 1 : 0) != 0, (Object)"maxAttempts cannot be negative");
            this.maxAttempts = maxAttempts;
            this.maxBackoffTime = (Duration)Preconditions.checkNotNull((Object)maxBackoffTime, (Object)"maxBackoffTime is null");
            this.maxRetryTime = (Duration)Preconditions.checkNotNull((Object)maxRetryTime, (Object)"maxRetryTime is null");
        }

        public void close() {
            this.closed = true;
            this.closeStream();
        }

        public void seek(long pos) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
            Preconditions.checkArgument((pos >= 0L ? 1 : 0) != 0, (String)"position is negative: %s", (Object[])new Object[]{pos});
            this.nextReadPosition = pos;
        }

        public long getPos() {
            return this.nextReadPosition;
        }

        public int read() {
            throw new UnsupportedOperationException();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            try {
                int bytesRead = RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(new Duration(1.0, TimeUnit.SECONDS), this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class).onRetry(STATS::newReadRetry).run("readStream", () -> {
                    this.seekStream();
                    try {
                        return this.in.read(buffer, offset, length);
                    }
                    catch (Exception e) {
                        STATS.newReadError(e);
                        this.closeStream();
                        throw e;
                    }
                });
                if (bytesRead != -1) {
                    this.streamPosition += (long)bytesRead;
                    this.nextReadPosition += (long)bytesRead;
                }
                return bytesRead;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            catch (Exception e) {
                Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
                throw Throwables.propagate((Throwable)e);
            }
        }

        public boolean seekToNewSource(long targetPos) {
            return false;
        }

        private void seekStream() throws IOException, UnrecoverableS3OperationException {
            long skip;
            if (this.in != null && this.nextReadPosition == this.streamPosition) {
                return;
            }
            if (this.in != null && this.nextReadPosition > this.streamPosition && (skip = this.nextReadPosition - this.streamPosition) <= Math.max((long)this.in.available(), MAX_SKIP_SIZE.toBytes())) {
                try {
                    if (this.in.skip(skip) == skip) {
                        this.streamPosition = this.nextReadPosition;
                        return;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.streamPosition = this.nextReadPosition;
            this.closeStream();
            this.openStream();
        }

        private void openStream() throws IOException, UnrecoverableS3OperationException {
            if (this.in == null) {
                this.in = this.openStream(this.path, this.nextReadPosition);
                this.streamPosition = this.nextReadPosition;
                STATS.connectionOpened();
            }
        }

        private InputStream openStream(Path path, long start) throws IOException, UnrecoverableS3OperationException {
            try {
                return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(new Duration(1.0, TimeUnit.SECONDS), this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class).onRetry(STATS::newGetObjectRetry).run("getS3Object", () -> {
                    try {
                        GetObjectRequest request = new GetObjectRequest(this.host, PrestoS3FileSystem.keyFromPath(path)).withRange(start, Long.MAX_VALUE);
                        return this.s3.getObject(request).getObjectContent();
                    }
                    catch (RuntimeException e) {
                        STATS.newGetObjectError();
                        if (e instanceof AmazonS3Exception) {
                            switch (((AmazonS3Exception)e).getStatusCode()) {
                                case 416: {
                                    return new ByteArrayInputStream(new byte[0]);
                                }
                                case 403: 
                                case 404: {
                                    throw new UnrecoverableS3OperationException(e);
                                }
                            }
                        }
                        throw Throwables.propagate((Throwable)e);
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            catch (Exception e) {
                Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
                Throwables.propagateIfInstanceOf((Throwable)e, UnrecoverableS3OperationException.class);
                throw Throwables.propagate((Throwable)e);
            }
        }

        private void closeStream() {
            if (this.in != null) {
                try {
                    if (this.in instanceof S3ObjectInputStream) {
                        ((S3ObjectInputStream)this.in).abort();
                    } else {
                        this.in.close();
                    }
                }
                catch (AbortedException | IOException throwable) {
                    // empty catch block
                }
                this.in = null;
                STATS.connectionReleased();
            }
        }
    }

    private static class UnrecoverableS3OperationException
    extends Exception {
        public UnrecoverableS3OperationException(Throwable cause) {
            super(cause);
        }
    }
}

