/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveCluster;
import com.facebook.presto.hive.HiveMetastoreClient;
import com.facebook.presto.hive.HiveMetastoreClientFactory;
import com.facebook.presto.hive.StaticMetastoreConfig;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.net.URI;
import javax.inject.Inject;
import org.apache.thrift.transport.TTransportException;

public class StaticHiveCluster
implements HiveCluster {
    private final HostAndPort address;
    private final HiveMetastoreClientFactory clientFactory;

    @Inject
    public StaticHiveCluster(StaticMetastoreConfig config, HiveMetastoreClientFactory clientFactory) {
        URI uri = StaticHiveCluster.checkMetastoreUri(config.getMetastoreUri());
        this.address = HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort());
        this.clientFactory = (HiveMetastoreClientFactory)Preconditions.checkNotNull((Object)clientFactory, (Object)"clientFactory is null");
    }

    @Override
    public HiveMetastoreClient createMetastoreClient() {
        try {
            return this.clientFactory.create(this.address.getHostText(), this.address.getPort());
        }
        catch (TTransportException e) {
            throw new RuntimeException("Failed connecting to Hive metastore: " + this.address, e);
        }
    }

    private static URI checkMetastoreUri(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"metastoreUri is null");
        String scheme = uri.getScheme();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)scheme) ? 1 : 0) != 0, (String)"metastoreUri scheme is missing: %s", (Object[])new Object[]{uri});
        Preconditions.checkArgument((boolean)scheme.equals("thrift"), (String)"metastoreUri scheme must be thrift: %s", (Object[])new Object[]{uri});
        Preconditions.checkArgument((uri.getHost() != null ? 1 : 0) != 0, (String)"metastoreUri host is missing: %s", (Object[])new Object[]{uri});
        Preconditions.checkArgument((uri.getPort() != -1 ? 1 : 0) != 0, (String)"metastoreUri port is missing: %s", (Object[])new Object[]{uri});
        return uri;
    }
}

