/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.ForHiveMetastore;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCluster;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveMetastoreClient;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.HiveViewNotSupportedException;
import com.facebook.presto.hive.RetryDriver;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.metastore.CachingHiveMetastoreStats;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.thrift.TException;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

@ThreadSafe
public class CachingHiveMetastore
implements HiveMetastore {
    private final CachingHiveMetastoreStats stats = new CachingHiveMetastoreStats();
    protected final HiveCluster clientProvider;
    private final LoadingCache<String, List<String>> databaseNamesCache;
    private final LoadingCache<String, Optional<Database>> databaseCache;
    private final LoadingCache<String, Optional<List<String>>> tableNamesCache;
    private final LoadingCache<String, Optional<List<String>>> viewNamesCache;
    private final LoadingCache<HiveTableName, Optional<List<String>>> partitionNamesCache;
    private final LoadingCache<HiveTableName, Optional<Table>> tableCache;
    private final LoadingCache<HivePartitionName, Optional<Partition>> partitionCache;
    private final LoadingCache<PartitionFilter, Optional<List<String>>> partitionFilterCache;

    @Inject
    public CachingHiveMetastore(HiveCluster hiveCluster, @ForHiveMetastore ExecutorService executor, HiveClientConfig hiveClientConfig) {
        this((HiveCluster)Preconditions.checkNotNull((Object)hiveCluster, (Object)"hiveCluster is null"), (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor is null"), ((HiveClientConfig)Preconditions.checkNotNull((Object)hiveClientConfig, (Object)"hiveClientConfig is null")).getMetastoreCacheTtl(), hiveClientConfig.getMetastoreRefreshInterval());
    }

    public CachingHiveMetastore(HiveCluster hiveCluster, ExecutorService executor, Duration cacheTtl, Duration refreshInterval) {
        this.clientProvider = (HiveCluster)Preconditions.checkNotNull((Object)hiveCluster, (Object)"hiveCluster is null");
        long expiresAfterWriteMillis = ((Duration)Preconditions.checkNotNull((Object)cacheTtl, (Object)"cacheTtl is null")).toMillis();
        long refreshMills = ((Duration)Preconditions.checkNotNull((Object)refreshInterval, (Object)"refreshInterval is null")).toMillis();
        this.databaseNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, List<String>>(){

            public List<String> load(String key) throws Exception {
                return CachingHiveMetastore.this.loadAllDatabases();
            }
        }, (Executor)executor));
        this.databaseCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, Optional<Database>>(){

            public Optional<Database> load(String databaseName) throws Exception {
                return CachingHiveMetastore.this.loadDatabase(databaseName);
            }
        }, (Executor)executor));
        this.tableNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, Optional<List<String>>>(){

            public Optional<List<String>> load(String databaseName) throws Exception {
                return CachingHiveMetastore.this.loadAllTables(databaseName);
            }
        }, (Executor)executor));
        this.tableCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<HiveTableName, Optional<Table>>(){

            public Optional<Table> load(HiveTableName hiveTableName) throws Exception {
                return CachingHiveMetastore.this.loadTable(hiveTableName);
            }
        }, (Executor)executor));
        this.viewNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, Optional<List<String>>>(){

            public Optional<List<String>> load(String databaseName) throws Exception {
                return CachingHiveMetastore.this.loadAllViews(databaseName);
            }
        }, (Executor)executor));
        this.partitionNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<HiveTableName, Optional<List<String>>>(){

            public Optional<List<String>> load(HiveTableName hiveTableName) throws Exception {
                return CachingHiveMetastore.this.loadPartitionNames(hiveTableName);
            }
        }, (Executor)executor));
        this.partitionFilterCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<PartitionFilter, Optional<List<String>>>(){

            public Optional<List<String>> load(PartitionFilter partitionFilter) throws Exception {
                return CachingHiveMetastore.this.loadPartitionNamesByParts(partitionFilter);
            }
        }, (Executor)executor));
        this.partitionCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<HivePartitionName, Optional<Partition>>(){

            public Optional<Partition> load(HivePartitionName partitionName) throws Exception {
                return CachingHiveMetastore.this.loadPartitionByName(partitionName);
            }

            public Map<HivePartitionName, Optional<Partition>> loadAll(Iterable<? extends HivePartitionName> partitionNames) throws Exception {
                return CachingHiveMetastore.this.loadPartitionsByNames(partitionNames);
            }
        }, (Executor)executor));
    }

    @Managed
    @Flatten
    public CachingHiveMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    @Managed
    public void flushCache() {
        this.databaseNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.viewNamesCache.invalidateAll();
        this.partitionNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.get(key);
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private static <K, V> Map<K, V> getAll(LoadingCache<K, V> cache, Iterable<K> keys) {
        try {
            return cache.getAll(keys);
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    @Override
    public List<String> getAllDatabases() {
        return CachingHiveMetastore.get(this.databaseNamesCache, "");
    }

    private List<String> loadAllDatabases() throws Exception {
        try {
            return RetryDriver.retry().stopOnIllegalExceptions().run("getAllDatabases", this.stats.getGetAllDatabases().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    List list = client.get_all_databases();
                    return list;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return CachingHiveMetastore.get(this.databaseCache, databaseName);
    }

    private Optional<Database> loadDatabase(String databaseName) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getDatabase", this.stats.getGetDatabase().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<Database> optional = Optional.of(client.get_database(databaseName));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getAllTables(String databaseName) {
        return CachingHiveMetastore.get(this.tableNamesCache, databaseName);
    }

    private Optional<List<String>> loadAllTables(String databaseName) throws Exception {
        Callable<List> getAllTables = this.stats.getGetAllTables().wrap(() -> {
            try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                List list = client.get_all_tables(databaseName);
                return list;
            }
        });
        Callable<Void> getDatabase = this.stats.getGetDatabase().wrap(() -> {
            try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                client.get_database(databaseName);
                Void void_ = null;
                return void_;
            }
        });
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getAllTables", () -> {
                List tables = (List)getAllTables.call();
                if (tables.isEmpty()) {
                    getDatabase.call();
                }
                return Optional.of(tables);
            });
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.tableCache, HiveTableName.table(databaseName, tableName));
    }

    @Override
    public Optional<List<String>> getAllViews(String databaseName) {
        return CachingHiveMetastore.get(this.viewNamesCache, databaseName);
    }

    private Optional<List<String>> loadAllViews(String databaseName) throws Exception {
        try {
            return RetryDriver.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getAllViews", this.stats.getAllViews().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    String filter = "hive_filter_field_params__presto_view = \"true\"";
                    Optional<List> optional = Optional.of(client.get_table_names_by_filter(databaseName, filter, (short)-1));
                    return optional;
                }
            }));
        }
        catch (UnknownDBException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createTable(Table table) {
        try {
            RetryDriver.retry().exceptionMapper(this.getExceptionMapper()).stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class).stopOnIllegalExceptions().run("createTable", this.stats.getCreateTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.create_table(table);
                }
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDbName(), table.getTableName()));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(table.getDbName());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.invalidateTable(table.getDbName(), table.getTableName());
        }
    }

    @Override
    public void dropTable(String databaseName, String tableName) {
        try {
            RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("dropTable", this.stats.getDropTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.drop_table(databaseName, tableName, true);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    protected void invalidateTable(String databaseName, String tableName) {
        this.tableCache.invalidate((Object)new HiveTableName(databaseName, tableName));
        this.tableNamesCache.invalidate((Object)databaseName);
        this.viewNamesCache.invalidate((Object)databaseName);
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        try {
            RetryDriver.retry().exceptionMapper(this.getExceptionMapper()).stopOn(InvalidOperationException.class, MetaException.class).stopOnIllegalExceptions().run("renameTable", this.stats.getRenameTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<Table> source = this.loadTable(new HiveTableName(databaseName, tableName));
                    if (!source.isPresent()) {
                        throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
                    }
                    Table table = new Table(source.get());
                    table.setDbName(newDatabaseName);
                    table.setTableName(newTableName);
                    client.alter_table(databaseName, tableName, table);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (InvalidOperationException | MetaException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newDatabaseName, newTableName);
        }
    }

    private Optional<Table> loadTable(HiveTableName hiveTableName) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTable", this.stats.getGetTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Table table = client.get_table(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
                    if (table.getTableType().equals(TableType.VIRTUAL_VIEW.name()) && !HiveUtil.isPrestoView(table)) {
                        throw new HiveViewNotSupportedException(new SchemaTableName(hiveTableName.getDatabaseName(), hiveTableName.getTableName()));
                    }
                    Optional<Table> optional = Optional.of(table);
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.partitionNamesCache, HiveTableName.table(databaseName, tableName));
    }

    protected Function<Exception, Exception> getExceptionMapper() {
        return Function.identity();
    }

    private Optional<List<String>> loadPartitionNames(HiveTableName hiveTableName) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNames", this.stats.getGetPartitionNames().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<List> optional = Optional.of(client.get_partition_names(hiveTableName.getDatabaseName(), hiveTableName.getTableName(), (short)0));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) {
        return CachingHiveMetastore.get(this.partitionFilterCache, PartitionFilter.partitionFilter(databaseName, tableName, parts));
    }

    private Optional<List<String>> loadPartitionNamesByParts(PartitionFilter partitionFilter) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNamesByParts", this.stats.getGetPartitionNamesPs().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<List> optional = Optional.of(client.get_partition_names_ps(partitionFilter.getHiveTableName().getDatabaseName(), partitionFilter.getHiveTableName().getTableName(), partitionFilter.getParts(), (short)-1));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Map<String, Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        Iterable names = Iterables.transform(partitionNames, name -> HivePartitionName.partition(databaseName, tableName, name));
        ImmutableMap.Builder partitionsByName = ImmutableMap.builder();
        Map<HivePartitionName, Optional<Partition>> all = CachingHiveMetastore.getAll(this.partitionCache, names);
        for (Map.Entry<HivePartitionName, Optional<Partition>> entry : all.entrySet()) {
            if (!entry.getValue().isPresent()) {
                return Optional.empty();
            }
            partitionsByName.put((Object)entry.getKey().getPartitionName(), (Object)entry.getValue().get());
        }
        return Optional.of(partitionsByName.build());
    }

    private Optional<Partition> loadPartitionByName(HivePartitionName partitionName) throws Exception {
        Preconditions.checkNotNull((Object)partitionName, (Object)"partitionName is null");
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionByName().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<Partition> optional = Optional.of(client.get_partition_by_name(partitionName.getHiveTableName().getDatabaseName(), partitionName.getHiveTableName().getTableName(), partitionName.getPartitionName()));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private Map<HivePartitionName, Optional<Partition>> loadPartitionsByNames(Iterable<? extends HivePartitionName> partitionNames) throws Exception {
        Preconditions.checkNotNull(partitionNames, (Object)"partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        HivePartitionName firstPartition = (HivePartitionName)Iterables.get(partitionNames, (int)0);
        HiveTableName hiveTableName = firstPartition.getHiveTableName();
        String databaseName = hiveTableName.getDatabaseName();
        String tableName = hiveTableName.getTableName();
        ArrayList<String> partitionsToFetch = new ArrayList<String>();
        for (HivePartitionName hivePartitionName : partitionNames) {
            Preconditions.checkArgument((boolean)hivePartitionName.getHiveTableName().equals(hiveTableName), (String)"Expected table name %s but got %s", (Object[])new Object[]{hiveTableName, hivePartitionName.getHiveTableName()});
            partitionsToFetch.add(hivePartitionName.getPartitionName());
        }
        ImmutableList partitionColumnNames = ImmutableList.copyOf(Warehouse.makeSpecFromName((String)firstPartition.getPartitionName()).keySet());
        try {
            return (Map)RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionsByNames().wrap(() -> this.lambda$loadPartitionsByNames$25(databaseName, tableName, partitionsToFetch, (List)partitionColumnNames)));
        }
        catch (NoSuchObjectException noSuchObjectException) {
            return StreamSupport.stream(partitionNames.spliterator(), false).collect(Collectors.toMap(Function.identity(), name -> Optional.empty()));
        }
        catch (TException tException) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)tException);
        }
    }

    private /* synthetic */ ImmutableMap lambda$loadPartitionsByNames$25(String databaseName, String tableName, List partitionsToFetch, List partitionColumnNames) throws Exception {
        try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
            ImmutableMap.Builder partitions = ImmutableMap.builder();
            for (Partition partition : client.get_partitions_by_names(databaseName, tableName, partitionsToFetch)) {
                String partitionId = FileUtils.makePartName((List)partitionColumnNames, (List)partition.getValues(), null);
                partitions.put((Object)HivePartitionName.partition(databaseName, tableName, partitionId), Optional.of(partition));
            }
            ImmutableMap immutableMap = partitions.build();
            return immutableMap;
        }
    }

    private static class PartitionFilter {
        private final HiveTableName hiveTableName;
        private final List<String> parts;

        private PartitionFilter(HiveTableName hiveTableName, List<String> parts) {
            this.hiveTableName = hiveTableName;
            this.parts = ImmutableList.copyOf(parts);
        }

        public static PartitionFilter partitionFilter(String databaseName, String tableName, List<String> parts) {
            return new PartitionFilter(HiveTableName.table(databaseName, tableName), parts);
        }

        public HiveTableName getHiveTableName() {
            return this.hiveTableName;
        }

        public List<String> getParts() {
            return this.parts;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("hiveTableName", (Object)this.hiveTableName).add("parts", this.parts).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionFilter other = (PartitionFilter)o;
            return Objects.equals(this.hiveTableName, other.hiveTableName) && Objects.equals(this.parts, other.parts);
        }

        public int hashCode() {
            return Objects.hash(this.hiveTableName, this.parts);
        }
    }

    private static class HivePartitionName {
        private final HiveTableName hiveTableName;
        private final String partitionName;

        private HivePartitionName(HiveTableName hiveTableName, String partitionName) {
            this.hiveTableName = hiveTableName;
            this.partitionName = partitionName;
        }

        public static HivePartitionName partition(String databaseName, String tableName, String partitionName) {
            return new HivePartitionName(HiveTableName.table(databaseName, tableName), partitionName);
        }

        public HiveTableName getHiveTableName() {
            return this.hiveTableName;
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("hiveTableName", (Object)this.hiveTableName).add("partitionName", (Object)this.partitionName).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HivePartitionName other = (HivePartitionName)o;
            return Objects.equals(this.hiveTableName, other.hiveTableName) && Objects.equals(this.partitionName, other.partitionName);
        }

        public int hashCode() {
            return Objects.hash(this.hiveTableName, this.partitionName);
        }
    }

    private static class HiveTableName {
        private final String databaseName;
        private final String tableName;

        private HiveTableName(String databaseName, String tableName) {
            this.databaseName = databaseName;
            this.tableName = tableName;
        }

        public static HiveTableName table(String databaseName, String tableName) {
            return new HiveTableName(databaseName, tableName);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("databaseName", (Object)this.databaseName).add("tableName", (Object)this.tableName).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HiveTableName other = (HiveTableName)o;
            return Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.tableName, other.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.databaseName, this.tableName);
        }
    }
}

