/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.hive.orc.OrcFile;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OrcSerde;
import com.facebook.hive.orc.Reader;
import com.facebook.hive.orc.RecordReader;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.orc.DwrfHiveRecordCursor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.ReaderWriterProfiler;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public class DwrfRecordCursorProvider
implements HiveRecordCursorProvider {
    @Override
    public Optional<HiveRecordCursor> createHiveRecordCursor(String clientId, Configuration configuration, ConnectorSession session, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager) {
        RecordReader recordReader;
        if (!HiveUtil.isDeserializerClass(schema, OrcSerde.class)) {
            return Optional.empty();
        }
        StructObjectInspector rowInspector = HiveUtil.getTableObjectInspector(schema);
        if (rowInspector.getAllStructFieldRefs().stream().anyMatch(field -> DwrfRecordCursorProvider.hasDateType(field.getFieldObjectInspector()))) {
            throw new IllegalArgumentException("DWRF does not support DATE type");
        }
        ReaderWriterProfiler.setProfilerOptions((Configuration)configuration);
        try {
            FileSystem fileSystem = path.getFileSystem(configuration);
            Reader reader = OrcFile.createReader((FileSystem)fileSystem, (Path)path, (Configuration)new JobConf(configuration));
            boolean[] include = DwrfRecordCursorProvider.findIncludedColumns(reader.getTypes(), columns);
            recordReader = reader.rows(start, length, include);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return Optional.of(new DwrfHiveRecordCursor(recordReader, length, schema, partitionKeys, columns, hiveStorageTimeZone, typeManager));
    }

    private static boolean[] findIncludedColumns(List<OrcProto.Type> types, List<HiveColumnHandle> columns) {
        boolean[] includes = new boolean[types.size()];
        includes[0] = true;
        OrcProto.Type root = types.get(0);
        List included = Lists.transform(columns, HiveColumnHandle::getHiveColumnIndex);
        for (int i = 0; i < root.getSubtypesCount(); ++i) {
            if (!included.contains(i)) continue;
            DwrfRecordCursorProvider.includeColumnRecursive(types, includes, root.getSubtypes(i));
        }
        for (boolean include : includes) {
            if (include) continue;
            return includes;
        }
        return null;
    }

    private static void includeColumnRecursive(List<OrcProto.Type> types, boolean[] result, int typeId) {
        result[typeId] = true;
        OrcProto.Type type = types.get(typeId);
        int children = type.getSubtypesCount();
        for (int i = 0; i < children; ++i) {
            DwrfRecordCursorProvider.includeColumnRecursive(types, result, type.getSubtypes(i));
        }
    }

    static boolean hasDateType(ObjectInspector objectInspector) {
        if (objectInspector instanceof PrimitiveObjectInspector) {
            PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)objectInspector;
            return primitiveInspector.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.DATE;
        }
        if (objectInspector instanceof ListObjectInspector) {
            ListObjectInspector listInspector = (ListObjectInspector)objectInspector;
            return DwrfRecordCursorProvider.hasDateType(listInspector.getListElementObjectInspector());
        }
        if (objectInspector instanceof MapObjectInspector) {
            MapObjectInspector mapInspector = (MapObjectInspector)objectInspector;
            return DwrfRecordCursorProvider.hasDateType(mapInspector.getMapKeyObjectInspector()) || DwrfRecordCursorProvider.hasDateType(mapInspector.getMapValueObjectInspector());
        }
        if (objectInspector instanceof StructObjectInspector) {
            for (StructField field : ((StructObjectInspector)objectInspector).getAllStructFieldRefs()) {
                if (!DwrfRecordCursorProvider.hasDateType(field.getFieldObjectInspector())) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Unknown object inspector type " + objectInspector);
    }
}

