/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slices;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyDate;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.joda.time.DateTimeZone;

public final class SerDeUtils {
    private SerDeUtils() {
    }

    public static Block getBlockObject(Type type, Object object, ObjectInspector objectInspector) {
        return (Block)Preconditions.checkNotNull((Object)SerDeUtils.serializeObject(type, null, object, objectInspector), (Object)"serialized result is null");
    }

    public static Block serializeObject(Type type, BlockBuilder builder, Object object, ObjectInspector inspector) {
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                SerDeUtils.serializePrimitive(builder, object, (PrimitiveObjectInspector)inspector);
                return null;
            }
            case LIST: {
                return SerDeUtils.serializeList(type, builder, object, (ListObjectInspector)inspector);
            }
            case MAP: {
                return SerDeUtils.serializeMap(type, builder, object, (MapObjectInspector)inspector);
            }
            case STRUCT: {
                return SerDeUtils.serializeStruct(type, builder, object, (StructObjectInspector)inspector);
            }
        }
        throw new RuntimeException("Unknown object inspector category: " + inspector.getCategory());
    }

    private static void serializePrimitive(BlockBuilder builder, Object object, PrimitiveObjectInspector inspector) {
        Preconditions.checkNotNull((Object)builder, (Object)"parent builder is null");
        if (object == null) {
            builder.appendNull();
            return;
        }
        switch (inspector.getPrimitiveCategory()) {
            case BOOLEAN: {
                BooleanType.BOOLEAN.writeBoolean(builder, ((BooleanObjectInspector)inspector).get(object));
                return;
            }
            case BYTE: {
                BigintType.BIGINT.writeLong(builder, (long)((ByteObjectInspector)inspector).get(object));
                return;
            }
            case SHORT: {
                BigintType.BIGINT.writeLong(builder, (long)((ShortObjectInspector)inspector).get(object));
                return;
            }
            case INT: {
                BigintType.BIGINT.writeLong(builder, (long)((IntObjectInspector)inspector).get(object));
                return;
            }
            case LONG: {
                BigintType.BIGINT.writeLong(builder, ((LongObjectInspector)inspector).get(object));
                return;
            }
            case FLOAT: {
                DoubleType.DOUBLE.writeDouble(builder, (double)((FloatObjectInspector)inspector).get(object));
                return;
            }
            case DOUBLE: {
                DoubleType.DOUBLE.writeDouble(builder, ((DoubleObjectInspector)inspector).get(object));
                return;
            }
            case STRING: {
                VarcharType.VARCHAR.writeSlice(builder, Slices.utf8Slice((String)((StringObjectInspector)inspector).getPrimitiveJavaObject(object)));
                return;
            }
            case DATE: {
                DateType.DATE.writeLong(builder, SerDeUtils.formatDateAsLong(object, (DateObjectInspector)inspector));
                return;
            }
            case TIMESTAMP: {
                TimestampType.TIMESTAMP.writeLong(builder, SerDeUtils.formatTimestampAsLong(object, (TimestampObjectInspector)inspector));
                return;
            }
            case BINARY: {
                VarbinaryType.VARBINARY.writeSlice(builder, Slices.wrappedBuffer((byte[])((BinaryObjectInspector)inspector).getPrimitiveJavaObject(object)));
                return;
            }
        }
        throw new RuntimeException("Unknown primitive type: " + inspector.getPrimitiveCategory());
    }

    private static Block serializeList(Type type, BlockBuilder builder, Object object, ListObjectInspector inspector) {
        List list = inspector.getList(object);
        if (list == null) {
            ((BlockBuilder)Preconditions.checkNotNull((Object)builder, (Object)"parent builder is null")).appendNull();
            return null;
        }
        List typeParameters = type.getTypeParameters();
        Preconditions.checkArgument((typeParameters.size() == 1 ? 1 : 0) != 0, (Object)"list must have exactly 1 type parameter");
        Type elementType = (Type)typeParameters.get(0);
        ObjectInspector elementInspector = inspector.getListElementObjectInspector();
        BlockBuilder currentBuilder = builder != null ? builder.beginBlockEntry() : elementType.createBlockBuilder(new BlockBuilderStatus(), list.size());
        for (Object element : list) {
            SerDeUtils.serializeObject(elementType, currentBuilder, element, elementInspector);
        }
        if (builder != null) {
            builder.closeEntry();
            return null;
        }
        Block resultBlock = currentBuilder.build();
        return resultBlock;
    }

    private static Block serializeMap(Type type, BlockBuilder builder, Object object, MapObjectInspector inspector) {
        Map map = inspector.getMap(object);
        if (map == null) {
            ((BlockBuilder)Preconditions.checkNotNull((Object)builder, (Object)"parent builder is null")).appendNull();
            return null;
        }
        List typeParameters = type.getTypeParameters();
        Preconditions.checkArgument((typeParameters.size() == 2 ? 1 : 0) != 0, (Object)"map must have exactly 2 type parameter");
        Type keyType = (Type)typeParameters.get(0);
        Type valueType = (Type)typeParameters.get(1);
        ObjectInspector keyInspector = inspector.getMapKeyObjectInspector();
        ObjectInspector valueInspector = inspector.getMapValueObjectInspector();
        Object currentBuilder = builder != null ? builder.beginBlockEntry() : new InterleavedBlockBuilder(typeParameters, new BlockBuilderStatus(), map.size());
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            SerDeUtils.serializeObject(keyType, currentBuilder, entry.getKey(), keyInspector);
            SerDeUtils.serializeObject(valueType, currentBuilder, entry.getValue(), valueInspector);
        }
        if (builder != null) {
            builder.closeEntry();
            return null;
        }
        Block resultBlock = currentBuilder.build();
        return resultBlock;
    }

    private static Block serializeStruct(Type type, BlockBuilder builder, Object object, StructObjectInspector inspector) {
        if (object == null) {
            ((BlockBuilder)Preconditions.checkNotNull((Object)builder, (Object)"parent builder is null")).appendNull();
            return null;
        }
        List typeParameters = type.getTypeParameters();
        List allStructFieldRefs = inspector.getAllStructFieldRefs();
        Preconditions.checkArgument((typeParameters.size() == allStructFieldRefs.size() ? 1 : 0) != 0);
        Object currentBuilder = builder != null ? builder.beginBlockEntry() : new InterleavedBlockBuilder(typeParameters, new BlockBuilderStatus(), typeParameters.size());
        for (int i = 0; i < typeParameters.size(); ++i) {
            StructField field = (StructField)allStructFieldRefs.get(i);
            SerDeUtils.serializeObject((Type)typeParameters.get(i), currentBuilder, inspector.getStructFieldData(object, field), field.getFieldObjectInspector());
        }
        if (builder != null) {
            builder.closeEntry();
            return null;
        }
        Block resultBlock = currentBuilder.build();
        return resultBlock;
    }

    private static long formatDateAsLong(Object object, DateObjectInspector inspector) {
        if (object instanceof LazyDate) {
            return ((DateWritable)((LazyDate)object).getWritableObject()).getDays();
        }
        if (object instanceof DateWritable) {
            return ((DateWritable)object).getDays();
        }
        long millisLocal = inspector.getPrimitiveJavaObject(object).getTime();
        long millisUtc = DateTimeZone.getDefault().getMillisKeepLocal(DateTimeZone.UTC, millisLocal);
        return TimeUnit.MILLISECONDS.toDays(millisUtc);
    }

    private static long formatTimestampAsLong(Object object, TimestampObjectInspector inspector) {
        Timestamp timestamp = SerDeUtils.getTimestamp(object, inspector);
        return timestamp.getTime();
    }

    private static Timestamp getTimestamp(Object object, TimestampObjectInspector inspector) {
        if (object instanceof TimestampWritable) {
            return ((TimestampWritable)object).getTimestamp();
        }
        return inspector.getPrimitiveJavaObject(object);
    }
}

