/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;

public final class Types {
    private Types() {
    }

    public static <A, B extends A> B checkType(A value, Class<B> target, String name) {
        Preconditions.checkNotNull(value, (String)"%s is null", (Object[])new Object[]{name});
        Preconditions.checkArgument((boolean)target.isInstance(value), (String)"%s must be of type %s, not %s", (Object[])new Object[]{name, target.getName(), value.getClass().getName()});
        return target.cast(value);
    }

    public static <A, B extends A> B checkType(A value, Class<B> target, ErrorCodeSupplier errorCode, String name) {
        Preconditions.checkNotNull(value, (String)"%s is null", (Object[])new Object[]{name});
        if (!target.isInstance(value)) {
            throw new PrestoException(errorCode, String.format("%s must be of type %s, not %s", name, target.getName(), value.getClass().getName()));
        }
        return target.cast(value);
    }
}

