/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.ser.JacksonJodaFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public final class DateTimeSerializer
extends JodaDateSerializerBase<DateTime> {
    protected static final JacksonJodaFormat DEFAULT_FORMAT = new JacksonJodaFormat(ISODateTimeFormat.dateTime().withZoneUTC());

    public DateTimeSerializer() {
        this(DEFAULT_FORMAT);
    }

    public DateTimeSerializer(JacksonJodaFormat format) {
        super(DateTime.class, format);
    }

    public DateTimeSerializer withFormat(JacksonJodaFormat formatter) {
        return this._format == formatter ? this : new DateTimeSerializer(formatter);
    }

    public void serialize(DateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._useTimestamp(provider)) {
            jgen.writeNumber(value.getMillis());
        } else {
            jgen.writeString(this._format.createFormatter(provider).print((ReadableInstant)value));
        }
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._useTimestamp(provider) ? "number" : "string", true);
    }
}

