/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.metadata.BooleanStatistics;
import com.facebook.presto.orc.metadata.ColumnStatistics;
import com.facebook.presto.orc.metadata.RangeStatistics;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Range;
import com.facebook.presto.spi.SortedRangeSet;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class TupleDomainOrcPredicate<C>
implements OrcPredicate {
    private final TupleDomain<C> effectivePredicate;
    private final List<ColumnReference<C>> columnReferences;

    public TupleDomainOrcPredicate(TupleDomain<C> effectivePredicate, List<ColumnReference<C>> columnReferences) {
        this.effectivePredicate = (TupleDomain)Preconditions.checkNotNull(effectivePredicate, (Object)"effectivePredicate is null");
        this.columnReferences = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(columnReferences, (Object)"columnReferences is null")));
    }

    @Override
    public boolean matches(long numberOfRows, Map<Integer, ColumnStatistics> statisticsByColumnIndex) {
        ImmutableMap.Builder domains = ImmutableMap.builder();
        for (ColumnReference<C> columnReference : this.columnReferences) {
            ColumnStatistics columnStatistics = statisticsByColumnIndex.get(columnReference.getOrdinal());
            Domain domain = columnStatistics == null ? Domain.all((Class)Primitives.wrap((Class)columnReference.getType().getJavaType())) : TupleDomainOrcPredicate.getDomain(columnReference.getType(), numberOfRows, columnStatistics);
            domains.put(columnReference.getColumn(), (Object)domain);
        }
        TupleDomain stripeDomain = TupleDomain.withColumnDomains((Map)domains.build());
        return this.effectivePredicate.overlaps(stripeDomain);
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, long rowCount, ColumnStatistics columnStatistics) {
        boolean hasNullValue;
        Class boxedJavaType = Primitives.wrap((Class)type.getJavaType());
        if (rowCount == 0L) {
            return Domain.none((Class)boxedJavaType);
        }
        if (columnStatistics == null) {
            return Domain.all((Class)boxedJavaType);
        }
        if (columnStatistics.hasNumberOfValues() && columnStatistics.getNumberOfValues() == 0L) {
            return Domain.onlyNull((Class)boxedJavaType);
        }
        boolean bl = hasNullValue = columnStatistics.getNumberOfValues() != rowCount;
        if (boxedJavaType == Boolean.class && columnStatistics.getBooleanStatistics() != null) {
            boolean hasFalseValues;
            BooleanStatistics booleanStatistics = columnStatistics.getBooleanStatistics();
            boolean hasTrueValues = booleanStatistics.getTrueValueCount() != 0L;
            boolean bl2 = hasFalseValues = columnStatistics.getNumberOfValues() != booleanStatistics.getTrueValueCount();
            if (hasTrueValues && hasFalseValues) {
                return Domain.all(Boolean.class);
            }
            if (hasTrueValues) {
                return Domain.create((SortedRangeSet)SortedRangeSet.singleValue((Comparable)Boolean.valueOf(true)), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((SortedRangeSet)SortedRangeSet.singleValue((Comparable)Boolean.valueOf(false)), (boolean)hasNullValue);
            }
        } else {
            if (type.getTypeSignature().getBase().equals("date") && columnStatistics.getDateStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(boxedJavaType, hasNullValue, columnStatistics.getDateStatistics(), value -> (long)value);
            }
            if (boxedJavaType == Long.class && columnStatistics.getIntegerStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(boxedJavaType, hasNullValue, columnStatistics.getIntegerStatistics());
            }
            if (boxedJavaType == Double.class && columnStatistics.getDoubleStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(boxedJavaType, hasNullValue, columnStatistics.getDoubleStatistics());
            }
            if (boxedJavaType == Slice.class && columnStatistics.getStringStatistics() != null) {
                return TupleDomainOrcPredicate.createDomain(boxedJavaType, hasNullValue, columnStatistics.getStringStatistics());
            }
        }
        return Domain.create((SortedRangeSet)SortedRangeSet.all((Class)boxedJavaType), (boolean)hasNullValue);
    }

    private static <T extends Comparable<T>> Domain createDomain(Class<?> boxedJavaType, boolean hasNullValue, RangeStatistics<T> rangeStatistics) {
        return TupleDomainOrcPredicate.createDomain(boxedJavaType, hasNullValue, rangeStatistics, value -> value);
    }

    private static <F, T extends Comparable<T>> Domain createDomain(Class<?> boxedJavaType, boolean hasNullValue, RangeStatistics<F> rangeStatistics, Function<F, T> function) {
        F min = rangeStatistics.getMin();
        F max = rangeStatistics.getMax();
        if (min != null && max != null) {
            return Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.range((Comparable)((Comparable)function.apply(min)), (boolean)true, (Comparable)((Comparable)function.apply(max)), (boolean)true), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (max != null) {
            return Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Comparable)((Comparable)function.apply(max))), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (min != null) {
            return Domain.create((SortedRangeSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Comparable)((Comparable)function.apply(min))), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        return Domain.create((SortedRangeSet)SortedRangeSet.all(boxedJavaType), (boolean)hasNullValue);
    }

    public static class ColumnReference<C> {
        private final C column;
        private final int ordinal;
        private final Type type;

        public ColumnReference(C column, int ordinal, Type type) {
            this.column = Preconditions.checkNotNull(column, (Object)"column is null");
            Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0, (Object)"ordinal is negative");
            this.ordinal = ordinal;
            this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        }

        public C getColumn() {
            return this.column;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("column", this.column).add("ordinal", this.ordinal).add("type", (Object)this.type).toString();
        }
    }
}

