/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.block;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.block.BlockReader;
import com.facebook.presto.orc.block.BooleanBlockReader;
import com.facebook.presto.orc.block.ByteBlockReader;
import com.facebook.presto.orc.block.DateBlockReader;
import com.facebook.presto.orc.block.DoubleBlockReader;
import com.facebook.presto.orc.block.FloatBlockReader;
import com.facebook.presto.orc.block.ListBlockReader;
import com.facebook.presto.orc.block.LongBlockReader;
import com.facebook.presto.orc.block.MapBlockReader;
import com.facebook.presto.orc.block.SliceBlockReader;
import com.facebook.presto.orc.block.StructBlockReader;
import com.facebook.presto.orc.block.TimestampBlockReader;
import org.joda.time.DateTimeZone;

public final class BlockReaders {
    private BlockReaders() {
    }

    public static BlockReader createBlockReader(StreamDescriptor streamDescriptor, boolean checkForNulls, DateTimeZone hiveStorageTimeZone) {
        switch (streamDescriptor.getStreamType()) {
            case BOOLEAN: {
                return new BooleanBlockReader(streamDescriptor);
            }
            case BYTE: {
                return new ByteBlockReader(streamDescriptor);
            }
            case SHORT: 
            case INT: 
            case LONG: {
                return new LongBlockReader(streamDescriptor);
            }
            case FLOAT: {
                return new FloatBlockReader(streamDescriptor);
            }
            case DOUBLE: {
                return new DoubleBlockReader(streamDescriptor);
            }
            case BINARY: 
            case STRING: {
                return new SliceBlockReader(streamDescriptor);
            }
            case TIMESTAMP: {
                return new TimestampBlockReader(streamDescriptor, hiveStorageTimeZone);
            }
            case DATE: {
                return new DateBlockReader(streamDescriptor);
            }
            case STRUCT: {
                return new StructBlockReader(streamDescriptor, checkForNulls, hiveStorageTimeZone);
            }
            case LIST: {
                return new ListBlockReader(streamDescriptor, checkForNulls, hiveStorageTimeZone);
            }
            case MAP: {
                return new MapBlockReader(streamDescriptor, checkForNulls, hiveStorageTimeZone);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)streamDescriptor.getStreamType()));
    }
}

