/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.block;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.block.BlockReader;
import com.facebook.presto.orc.block.BlockReaders;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.ArrayElementBlockWriter;
import com.facebook.presto.spi.block.BlockBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class StructBlockReader
implements BlockReader {
    private final StreamDescriptor streamDescriptor;
    private final boolean checkForNulls;
    private final BlockReader[] structFields;
    @Nullable
    private BooleanStream presentStream;

    public StructBlockReader(StreamDescriptor streamDescriptor, boolean checkForNulls, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.checkForNulls = checkForNulls;
        List<StreamDescriptor> nestedStreams = streamDescriptor.getNestedStreams();
        this.structFields = new BlockReader[nestedStreams.size()];
        for (int i = 0; i < nestedStreams.size(); ++i) {
            StreamDescriptor nestedStream = nestedStreams.get(i);
            this.structFields[i] = BlockReaders.createBlockReader(nestedStream, true, hiveStorageTimeZone);
        }
    }

    @Override
    public boolean readNextValueInto(BlockBuilder builder, boolean skipNull) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            if (!skipNull) {
                ((BlockBuilder)Preconditions.checkNotNull((Object)builder, (Object)"parent builder is null")).appendNull();
                return true;
            }
            return false;
        }
        ArrayElementBlockWriter arrayElementBlockWriter = (ArrayElementBlockWriter)builder.beginBlockEntry();
        for (int i = 0; i < this.structFields.length; ++i) {
            this.structFields[i].readNextValueInto((BlockBuilder)arrayElementBlockWriter, false);
        }
        builder.closeEntry();
        return true;
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        for (BlockReader structField : this.structFields) {
            structField.skip(skipSize);
        }
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        for (BlockReader structField : this.structFields) {
            structField.openStripe(dictionaryStreamSources, encoding);
        }
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        if (this.checkForNulls) {
            this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        }
        for (BlockReader structField : this.structFields) {
            structField.openRowGroup(dataStreamSources);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

