/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.block;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.block.BlockReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.TimestampStreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.TimestampType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimestampBlockReader
implements BlockReader {
    private final StreamDescriptor streamDescriptor;
    private final long baseTimestampInSeconds;
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private LongStream secondsStream;
    @Nullable
    private LongStream nanosStream;

    public TimestampBlockReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.baseTimestampInSeconds = new DateTime(2015, 1, 1, 0, 0, (DateTimeZone)Preconditions.checkNotNull((Object)hiveStorageTimeZone, (Object)"hiveStorageTimeZone is null")).getMillis() / 1000L;
    }

    @Override
    public boolean readNextValueInto(BlockBuilder builder, boolean skipNull) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            if (!skipNull) {
                builder.appendNull();
                return true;
            }
            return false;
        }
        if (this.secondsStream == null) {
            throw new OrcCorruptionException("Value is not null but seconds stream is not present");
        }
        if (this.nanosStream == null) {
            throw new OrcCorruptionException("Value is not null but nanos stream is not present");
        }
        long timestamp = TimestampStreamReader.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
        TimestampType.TIMESTAMP.writeLong(builder, timestamp);
        return true;
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (skipSize == 0) {
            return;
        }
        if (this.secondsStream == null) {
            throw new OrcCorruptionException("Value is not null but seconds stream is not present");
        }
        if (this.nanosStream == null) {
            throw new OrcCorruptionException("Value is not null but nanos stream is not present");
        }
        this.secondsStream.skip(skipSize);
        this.nanosStream.skip(skipSize);
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        this.secondsStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongStream.class).openStream();
        this.nanosStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongStream.class).openStream();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

