/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.SingleObjectVector;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.block.BlockReader;
import com.facebook.presto.orc.block.BlockReaders;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.OrcReaderUtils;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class BlockStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private final BlockReader blockReader;
    private boolean stripeOpen;
    private boolean rowGroupOpen;
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    private final boolean[] isNullVector = new boolean[1024];
    private int readOffset;
    private int nextBatchSize;
    @Nullable
    private StreamSources dictionaryStreamSources;
    @Nullable
    private StreamSources dataStreamSources;
    private List<ColumnEncoding> encoding;

    public BlockStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.blockReader = BlockReaders.createBlockReader(streamDescriptor, false, hiveStorageTimeZone);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public void readBatch(Object vector) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readBatch(Type type, Object vector) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            this.blockReader.skip(this.readOffset);
        }
        if (this.presentStream != null) {
            this.presentStream.getUnsetBits(this.nextBatchSize, this.isNullVector);
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), this.nextBatchSize);
        for (int i = 0; i < this.nextBatchSize; ++i) {
            if (!this.isNullVector[i]) {
                this.blockReader.readNextValueInto(blockBuilder, false);
                continue;
            }
            blockBuilder.appendNull();
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        Block result = blockBuilder.build();
        OrcReaderUtils.castOrcVector((Object)vector, SingleObjectVector.class).object = result;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        if (!this.stripeOpen) {
            this.blockReader.openStripe(this.dictionaryStreamSources, this.encoding);
        }
        this.blockReader.openRowGroup(this.dataStreamSources);
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.dictionaryStreamSources = dictionaryStreamSources;
        this.dataStreamSources = null;
        this.encoding = encoding;
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.stripeOpen = false;
        this.rowGroupOpen = false;
        this.readOffset = 0;
        this.nextBatchSize = 0;
        Arrays.fill(this.isNullVector, false);
        this.presentStream = null;
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.dataStreamSources = dataStreamSources;
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.rowGroupOpen = false;
        this.readOffset = 0;
        this.nextBatchSize = 0;
        Arrays.fill(this.isNullVector, false);
        this.presentStream = null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

