/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConnectorTableMetadata {
    private final SchemaTableName table;
    private final List<ColumnMetadata> columns;
    private final Map<String, Object> properties;
    private final String owner;
    private final boolean sampled;

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns) {
        this(table, columns, Collections.emptyMap(), null);
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties) {
        this(table, columns, properties, null);
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties, String owner) {
        this(table, columns, properties, owner, false);
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties, String owner, boolean sampled) {
        if (table == null) {
            throw new NullPointerException("table is null or empty");
        }
        if (columns == null) {
            throw new NullPointerException("columns is null");
        }
        this.table = table;
        this.columns = Collections.unmodifiableList(new ArrayList<ColumnMetadata>(columns));
        this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties));
        this.owner = owner;
        this.sampled = sampled;
    }

    public boolean isSampled() {
        return this.sampled;
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public List<ColumnMetadata> getColumns() {
        return this.columns;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getOwner() {
        return this.owner;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorTableMetadata{");
        sb.append("table=").append(this.table);
        sb.append(", columns=").append(this.columns);
        sb.append(", properties=").append(this.properties);
        sb.append(", owner=").append(this.owner);
        sb.append('}');
        return sb.toString();
    }
}

