/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Page;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class FixedPageSource
implements ConnectorPageSource {
    private final Iterator<Page> pages;
    private final long totalBytes;
    private long completedBytes;
    private boolean closed;

    public FixedPageSource(Iterable<Page> pages) {
        this.pages = Objects.requireNonNull(pages, "pages is null").iterator();
        long totalSize = 0L;
        for (Page page : pages) {
            totalSize += page.getSizeInBytes();
        }
        this.totalBytes = totalSize;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public long getTotalBytes() {
        return this.totalBytes;
    }

    @Override
    public long getCompletedBytes() {
        return this.completedBytes;
    }

    @Override
    public long getReadTimeNanos() {
        return 0L;
    }

    @Override
    public boolean isFinished() {
        return this.closed || !this.pages.hasNext();
    }

    @Override
    public Page getNextPage() {
        if (this.isFinished()) {
            return null;
        }
        Page page = this.pages.next();
        this.completedBytes += page.getSizeInBytes();
        return page;
    }
}

