/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public interface LocalProperty<E> {
    public <T> Optional<LocalProperty<T>> translate(Function<E, Optional<T>> var1);

    public boolean isSimplifiedBy(LocalProperty<E> var1);

    default public Optional<LocalProperty<E>> withConstants(Set<E> constants) {
        HashSet<E> set = new HashSet<E>(this.getColumns());
        set.removeAll(constants);
        if (set.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.constrain(set));
    }

    default public LocalProperty<E> constrain(Set<E> columns) {
        if (!columns.equals(this.getColumns())) {
            throw new IllegalArgumentException(String.format("Cannot constrain %s with %s", this, columns));
        }
        return this;
    }

    public Set<E> getColumns();
}

