/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockValidationUtil;
import com.facebook.presto.spi.block.DictionaryBlockEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DictionaryBlock
implements Block {
    private final int positionCount;
    private final Block dictionary;
    private final Slice ids;
    private final int sizeInBytes;

    public DictionaryBlock(int positionCount, Block dictionary, Slice ids) {
        Objects.requireNonNull(dictionary, "dictionary is null");
        Objects.requireNonNull(ids, "ids is null");
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (ids.length() != positionCount * 4) {
            throw new IllegalArgumentException("ids length does not match with positionCount");
        }
        this.positionCount = positionCount;
        this.dictionary = dictionary;
        this.ids = ids;
        this.sizeInBytes = dictionary.getRetainedSizeInBytes() + ids.getRetainedSize();
    }

    @Override
    public int getLength(int position) {
        return this.dictionary.getLength(this.getIndex(position));
    }

    @Override
    public byte getByte(int position, int offset) {
        return this.dictionary.getByte(this.getIndex(position), offset);
    }

    @Override
    public short getShort(int position, int offset) {
        return this.dictionary.getShort(this.getIndex(position), offset);
    }

    @Override
    public int getInt(int position, int offset) {
        return this.dictionary.getInt(this.getIndex(position), offset);
    }

    @Override
    public long getLong(int position, int offset) {
        return this.dictionary.getLong(this.getIndex(position), offset);
    }

    @Override
    public float getFloat(int position, int offset) {
        return this.dictionary.getFloat(this.getIndex(position), offset);
    }

    @Override
    public double getDouble(int position, int offset) {
        return this.dictionary.getDouble(this.getIndex(position), offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        return this.dictionary.getSlice(this.getIndex(position), offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        return this.dictionary.getObject(this.getIndex(position), clazz);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.dictionary.bytesEqual(this.getIndex(position), offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.dictionary.bytesCompare(this.getIndex(position), offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.dictionary.writeBytesTo(this.getIndex(position), offset, length, blockBuilder);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.dictionary.writePositionTo(this.getIndex(position), blockBuilder);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.dictionary.equals(this.getIndex(position), offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public int hash(int position, int offset, int length) {
        return this.dictionary.hash(this.getIndex(position), offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.dictionary.compareTo(this.getIndex(leftPosition), leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        return this.dictionary.getSingleValueBlock(this.getIndex(position));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public BlockEncoding getEncoding() {
        return new DictionaryBlockEncoding(this.dictionary.getEncoding());
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        BlockValidationUtil.checkValidPositions(positions, this.positionCount);
        List distinctPositions = positions.stream().distinct().collect(Collectors.toList());
        List currentDictionaryIndexes = distinctPositions.stream().map(this::getIndex).collect(Collectors.toList());
        List<Integer> positionsToCopy = currentDictionaryIndexes.stream().distinct().collect(Collectors.toList());
        Block dictionaryBlock = this.dictionary.copyPositions(positionsToCopy);
        int[] newIds = new int[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            int oldIndex = (Integer)currentDictionaryIndexes.get(distinctPositions.indexOf(positions.get(i)));
            newIds[i] = positionsToCopy.indexOf(oldIndex);
        }
        return new DictionaryBlock(positions.size(), dictionaryBlock, Slices.wrappedIntArray((int[])newIds));
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + this.positionCount + " positions");
        }
        Slice newIds = this.ids.slice(positionOffset * 4, length * 4);
        return new DictionaryBlock(length, this.dictionary, newIds);
    }

    @Override
    public Block copyRegion(int position, int length) {
        if (position < 0 || length < 0 || position + length > this.positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + position + " in block with " + this.positionCount + " positions");
        }
        Slice newIds = Slices.copyOf((Slice)this.ids, (int)(position * 4), (int)(length * 4));
        return new DictionaryBlock(length, this.dictionary, newIds);
    }

    @Override
    public boolean isNull(int position) {
        return this.dictionary.isNull(this.getIndex(position));
    }

    @Override
    public void assureLoaded() {
    }

    public Block getDictionary() {
        return this.dictionary;
    }

    public Slice getIds() {
        return this.ids;
    }

    private int getIndex(int position) {
        return this.ids.getInt(position * 4);
    }

    public DictionaryBlock compact() {
        int dictionarySize = this.dictionary.getPositionCount();
        boolean[] isReferenced = new boolean[dictionarySize];
        for (int i = 0; i < this.positionCount; ++i) {
            isReferenced[this.getIndex((int)i)] = true;
        }
        ArrayList<Integer> dictionaryPositionsToCopy = new ArrayList<Integer>(dictionarySize);
        int[] remapIndex = new int[dictionarySize];
        Arrays.fill(remapIndex, -1);
        int newIndex = 0;
        for (int i = 0; i < dictionarySize; ++i) {
            if (!isReferenced[i]) continue;
            dictionaryPositionsToCopy.add(i);
            remapIndex[i] = newIndex++;
        }
        if (dictionaryPositionsToCopy.size() == dictionarySize) {
            return this;
        }
        int[] newIds = new int[this.positionCount];
        for (int i = 0; i < this.positionCount; ++i) {
            int newId = remapIndex[this.getIndex(i)];
            if (newId == -1) {
                throw new IllegalStateException("reference to a non-existent key");
            }
            newIds[i] = newId;
        }
        try {
            Block compactDictionary = this.dictionary.copyPositions(dictionaryPositionsToCopy);
            return new DictionaryBlock(this.positionCount, compactDictionary, Slices.wrappedIntArray((int[])newIds));
        }
        catch (UnsupportedOperationException e) {
            return this;
        }
    }
}

