/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import org.apache.hadoop.hive.ql.io.slice.Slice;
import org.apache.hadoop.hive.ql.io.slice.Slices;

final class DynamicIntArray {
    static final int DEFAULT_SIZE = 32768;
    private Slice data;
    private int length = 0;

    public DynamicIntArray() {
        this(32768);
    }

    public DynamicIntArray(int size) {
        this.data = Slices.allocate((int)size);
    }

    private void grow(int index) {
        if (index * 4 + 3 >= this.data.length()) {
            int newSize = Math.max(index * 4 + 32768, 2 * this.data.length());
            Slice newSlice = Slices.allocate((int)newSize);
            newSlice.setBytes(0, this.data);
            this.data = newSlice;
        }
    }

    public int get(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of 0.." + (this.length - 1));
        }
        return this.data.getInt(index * 4);
    }

    public void set(int index, int value) {
        this.grow(index);
        if (index >= this.length) {
            this.length = index + 1;
        }
        this.data.setInt(index * 4, value);
    }

    public void increment(int index, int value) {
        this.grow(index);
        if (index >= this.length) {
            this.length = index + 1;
        }
        this.data.setInt(index * 4, this.data.getInt(index * 4) + value);
    }

    public void add(int value) {
        this.grow(this.length);
        this.data.setInt(this.length * 4, value);
        ++this.length;
    }

    public int size() {
        return this.length;
    }

    public void clear() {
        this.length = 0;
        this.data = Slices.allocate((int)32768);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder(this.length * 4);
        sb.append('{');
        int l = this.length - 1;
        for (i = 0; i < l; ++i) {
            sb.append(this.get(i));
            sb.append(',');
        }
        sb.append(this.get(i));
        sb.append('}');
        return sb.toString();
    }

    public int getSizeInBytes() {
        return this.data.length();
    }
}

