/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.hive.orc.OrcConf;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.PrestoS3FileSystem;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.File;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.SocksSocketFactory;

public class HdfsConfigurationUpdater {
    private final HostAndPort socksProxy;
    private final Duration dfsTimeout;
    private final Duration dfsConnectTimeout;
    private final int dfsConnectMaxRetries;
    private final String domainSocketPath;
    private final String s3AwsAccessKey;
    private final String s3AwsSecretKey;
    private final boolean s3UseInstanceCredentials;
    private final boolean s3SslEnabled;
    private final boolean s3SseEnabled;
    private final int s3MaxClientRetries;
    private final int s3MaxErrorRetries;
    private final Duration s3MaxBackoffTime;
    private final Duration s3MaxRetryTime;
    private final Duration s3ConnectTimeout;
    private final Duration s3SocketTimeout;
    private final int s3MaxConnections;
    private final DataSize s3MultipartMinFileSize;
    private final DataSize s3MultipartMinPartSize;
    private final File s3StagingDirectory;
    private final List<String> resourcePaths;
    private final boolean pinS3ClientToCurrentRegion;
    private final HiveCompressionCodec compressionCodec;

    @Inject
    public HdfsConfigurationUpdater(HiveClientConfig hiveClientConfig) {
        Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null");
        Preconditions.checkArgument((hiveClientConfig.getDfsTimeout().toMillis() >= 1L ? 1 : 0) != 0, (Object)"dfsTimeout must be at least 1 ms");
        this.socksProxy = hiveClientConfig.getMetastoreSocksProxy();
        this.dfsTimeout = hiveClientConfig.getDfsTimeout();
        this.dfsConnectTimeout = hiveClientConfig.getDfsConnectTimeout();
        this.dfsConnectMaxRetries = hiveClientConfig.getDfsConnectMaxRetries();
        this.domainSocketPath = hiveClientConfig.getDomainSocketPath();
        this.s3AwsAccessKey = hiveClientConfig.getS3AwsAccessKey();
        this.s3AwsSecretKey = hiveClientConfig.getS3AwsSecretKey();
        this.s3UseInstanceCredentials = hiveClientConfig.isS3UseInstanceCredentials();
        this.s3SslEnabled = hiveClientConfig.isS3SslEnabled();
        this.s3SseEnabled = hiveClientConfig.isS3SseEnabled();
        this.s3MaxClientRetries = hiveClientConfig.getS3MaxClientRetries();
        this.s3MaxErrorRetries = hiveClientConfig.getS3MaxErrorRetries();
        this.s3MaxBackoffTime = hiveClientConfig.getS3MaxBackoffTime();
        this.s3MaxRetryTime = hiveClientConfig.getS3MaxRetryTime();
        this.s3ConnectTimeout = hiveClientConfig.getS3ConnectTimeout();
        this.s3SocketTimeout = hiveClientConfig.getS3SocketTimeout();
        this.s3MaxConnections = hiveClientConfig.getS3MaxConnections();
        this.s3MultipartMinFileSize = hiveClientConfig.getS3MultipartMinFileSize();
        this.s3MultipartMinPartSize = hiveClientConfig.getS3MultipartMinPartSize();
        this.s3StagingDirectory = hiveClientConfig.getS3StagingDirectory();
        this.resourcePaths = hiveClientConfig.getResourceConfigFiles();
        this.pinS3ClientToCurrentRegion = hiveClientConfig.isPinS3ClientToCurrentRegion();
        this.compressionCodec = hiveClientConfig.getHiveCompressionCodec();
    }

    public void updateConfiguration(Configuration config) {
        if (this.resourcePaths != null) {
            for (String resourcePath : this.resourcePaths) {
                config.addResource(new Path(resourcePath));
            }
        }
        config.setClass("topology.node.switch.mapping.impl", NoOpDNSToSwitchMapping.class, DNSToSwitchMapping.class);
        if (this.socksProxy != null) {
            config.setClass("hadoop.rpc.socket.factory.class.default", SocksSocketFactory.class, SocketFactory.class);
            config.set("hadoop.socks.server", this.socksProxy.toString());
        }
        if (this.domainSocketPath != null) {
            config.setStrings("dfs.domain.socket.path", new String[]{this.domainSocketPath});
        }
        if (!config.get("dfs.domain.socket.path", "").trim().isEmpty()) {
            config.setBooleanIfUnset("dfs.client.read.shortcircuit", true);
        }
        config.setInt("dfs.socket.timeout", Ints.checkedCast((long)this.dfsTimeout.toMillis()));
        config.setInt("ipc.ping.interval", Ints.checkedCast((long)this.dfsTimeout.toMillis()));
        config.setInt("ipc.client.connect.timeout", Ints.checkedCast((long)this.dfsConnectTimeout.toMillis()));
        config.setInt("ipc.client.connect.max.retries", this.dfsConnectMaxRetries);
        config.set("fs.s3.impl", PrestoS3FileSystem.class.getName());
        config.set("fs.s3a.impl", PrestoS3FileSystem.class.getName());
        config.set("fs.s3n.impl", PrestoS3FileSystem.class.getName());
        config.set("fs.s3bfs.impl", "org.apache.hadoop.fs.s3.S3FileSystem");
        if (this.s3AwsAccessKey != null) {
            config.set("presto.s3.access-key", this.s3AwsAccessKey);
            config.set("fs.s3bfs.awsAccessKeyId", this.s3AwsAccessKey);
        }
        if (this.s3AwsSecretKey != null) {
            config.set("presto.s3.secret-key", this.s3AwsSecretKey);
            config.set("fs.s3bfs.awsSecretAccessKey", this.s3AwsSecretKey);
        }
        HdfsConfigurationUpdater.configureCompression(config, this.compressionCodec);
        config.setBoolean("presto.s3.use-instance-credentials", this.s3UseInstanceCredentials);
        config.setBoolean("presto.s3.ssl.enabled", this.s3SslEnabled);
        config.setBoolean("presto.s3.sse.enabled", this.s3SseEnabled);
        config.setInt("presto.s3.max-client-retries", this.s3MaxClientRetries);
        config.setInt("presto.s3.max-error-retries", this.s3MaxErrorRetries);
        config.set("presto.s3.max-backoff-time", this.s3MaxBackoffTime.toString());
        config.set("presto.s3.max-retry-time", this.s3MaxRetryTime.toString());
        config.set("presto.s3.connect-timeout", this.s3ConnectTimeout.toString());
        config.set("presto.s3.socket-timeout", this.s3SocketTimeout.toString());
        config.set("presto.s3.staging-directory", this.s3StagingDirectory.toString());
        config.setInt("presto.s3.max-connections", this.s3MaxConnections);
        config.setLong("presto.s3.multipart.min-file-size", this.s3MultipartMinFileSize.toBytes());
        config.setLong("presto.s3.multipart.min-part-size", this.s3MultipartMinPartSize.toBytes());
        config.setBoolean("presto.s3.pin-client-to-current-region", this.pinS3ClientToCurrentRegion);
    }

    public static void configureCompression(Configuration config, HiveCompressionCodec compressionCodec) {
        boolean compression = compressionCodec != HiveCompressionCodec.NONE;
        config.setBoolean(HiveConf.ConfVars.COMPRESSRESULT.varname, compression);
        config.setBoolean("mapred.output.compress", compression);
        config.setBoolean("mapreduce.output.fileoutputformat.compress", compression);
        config.set(HiveConf.ConfVars.HIVE_ORC_DEFAULT_COMPRESS.varname, compressionCodec.getOrcCompressionKind().name());
        config.set(OrcConf.ConfVars.HIVE_ORC_COMPRESSION.varname, compressionCodec.getOrcCompressionKind().name());
        config.set(OrcFile.OrcTableProperties.COMPRESSION.getPropName(), compressionCodec.getOrcCompressionKind().name());
        if (compressionCodec.getCodec().isPresent()) {
            config.set("mapred.output.compression.codec", compressionCodec.getCodec().get().getName());
            config.set("mapreduce.output.fileoutputformat.compress.codec", compressionCodec.getCodec().get().getName());
        } else {
            config.unset("mapred.output.compression.codec");
            config.unset("mapreduce.output.fileoutputformat.compress.codec");
        }
        config.set("parquet.compression", compressionCodec.getParquetCompressionCodec().name());
        config.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
    }

    public static class NoOpDNSToSwitchMapping
    implements DNSToSwitchMapping {
        public List<String> resolve(List<String> names) {
            return ImmutableList.of();
        }

        public void reloadCachedMappings() {
        }
    }
}

