/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;

public class HiveBucketProperty {
    private final List<String> clusteredBy;
    private final int bucketCount;

    @JsonCreator
    public HiveBucketProperty(@JsonProperty(value="clusteredBy") List<String> clusteredBy, @JsonProperty(value="bucketCount") int bucketCount) {
        this.clusteredBy = Objects.requireNonNull(clusteredBy, "clusteredBy is null");
        this.bucketCount = Objects.requireNonNull(Integer.valueOf(bucketCount), "bucketCount is null");
    }

    public static Optional<HiveBucketProperty> fromStorageDescriptor(StorageDescriptor storageDescriptor, String tablePartitionName) {
        boolean numBucketsSet;
        boolean bucketColsSet = storageDescriptor.isSetBucketCols() && !storageDescriptor.getBucketCols().isEmpty();
        boolean bl = numBucketsSet = storageDescriptor.isSetNumBuckets() && storageDescriptor.getNumBuckets() > 0;
        if (bucketColsSet != numBucketsSet) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Only one of bucketCols and numBuckets is set in metadata of table/partition " + tablePartitionName);
        }
        if (!bucketColsSet) {
            return Optional.empty();
        }
        return Optional.of(new HiveBucketProperty(storageDescriptor.getBucketCols(), storageDescriptor.getNumBuckets()));
    }

    @JsonProperty
    public List<String> getClusteredBy() {
        return this.clusteredBy;
    }

    @JsonProperty
    public int getBucketCount() {
        return this.bucketCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveBucketProperty that = (HiveBucketProperty)o;
        return this.bucketCount == that.bucketCount && Objects.equals(this.clusteredBy, that.clusteredBy);
    }

    public int hashCode() {
        return Objects.hash(this.clusteredBy, this.bucketCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clusteredBy", this.clusteredBy).add("bucketCount", this.bucketCount).toString();
    }
}

