/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.PrestoS3FileSystem;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveLocationService
implements LocationService {
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public HiveLocationService(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment) {
        this.metastore = Objects.requireNonNull(metastore);
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment);
    }

    @Override
    public LocationHandle forNewTable(String queryId, String schemaName, String tableName) {
        Path targetPath = HiveWriteUtils.getTableDefaultLocation(this.metastore, this.hdfsEnvironment, schemaName, tableName);
        if (HiveWriteUtils.pathExists(this.hdfsEnvironment, targetPath)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        Path writePath = this.shouldUseTemporaryDirectory(targetPath) ? HiveWriteUtils.createTemporaryPath(this.hdfsEnvironment, targetPath) : targetPath;
        return new LocationHandle(targetPath, Optional.of(writePath), false);
    }

    @Override
    public LocationHandle forExistingTable(String queryId, Table table) {
        Path targetPath = new Path(table.getSd().getLocation());
        Optional<Object> writePath = this.shouldUseTemporaryDirectory(targetPath) ? Optional.of(HiveWriteUtils.createTemporaryPath(this.hdfsEnvironment, targetPath)) : Optional.empty();
        return new LocationHandle(targetPath, writePath, true);
    }

    private boolean shouldUseTemporaryDirectory(Path path) {
        try {
            return !(this.hdfsEnvironment.getFileSystem(path) instanceof PrestoS3FileSystem);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed checking path: " + path, (Throwable)e);
        }
    }

    @Override
    public Path targetPath(LocationHandle locationHandle, Partition partition, String partitionName) {
        return new Path(partition.getSd().getLocation());
    }

    @Override
    public Path targetPath(LocationHandle locationHandle, Optional<String> partitionName) {
        if (!partitionName.isPresent()) {
            return locationHandle.getTargetPath();
        }
        return new Path(locationHandle.getTargetPath(), partitionName.get());
    }

    @Override
    public Path targetPathRoot(LocationHandle locationHandle) {
        return locationHandle.getTargetPath();
    }

    @Override
    public Optional<Path> writePath(LocationHandle locationHandle, Optional<String> partitionName) {
        if (!partitionName.isPresent()) {
            return locationHandle.getWritePath();
        }
        return locationHandle.getWritePath().map(path -> new Path(path, (String)partitionName.get()));
    }

    @Override
    public Optional<Path> writePathRoot(LocationHandle locationHandle) {
        return locationHandle.getWritePath();
    }
}

