/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hadoop.HadoopFileStatus;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveInsertTableHandle;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HivePartitioningHandle;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTableProperties;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.HiveViewNotSupportedException;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.ViewAlreadyExistsException;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.airlift.concurrent.MoreFutures;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.joda.time.DateTimeZone;

public class HiveMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(HiveMetadata.class);
    private static final int PARTITION_COMMIT_BATCH_SIZE = 8;
    private final String connectorId;
    private final boolean allowDropTable;
    private final boolean allowRenameTable;
    private final boolean allowAddColumn;
    private final boolean allowRenameColumn;
    private final boolean allowCorruptWritesForTesting;
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final DateTimeZone timeZone;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final TableParameterCodec tableParameterCodec;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final Executor renameExecutor;
    private final boolean respectTableFormat;
    private final HiveStorageFormat defaultStorageFormat;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();

    public HiveMetadata(String connectorId, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, DateTimeZone timeZone, boolean allowDropTable, boolean allowRenameTable, boolean allowAddColumn, boolean allowRenameColumn, boolean allowCorruptWritesForTesting, boolean respectTableFormat, HiveStorageFormat defaultStorageFormat, TypeManager typeManager, LocationService locationService, TableParameterCodec tableParameterCodec, JsonCodec<PartitionUpdate> partitionUpdateCodec, Executor renameExecutor) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.allowDropTable = allowDropTable;
        this.allowRenameTable = allowRenameTable;
        this.allowAddColumn = allowAddColumn;
        this.allowRenameColumn = allowRenameColumn;
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.tableParameterCodec = Objects.requireNonNull(tableParameterCodec, "tableParameterCodec is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.respectTableFormat = respectTableFormat;
        this.defaultStorageFormat = Objects.requireNonNull(defaultStorageFormat, "defaultStorageFormat is null");
        this.renameExecutor = Objects.requireNonNull(renameExecutor, "renameExecution is null");
    }

    public HiveMetastore getMetastore() {
        return this.metastore;
    }

    public HivePartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metastore.getAllDatabases();
    }

    public HiveTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (!this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).isPresent()) {
            return null;
        }
        return new HiveTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        return this.getTableMetadata(tableName);
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        Optional<HiveBucketProperty> bucketProperty;
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent() || table.get().getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new TableNotFoundException(tableName);
        }
        Function<HiveColumnHandle, ColumnMetadata> metadataGetter = HiveMetadata.columnMetadataGetter(table.get(), this.typeManager);
        boolean sampled = false;
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles(this.connectorId, table.get())) {
            if (columnHandle.getName().equals("__presto__sample_weight__")) {
                sampled = true;
                continue;
            }
            columns.add((Object)metadataGetter.apply(columnHandle));
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        try {
            HiveStorageFormat format = HiveMetadata.extractHiveStorageFormat(table.get());
            properties.put((Object)"format", (Object)format);
        }
        catch (PrestoException format) {
            // empty catch block
        }
        List partitionedBy = table.get().getPartitionKeys().stream().map(FieldSchema::getName).collect(Collectors.toList());
        if (!partitionedBy.isEmpty()) {
            properties.put((Object)"partitioned_by", partitionedBy);
        }
        if ((bucketProperty = HiveBucketProperty.fromStorageDescriptor(table.get().getSd(), table.get().getTableName())).isPresent()) {
            properties.put((Object)"bucket_count", (Object)bucketProperty.get().getBucketCount());
            properties.put((Object)"clustered_by", bucketProperty.get().getClusteredBy());
        }
        if (table.get().isSetParameters()) {
            properties.putAll(this.tableParameterCodec.decode(table.get().getParameters()));
        }
        return new ConnectorTableMetadata(tableName, (List)columns.build(), (Map)properties.build(), table.get().getOwner(), sampled);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            for (String tableName : this.metastore.getAllTables(schemaName).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return this.listSchemaNames(session);
        }
        return ImmutableList.of((Object)schemaNameOrNull);
    }

    public ColumnHandle getSampleWeightColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles(this.connectorId, table.get())) {
            if (!columnHandle.getName().equals("__presto__sample_weight__")) continue;
            return columnHandle;
        }
        return null;
    }

    public boolean canCreateSampledTables(ConnectorSession session) {
        return true;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles(this.connectorId, table.get())) {
            if (columnHandle.getName().equals("__presto__sample_weight__")) continue;
            columnHandles.put((Object)columnHandle.getName(), (Object)columnHandle);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (HiveViewNotSupportedException hiveViewNotSupportedException) {
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null || prefix.getTableName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        return Types.checkType(columnHandle, HiveColumnHandle.class, "columnHandle").getColumnMetadata(this.typeManager);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableMetadata.getOwner()) ? 1 : 0) != 0, (Object)"Table owner is null or empty");
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (bucketProperty.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed Hive table has been temporarily disabled");
        }
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(this.connectorId, tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy));
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        Map<String, String> additionalTableParameters = this.tableParameterCodec.encode(tableMetadata.getProperties());
        LocationHandle locationHandle = this.locationService.forNewTable(session.getQueryId(), schemaName, tableName);
        Path targetPath = this.locationService.targetPathRoot(locationHandle);
        HiveWriteUtils.createDirectory(this.hdfsEnvironment, targetPath);
        this.createTable(schemaName, tableName, tableMetadata.getOwner(), columnHandles, hiveStorageFormat, partitionedBy, bucketProperty, additionalTableParameters, targetPath);
    }

    private Table createTable(String schemaName, String tableName, String tableOwner, List<HiveColumnHandle> columnHandles, HiveStorageFormat hiveStorageFormat, List<String> partitionedBy, Optional<HiveBucketProperty> bucketProperty, Map<String, String> additionalTableParameters, Path targetPath) {
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new FieldSchema(column.getName(), column.getHiveType().getHiveTypeName(), null)).collect(Collectors.toList());
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(partitionedBy);
        boolean sampled = false;
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : columnHandles) {
            String name = columnHandle.getName();
            String type = columnHandle.getHiveType().getHiveTypeName();
            if (name.equals("__presto__sample_weight__")) {
                columns.add((Object)new FieldSchema(name, type, "Presto sample weight column"));
                sampled = true;
                continue;
            }
            if (!partitionColumnNames.contains(name)) {
                Verify.verify((!columnHandle.isPartitionKey() ? 1 : 0) != 0, (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
                columns.add((Object)new FieldSchema(name, type, null));
                continue;
            }
            Verify.verify((boolean)columnHandle.isPartitionKey(), (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
        }
        Table table = new Table();
        table.setDbName(schemaName);
        table.setTableName(tableName);
        table.setOwner(tableOwner);
        table.setTableType(TableType.MANAGED_TABLE.toString());
        String tableComment = "Created by Presto";
        if (sampled) {
            tableComment = "Sampled table created by Presto. Only query this table from Hive if you understand how Presto implements sampling.";
        }
        table.setParameters((Map)ImmutableMap.builder().put((Object)"comment", (Object)tableComment).putAll(additionalTableParameters).build());
        table.setPartitionKeys(partitionColumns);
        table.setSd(HiveMetadata.makeStorageDescriptor(tableName, hiveStorageFormat, targetPath, (List<FieldSchema>)columns.build(), bucketProperty));
        PrivilegeGrantInfo allPrivileges = new PrivilegeGrantInfo("all", 0, tableOwner, PrincipalType.USER, true);
        table.setPrivileges(new PrincipalPrivilegeSet((Map)ImmutableMap.of((Object)tableOwner, (Object)ImmutableList.of((Object)allPrivileges)), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
        this.metastore.createTable(table);
        return table;
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        if (!this.allowAddColumn) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "Adding Columns is disabled in this Hive catalog");
        }
        HiveTableHandle handle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        Optional<Table> tableMetadata = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (!tableMetadata.isPresent()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        Table table = tableMetadata.get();
        StorageDescriptor sd = table.getSd();
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.addAll((Iterable)sd.getCols());
        columns.add((Object)new FieldSchema(column.getName(), HiveType.toHiveType(column.getType()).getHiveTypeName(), column.getComment()));
        sd.setCols((List)columns.build());
        table.setSd(sd);
        this.metastore.alterTable(handle.getSchemaName(), handle.getTableName(), table);
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        if (!this.allowRenameColumn) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "Renaming columns is disabled in this Hive catalog");
        }
        HiveTableHandle hiveTableHandle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        HiveColumnHandle sourceHandle = Types.checkType(source, HiveColumnHandle.class, "columnHandle");
        Optional<Table> tableMetadata = this.metastore.getTable(hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName());
        if (!tableMetadata.isPresent()) {
            throw new TableNotFoundException(hiveTableHandle.getSchemaTableName());
        }
        Table table = tableMetadata.get();
        StorageDescriptor sd = table.getSd();
        ImmutableList.Builder columns = ImmutableList.builder();
        for (FieldSchema fieldSchema : sd.getCols()) {
            if (fieldSchema.getName().equals(sourceHandle.getName())) {
                columns.add((Object)new FieldSchema(target, fieldSchema.getType(), fieldSchema.getComment()));
                continue;
            }
            columns.add((Object)fieldSchema);
        }
        sd.setCols((List)columns.build());
        table.setSd(sd);
        this.metastore.alterTable(hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), table);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        if (!this.allowRenameTable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "Renaming tables is disabled in this Hive catalog");
        }
        HiveTableHandle handle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        Optional<Table> source = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (!source.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        Table table = source.get();
        table.setDbName(newTableName.getSchemaName());
        table.setTableName(newTableName.getTableName());
        this.metastore.alterTable(handle.getSchemaName(), handle.getTableName(), table);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        if (!this.allowDropTable) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "DROP TABLE is disabled in this Hive catalog");
        }
        Optional<Table> target = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        Table table = target.get();
        if (!session.getUser().equals(table.getOwner())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, String.format("Unable to drop table '%s': owner of the table is different from session user", table));
        }
        this.metastore.dropTable(handle.getSchemaName(), handle.getTableName());
    }

    public HiveOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        this.checkNoRollback();
        this.verifyJvmTimeZone();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableMetadata.getOwner()) ? 1 : 0) != 0, (Object)"Table owner is null or empty");
        HiveStorageFormat tableStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (bucketProperty.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed Hive table has been temporarily disabled");
        }
        Map<String, String> additionalTableParameters = this.tableParameterCodec.encode(tableMetadata.getProperties());
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(this.connectorId, tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy));
        HiveOutputTableHandle result = new HiveOutputTableHandle(this.connectorId, schemaName, tableName, columnHandles, session.getQueryId(), this.locationService.forNewTable(session.getQueryId(), schemaName, tableName), tableStorageFormat, this.respectTableFormat ? tableStorageFormat : this.defaultStorageFormat, partitionedBy, bucketProperty, tableMetadata.getOwner(), additionalTableParameters);
        this.setRollback(() -> this.rollbackCreateTable(result));
        return result;
    }

    public void finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments) {
        Path writePath;
        HiveOutputTableHandle handle = Types.checkType(tableHandle, HiveOutputTableHandle.class, "tableHandle");
        List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(Collectors.toList());
        Path targetPath = this.locationService.targetPathRoot(handle.getLocationHandle());
        if (!targetPath.equals((Object)(writePath = this.locationService.writePathRoot(handle.getLocationHandle()).get()))) {
            if (HiveWriteUtils.pathExists(this.hdfsEnvironment, targetPath)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", handle.getSchemaName(), handle.getTableName(), targetPath));
            }
            HiveWriteUtils.renameDirectory(this.hdfsEnvironment, handle.getSchemaName(), handle.getTableName(), writePath, targetPath);
        }
        PartitionCommitter partitionCommitter = new PartitionCommitter(handle.getSchemaName(), handle.getTableName(), this.metastore, 8);
        try {
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
            Table table = this.createTable(handle.getSchemaName(), handle.getTableName(), handle.getTableOwner(), handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionedBy(), handle.getBucketProperty(), handle.getAdditionalTableParameters(), targetPath);
            if (!handle.getPartitionedBy().isEmpty()) {
                if (this.respectTableFormat) {
                    Verify.verify((handle.getPartitionStorageFormat() == handle.getTableStorageFormat() ? 1 : 0) != 0);
                }
                partitionUpdates.stream().map(partitionUpdate -> this.createPartition(table, (PartitionUpdate)partitionUpdate)).forEach(partitionCommitter::addPartition);
            }
            partitionCommitter.flush();
        }
        catch (Throwable throwable) {
            partitionCommitter.abort();
            this.rollbackPartitionUpdates(partitionUpdates, "table creation");
            throw throwable;
        }
        this.clearRollback();
    }

    private void rollbackCreateTable(ConnectorOutputTableHandle tableHandle) {
        HiveOutputTableHandle handle = Types.checkType(tableHandle, HiveOutputTableHandle.class, "tableHandle");
        this.cleanupTempDirectory(this.locationService.writePathRoot(handle.getLocationHandle()).get().toString(), handle.getFilePrefix(), "create table");
    }

    public HiveInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.checkNoRollback();
        this.verifyJvmTimeZone();
        SchemaTableName tableName = HiveUtil.schemaTableName(tableHandle);
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        HiveWriteUtils.checkTableIsWritable(table.get());
        List<HiveColumnHandle> handles = HiveUtil.hiveColumnHandles(this.connectorId, table.get());
        for (HiveColumnHandle hiveColumnHandle : handles) {
            if (HiveWriteUtils.isWritableType(hiveColumnHandle.getHiveType())) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table with column type %s not supported", hiveColumnHandle.getHiveType()));
        }
        HiveStorageFormat tableStorageFormat = HiveMetadata.extractHiveStorageFormat(table.get());
        HiveInsertTableHandle result = new HiveInsertTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName(), handles, session.getQueryId(), this.locationService.forExistingTable(session.getQueryId(), table.get()), HiveBucketProperty.fromStorageDescriptor(table.get().getSd(), table.get().getTableName()), tableStorageFormat, this.respectTableFormat ? tableStorageFormat : this.defaultStorageFormat);
        this.setRollback(() -> this.rollbackInsert(result));
        return result;
    }

    public void finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments) {
        HiveInsertTableHandle handle = Types.checkType(insertHandle, HiveInsertTableHandle.class, "invalid insertTableHandle");
        List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(Collectors.toList());
        HiveStorageFormat tableStorageFormat = handle.getTableStorageFormat();
        PartitionCommitter partitionCommitter = new PartitionCommitter(handle.getSchemaName(), handle.getTableName(), this.metastore, 8);
        try {
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
            Optional<Table> table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
            if (!table.isPresent()) {
                throw new TableNotFoundException(new SchemaTableName(handle.getSchemaName(), handle.getTableName()));
            }
            if (!table.get().getSd().getInputFormat().equals(tableStorageFormat.getInputFormat()) && this.respectTableFormat) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during insert");
            }
            ArrayList<CompletableFuture<Void>> fileRenameFutures = new ArrayList<CompletableFuture<Void>>();
            for (PartitionUpdate partitionUpdate : partitionUpdates) {
                FileSystem fileSystem;
                if (!partitionUpdate.getName().isEmpty() && partitionUpdate.isNew()) {
                    Partition partition;
                    if (!partitionUpdate.getWritePath().equals(partitionUpdate.getTargetPath())) {
                        HiveWriteUtils.renameDirectory(this.hdfsEnvironment, table.get().getDbName(), table.get().getTableName(), new Path(partitionUpdate.getWritePath()), new Path(partitionUpdate.getTargetPath()));
                    }
                    if (!(partition = this.createPartition(table.get(), partitionUpdate)).getSd().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && this.respectTableFormat) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Partition format changed during insert");
                    }
                    partitionCommitter.addPartition(partition);
                    continue;
                }
                if (partitionUpdate.getWritePath().equals(partitionUpdate.getTargetPath())) continue;
                Path writeDir = new Path(partitionUpdate.getWritePath());
                Path targetDir = new Path(partitionUpdate.getTargetPath());
                try {
                    fileSystem = this.hdfsEnvironment.getFileSystem(targetDir);
                }
                catch (IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e);
                }
                for (String fileName : partitionUpdate.getFileNames()) {
                    fileRenameFutures.add(CompletableFuture.runAsync(() -> {
                        Path source = new Path(writeDir, fileName);
                        Path target = new Path(targetDir, fileName);
                        try {
                            fileSystem.rename(source, target);
                        }
                        catch (IOException e) {
                            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Error moving INSERT data from %s to final location %s", source, target), (Throwable)e);
                        }
                    }, this.renameExecutor));
                }
            }
            partitionCommitter.flush();
            for (CompletableFuture completableFuture : fileRenameFutures) {
                MoreFutures.getFutureValue((Future)completableFuture, PrestoException.class);
            }
        }
        catch (Throwable t) {
            partitionCommitter.abort();
            this.rollbackPartitionUpdates(partitionUpdates, "insert");
            throw t;
        }
        this.clearRollback();
    }

    private Partition createPartition(Table table, PartitionUpdate partitionUpdate) {
        List<String> values = HivePartitionManager.extractPartitionKeyValues(partitionUpdate.getName());
        Partition partition = new Partition();
        partition.setDbName(table.getDbName());
        partition.setTableName(table.getTableName());
        partition.setValues(values);
        if (this.respectTableFormat) {
            partition.setSd(table.getSd().deepCopy());
            partition.getSd().setLocation(partitionUpdate.getTargetPath());
        } else {
            partition.setSd(HiveMetadata.makeStorageDescriptor(table.getTableName(), this.defaultStorageFormat, new Path(partitionUpdate.getTargetPath()), table.getSd().getCols(), HiveBucketProperty.fromStorageDescriptor(table.getSd(), table.getTableName())));
        }
        return partition;
    }

    private void rollbackInsert(ConnectorInsertTableHandle insertHandle) {
        HiveInsertTableHandle handle = Types.checkType(insertHandle, HiveInsertTableHandle.class, "invalid insertHandle");
        Optional<Path> writePath = this.locationService.writePathRoot(handle.getLocationHandle());
        if (writePath.isPresent()) {
            this.cleanupTempDirectory(writePath.get().toString(), handle.getFilePrefix(), "insert");
            return;
        }
        Optional<Table> table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (!table.isPresent()) {
            log.error("Error rolling back insert into table %s.%s. Table was dropped during insert, and data directory may contain temporary data", new Object[]{handle.getSchemaName(), handle.getTableName()});
            return;
        }
        HashSet<String> locationsToClean = new HashSet<String>();
        String tableDirectory = this.locationService.targetPathRoot(handle.getLocationHandle()).toString();
        locationsToClean.add(tableDirectory);
        if (!table.get().getPartitionKeys().isEmpty()) {
            List<String> partitionNames = this.metastore.getPartitionNames(handle.getSchemaName(), handle.getTableName()).orElse((List<String>)ImmutableList.of());
            for (List partitionNameBatch : Iterables.partition(partitionNames, (int)10)) {
                this.metastore.getPartitionsByNames(handle.getSchemaName(), handle.getTableName(), partitionNameBatch).orElse((Map<String, Partition>)ImmutableMap.of()).values().stream().map(partition -> partition.getSd().getLocation()).filter(location -> !location.startsWith(tableDirectory)).forEach(locationsToClean::add);
            }
        }
        ArrayList<String> notDeletedFiles = new ArrayList<String>();
        for (String location2 : locationsToClean) {
            notDeletedFiles.addAll(this.recursiveDeleteFilesStartingWith(location2, handle.getFilePrefix()));
        }
        if (!notDeletedFiles.isEmpty()) {
            log.error("Cannot delete insert data files %s", new Object[]{notDeletedFiles});
        }
    }

    private void cleanupTempDirectory(String location, String filePrefix, String actionName) {
        List<String> notDeletedFiles = this.recursiveDeleteFilesStartingWith(location, filePrefix);
        if (!notDeletedFiles.isEmpty()) {
            log.warn("Error rolling back " + actionName + " temporary data files %s", new Object[]{notDeletedFiles.stream().collect(Collectors.joining(", "))});
        }
        if (!this.deleteIfExists(location)) {
            log.debug("Error deleting " + actionName + " temp data in %s", new Object[]{location});
        }
    }

    private void rollbackPartitionUpdates(List<PartitionUpdate> partitionUpdates, String actionName) {
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            List<String> notDeletedFiles;
            String targetPath = partitionUpdate.getTargetPath();
            String writePath = partitionUpdate.getWritePath();
            if (!writePath.equals(targetPath)) {
                notDeletedFiles = this.deleteFilesFrom(writePath, partitionUpdate.getFileNames());
                if (!notDeletedFiles.isEmpty()) {
                    log.warn("Error rolling back " + actionName + " temporary data files %s", new Object[]{notDeletedFiles.stream().collect(Collectors.joining(", "))});
                }
                if (!this.deleteIfExists(writePath)) {
                    log.debug("Error deleting " + actionName + " temp data in %s", new Object[]{writePath});
                }
            }
            if (!(notDeletedFiles = this.deleteFilesFrom(targetPath, partitionUpdate.getFileNames())).isEmpty()) {
                log.error("Error rolling back " + actionName + " data files %s", new Object[]{notDeletedFiles.stream().collect(Collectors.joining(", "))});
            }
            if (!partitionUpdate.isNew() || this.deleteIfExists(targetPath)) continue;
            log.debug("Cannot delete " + actionName + " directory %s", new Object[]{targetPath});
        }
    }

    public boolean deleteIfExists(String location) {
        FileSystem fileSystem;
        Path path = new Path(location);
        try {
            fileSystem = this.hdfsEnvironment.getFileSystem(path);
        }
        catch (IOException ignored) {
            return false;
        }
        return HiveMetadata.deleteIfExists(fileSystem, path);
    }

    private static boolean deleteIfExists(FileSystem fileSystem, Path path) {
        try {
            if (fileSystem.delete(path, false)) {
                return true;
            }
            return !fileSystem.exists(path);
        }
        catch (FileNotFoundException ignored) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private List<String> deleteFilesFrom(String location, List<String> fileNames) {
        FileSystem fileSystem;
        Path directory = new Path(location);
        try {
            fileSystem = this.hdfsEnvironment.getFileSystem(directory);
        }
        catch (IOException e) {
            return fileNames;
        }
        ImmutableList.Builder notDeletedFiles = ImmutableList.builder();
        for (String fileName : fileNames) {
            Path file = new Path(directory, fileName);
            if (HiveMetadata.deleteIfExists(fileSystem, file)) continue;
            notDeletedFiles.add((Object)file.toString());
        }
        return notDeletedFiles.build();
    }

    private List<String> recursiveDeleteFilesStartingWith(String location, String filePrefix) {
        FileSystem fileSystem;
        try {
            Path directory = new Path(location);
            fileSystem = this.hdfsEnvironment.getFileSystem(directory);
        }
        catch (IOException e) {
            return ImmutableList.of((Object)(location + "/" + filePrefix + "*"));
        }
        return HiveMetadata.recursiveDeleteFilesStartingWith(fileSystem, new Path(location), filePrefix);
    }

    private static List<String> recursiveDeleteFilesStartingWith(FileSystem fileSystem, Path directory, String filePrefix) {
        FileStatus[] allFiles;
        try {
            allFiles = fileSystem.listStatus(directory);
        }
        catch (IOException e) {
            return ImmutableList.of((Object)(directory + "/" + filePrefix + "*"));
        }
        ImmutableList.Builder notDeletedFiles = ImmutableList.builder();
        for (FileStatus fileStatus : allFiles) {
            Path path = fileStatus.getPath();
            if (HadoopFileStatus.isFile((FileStatus)fileStatus) && path.getName().startsWith(filePrefix)) {
                if (HiveMetadata.deleteIfExists(fileSystem, path)) continue;
                notDeletedFiles.add((Object)path.toString());
                continue;
            }
            if (!HadoopFileStatus.isDirectory((FileStatus)fileStatus)) continue;
            notDeletedFiles.addAll(HiveMetadata.recursiveDeleteFilesStartingWith(fileSystem, path, filePrefix));
        }
        return notDeletedFiles.build();
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, String viewData, boolean replace) {
        if (replace) {
            try {
                this.dropView(session, viewName);
            }
            catch (ViewNotFoundException viewNotFoundException) {
                // empty catch block
            }
        }
        ImmutableMap properties = ImmutableMap.builder().put((Object)"comment", (Object)"Presto View").put((Object)"presto_view", (Object)"true").build();
        FieldSchema dummyColumn = new FieldSchema("dummy", "string", null);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols((List)ImmutableList.of((Object)dummyColumn));
        sd.setSerdeInfo(new SerDeInfo());
        Table table = new Table();
        table.setDbName(viewName.getSchemaName());
        table.setTableName(viewName.getTableName());
        table.setOwner(session.getUser());
        table.setTableType(TableType.VIRTUAL_VIEW.name());
        table.setParameters((Map)properties);
        table.setViewOriginalText(HiveUtil.encodeViewData(viewData));
        table.setViewExpandedText("/* Presto View */");
        table.setSd(sd);
        PrivilegeGrantInfo allPrivileges = new PrivilegeGrantInfo("all", 0, session.getUser(), PrincipalType.USER, true);
        table.setPrivileges(new PrincipalPrivilegeSet((Map)ImmutableMap.of((Object)session.getUser(), (Object)ImmutableList.of((Object)allPrivileges)), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
        try {
            this.metastore.createTable(table);
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        ConnectorViewDefinition view = this.getViews(session, viewName.toSchemaTablePrefix()).get(viewName);
        if (view == null) {
            throw new ViewNotFoundException(viewName);
        }
        try {
            this.metastore.dropTable(viewName.getSchemaName(), viewName.getTableName());
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, schemaNameOrNull)) {
            for (String tableName : this.metastore.getAllViews(schemaName).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getTableName() != null ? ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName())) : this.listViews(session, prefix.getSchemaName());
        for (SchemaTableName schemaTableName : tableNames) {
            Optional<Table> table = this.metastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName());
            if (!table.isPresent() || !HiveUtil.isPrestoView(table.get())) continue;
            views.put((Object)schemaTableName, (Object)new ConnectorViewDefinition(schemaTableName, Optional.ofNullable(table.get().getOwner()), HiveUtil.decodeViewData(table.get().getViewOriginalText())));
        }
        return views.build();
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector only supports delete where one or more partitions are deleted entirely");
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return HiveColumnHandle.updateRowIdHandle(this.connectorId);
    }

    public OptionalLong metadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        HiveTableHandle handle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        HiveTableLayoutHandle layoutHandle = Types.checkType(tableLayoutHandle, HiveTableLayoutHandle.class, "tableLayoutHandle");
        for (HivePartition hivePartition : this.getOrComputePartitions(layoutHandle, session, tableHandle)) {
            this.metastore.dropPartitionByName(handle.getSchemaName(), handle.getTableName(), hivePartition.getPartitionId());
        }
        return OptionalLong.empty();
    }

    private List<HivePartition> getOrComputePartitions(HiveTableLayoutHandle layoutHandle, ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (layoutHandle.getPartitions().isPresent()) {
            return layoutHandle.getPartitions().get();
        }
        TupleDomain<ColumnHandle> promisedPredicate = layoutHandle.getPromisedPredicate();
        Predicate<Map<ColumnHandle, NullableValue>> predicate = HiveMetadata.convertToPredicate(promisedPredicate);
        List<ConnectorTableLayoutResult> tableLayoutResults = this.getTableLayouts(session, tableHandle, (Constraint<ColumnHandle>)new Constraint(promisedPredicate, predicate), Optional.empty());
        return Types.checkType(((ConnectorTableLayoutResult)Iterables.getOnlyElement(tableLayoutResults)).getTableLayout().getHandle(), HiveTableLayoutHandle.class, "tableLayoutHandle").getPartitions().get();
    }

    @VisibleForTesting
    static Predicate<Map<ColumnHandle, NullableValue>> convertToPredicate(TupleDomain<ColumnHandle> tupleDomain) {
        return bindings -> tupleDomain.contains(TupleDomain.fromFixedValues((Map)bindings));
    }

    public boolean supportsMetadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        HiveTableLayoutHandle layoutHandle = Types.checkType(tableLayoutHandle, HiveTableLayoutHandle.class, "tableLayoutHandle");
        return layoutHandle.getPartitions().get().stream().noneMatch(partition -> "<UNPARTITIONED>".equals(partition.getPartitionId()));
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        HiveTableHandle handle = Types.checkType(tableHandle, HiveTableHandle.class, "tableHandle");
        HivePartitionResult hivePartitionResult = this.partitionManager.getPartitions(session, this.metastore, tableHandle, (TupleDomain<ColumnHandle>)constraint.getSummary());
        List<HivePartition> partitions = hivePartitionResult.getPartitions().stream().filter(partition -> constraint.predicate().test(partition.getKeys())).collect(Collectors.toList());
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(this.getTableLayout(session, new HiveTableLayoutHandle(handle.getClientId(), (List<ColumnHandle>)ImmutableList.copyOf(hivePartitionResult.getPartitionColumns()), partitions, hivePartitionResult.getEnforcedConstraint(), hivePartitionResult.getBucketHandle())), hivePartitionResult.getUnenforcedConstraint()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle layoutHandle) {
        HiveTableLayoutHandle hiveLayoutHandle = Types.checkType(layoutHandle, HiveTableLayoutHandle.class, "layoutHandle");
        List<ColumnHandle> partitionColumns = hiveLayoutHandle.getPartitionColumns();
        List partitionDomains = hiveLayoutHandle.getPartitions().get().stream().map(HivePartition::getTupleDomain).collect(Collectors.toList());
        TupleDomain predicate = TupleDomain.none();
        if (!partitionDomains.isEmpty()) {
            predicate = TupleDomain.columnWiseUnion(partitionDomains);
        }
        Optional<Object> discretePredicates = Optional.empty();
        if (!partitionColumns.isEmpty()) {
            discretePredicates = Optional.of(new DiscretePredicates(partitionColumns, partitionDomains));
        }
        return new ConnectorTableLayout((ConnectorTableLayoutHandle)hiveLayoutHandle, Optional.empty(), predicate, Optional.empty(), Optional.empty(), discretePredicates, (List)ImmutableList.of());
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (bucketProperty.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed Hive table has been temporarily disabled");
        }
        if (!bucketProperty.isPresent()) {
            return Optional.empty();
        }
        List<String> clusteredBy = bucketProperty.get().getClusteredBy();
        Map<String, HiveType> hiveTypeMap = tableMetadata.getColumns().stream().collect(Collectors.toMap(ColumnMetadata::getName, column -> HiveType.toHiveType(column.getType())));
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)new HivePartitioningHandle(this.connectorId, bucketProperty.get().getBucketCount(), clusteredBy.stream().map(hiveTypeMap::get).collect(Collectors.toList())), clusteredBy));
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, String grantee, boolean grantOption) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Set<PrivilegeGrantInfo> privilegeGrantInfoSet = privileges.stream().map(privilege -> new PrivilegeGrantInfo(privilege.name().toLowerCase(), 0, session.getUser(), PrincipalType.USER, grantOption)).collect(Collectors.toSet());
        this.metastore.grantTablePrivileges(schemaName, tableName, grantee, privilegeGrantInfoSet);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.connectorId).toString();
    }

    private void verifyJvmTimeZone() {
        if (!this.allowCorruptWritesForTesting && !this.timeZone.equals((Object)DateTimeZone.getDefault())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TIMEZONE_MISMATCH, String.format("To write Hive data, your JVM timezone must match the Hive storage timezone. Add -Duser.timezone=%s to your JVM arguments.", this.timeZone.getID()));
        }
    }

    private static HiveStorageFormat extractHiveStorageFormat(Table table) {
        StorageDescriptor descriptor = table.getSd();
        if (descriptor == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        SerDeInfo serdeInfo = descriptor.getSerdeInfo();
        if (serdeInfo == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table storage descriptor is missing SerDe info");
        }
        String outputFormat = descriptor.getOutputFormat();
        String serializationLib = serdeInfo.getSerializationLib();
        for (HiveStorageFormat format : HiveStorageFormat.values()) {
            if (!format.getOutputFormat().equals(outputFormat) || !format.getSerDe().equals(serializationLib)) continue;
            return format;
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Output format %s with SerDe %s is not supported", outputFormat, serializationLib));
    }

    private static void validatePartitionColumns(ConnectorTableMetadata tableMetadata) {
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        List allColumns = tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
        if (!allColumns.containsAll(partitionedBy)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_ERROR, String.format("Partition columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(partitionedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
        if (allColumns.size() == partitionedBy.size()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_ERROR, "Table contains only partition columns");
        }
        if (!allColumns.subList(allColumns.size() - partitionedBy.size(), allColumns.size()).equals(partitionedBy)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_COLUMN_ORDER_MISMATCH, "Partition keys must be the last columns in the table and in the same order as the table properties: " + partitionedBy);
        }
    }

    private static List<HiveColumnHandle> getColumnHandles(String connectorId, ConnectorTableMetadata tableMetadata, Set<String> partitionColumnNames) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        int ordinal = 0;
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            columnHandles.add((Object)new HiveColumnHandle(connectorId, column.getName(), HiveType.toHiveType(column.getType()), column.getType().getTypeSignature(), ordinal, partitionColumnNames.contains(column.getName())));
            ++ordinal;
        }
        if (tableMetadata.isSampled()) {
            columnHandles.add((Object)new HiveColumnHandle(connectorId, "__presto__sample_weight__", HiveType.toHiveType((Type)BigintType.BIGINT), BigintType.BIGINT.getTypeSignature(), ordinal, false));
        }
        return columnHandles.build();
    }

    private static Function<HiveColumnHandle, ColumnMetadata> columnMetadataGetter(Table table, TypeManager typeManager) {
        ImmutableList.Builder columnNames = ImmutableList.builder();
        table.getPartitionKeys().stream().map(FieldSchema::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        table.getSd().getCols().stream().map(FieldSchema::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        ImmutableList allColumnNames = columnNames.build();
        if (allColumnNames.size() > Sets.newHashSet((Iterable)allColumnNames).size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Hive metadata for table %s is invalid: Table descriptor contains duplicate columns", table.getTableName()));
        }
        List tableColumns = table.getSd().getCols();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (FieldSchema field : Iterables.concat((Iterable)tableColumns, (Iterable)table.getPartitionKeys())) {
            if (field.getComment() == null || field.getComment().equals("from deserializer")) continue;
            builder.put((Object)field.getName(), (Object)field.getComment());
        }
        ImmutableMap columnComment = builder.build();
        return arg_0 -> HiveMetadata.lambda$columnMetadataGetter$12(typeManager, (Map)columnComment, arg_0);
    }

    private void checkNoRollback() {
        Preconditions.checkState((this.rollbackAction.get() == null ? 1 : 0) != 0, (Object)"Cannot begin a new write while in an existing one");
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"Should not have to override existing rollback action");
    }

    private void clearRollback() {
        this.rollbackAction.set(null);
    }

    public void rollback() {
        Runnable rollbackAction = this.rollbackAction.getAndSet(null);
        if (rollbackAction != null) {
            rollbackAction.run();
        }
    }

    private static StorageDescriptor makeStorageDescriptor(String tableName, HiveStorageFormat format, Path targetPath, List<FieldSchema> columns, Optional<HiveBucketProperty> bucketProperty) {
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setName(tableName);
        serdeInfo.setSerializationLib(format.getSerDe());
        serdeInfo.setParameters((Map)ImmutableMap.of());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(targetPath.toString());
        sd.setCols(columns);
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(format.getInputFormat());
        sd.setOutputFormat(format.getOutputFormat());
        sd.setParameters((Map)ImmutableMap.of());
        bucketProperty.ifPresent(property -> {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed Hive table has been temporarily disabled");
        });
        return sd;
    }

    private static /* synthetic */ ColumnMetadata lambda$columnMetadataGetter$12(TypeManager typeManager, Map columnComment, HiveColumnHandle handle) {
        return new ColumnMetadata(handle.getName(), typeManager.getType(handle.getTypeSignature()), HiveUtil.annotateColumnComment((String)columnComment.get(handle.getName()), handle.isPartitionKey()), false);
    }

    private static class PartitionCommitter {
        private final String schemaName;
        private final String tableName;
        private final HiveMetastore metastore;
        private final int batchSize;
        private final List<Partition> batch;
        private final List<Partition> createdPartitions = new ArrayList<Partition>();

        public PartitionCommitter(String schemaName, String tableName, HiveMetastore metastore, int batchSize) {
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.metastore = metastore;
            this.batchSize = batchSize;
            this.batch = new ArrayList<Partition>(batchSize);
        }

        public List<Partition> getCreatedPartitions() {
            return ImmutableList.copyOf(this.createdPartitions);
        }

        public void addPartition(Partition partition) {
            this.batch.add(partition);
            if (this.batch.size() >= this.batchSize) {
                this.addBatch();
            }
        }

        public void flush() {
            if (!this.batch.isEmpty()) {
                this.addBatch();
            }
        }

        public void abort() {
            for (Partition createdPartition : this.getCreatedPartitions()) {
                try {
                    this.metastore.dropPartition(this.schemaName, this.tableName, createdPartition.getValues());
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Error rolling back new partition '%s' in table '%s.%s", new Object[]{createdPartition.getValues(), this.schemaName, this.tableName});
                }
            }
        }

        private void addBatch() {
            this.metastore.addPartitions(this.schemaName, this.tableName, this.batch);
            this.createdPartitions.addAll(this.batch);
            this.batch.clear();
        }
    }
}

