/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageIndexer;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.OptimizedLazyBinaryColumnarSerde;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.common.util.ReflectionUtil;

public class HivePageSink
implements ConnectorPageSink {
    private static final int MAX_BUCKET_COUNT = 100000;
    private static final int BUCKET_NUMBER_PADDING = Integer.toString(99999).length();
    private final String schemaName;
    private final String tableName;
    private final int[] dataColumnInputIndex;
    private final List<DataColumn> dataColumns;
    private final int[] partitionColumnsInputIndex;
    private final List<String> partitionColumnNames;
    private final List<Type> partitionColumnTypes;
    private final OptionalInt bucketCount;
    private final int[] bucketColumns;
    private final List<TypeInfo> bucketColumnTypes;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final LocationHandle locationHandle;
    private final LocationService locationService;
    private final String filePrefix;
    private final HiveMetastore metastore;
    private final PageIndexer pageIndexer;
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final JobConf conf;
    private final int maxOpenPartitions;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final List<Object> partitionRow;
    private final Table table;
    private final boolean immutablePartitions;
    private final boolean compress;
    private HiveRecordWriter[] writers;
    private final List<Int2ObjectMap<HiveRecordWriter>> bucketWriters;
    private int bucketWriterCount = 0;

    public HivePageSink(String schemaName, String tableName, boolean isCreateTable, List<HiveColumnHandle> inputColumns, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, LocationHandle locationHandle, LocationService locationService, String filePrefix, Optional<HiveBucketProperty> bucketProperty, HiveMetastore metastore, PageIndexerFactory pageIndexerFactory, TypeManager typeManager, HdfsEnvironment hdfsEnvironment, int maxOpenPartitions, boolean immutablePartitions, boolean compress, JsonCodec<PartitionUpdate> partitionUpdateCodec) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.filePrefix = Objects.requireNonNull(filePrefix, "filePrefix is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.maxOpenPartitions = maxOpenPartitions;
        this.immutablePartitions = immutablePartitions;
        this.compress = compress;
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        ImmutableList.Builder partitionColumnNames = ImmutableList.builder();
        ImmutableList.Builder partitionColumnTypes = ImmutableList.builder();
        ImmutableList.Builder dataColumns = ImmutableList.builder();
        for (HiveColumnHandle column2 : inputColumns) {
            if (column2.isPartitionKey()) {
                partitionColumnNames.add((Object)column2.getName());
                partitionColumnTypes.add((Object)typeManager.getType(column2.getTypeSignature()));
                continue;
            }
            dataColumns.add((Object)new DataColumn(column2.getName(), typeManager.getType(column2.getTypeSignature()), column2.getHiveType()));
        }
        this.partitionColumnNames = partitionColumnNames.build();
        this.partitionColumnTypes = partitionColumnTypes.build();
        this.dataColumns = dataColumns.build();
        ImmutableList.Builder partitionColumns = ImmutableList.builder();
        ImmutableList.Builder dataColumnsInputIndex = ImmutableList.builder();
        Object2IntOpenHashMap dataColumnNameToIdMap = new Object2IntOpenHashMap();
        HashMap<String, HiveType> dataColumnNameToTypeMap = new HashMap<String, HiveType>();
        List inputColumnsWithoutSample = inputColumns.stream().filter(column -> !column.getName().equals("__presto__sample_weight__")).collect(Collectors.toList());
        for (int inputIndex = 0; inputIndex < inputColumnsWithoutSample.size(); ++inputIndex) {
            HiveColumnHandle column3 = (HiveColumnHandle)inputColumnsWithoutSample.get(inputIndex);
            if (column3.isPartitionKey()) {
                partitionColumns.add((Object)inputIndex);
                continue;
            }
            dataColumnsInputIndex.add((Object)inputIndex);
            dataColumnNameToIdMap.put((Object)column3.getName(), inputIndex);
            dataColumnNameToTypeMap.put(column3.getName(), column3.getHiveType());
        }
        this.partitionColumnsInputIndex = Ints.toArray((Collection)partitionColumns.build());
        this.dataColumnInputIndex = Ints.toArray((Collection)dataColumnsInputIndex.build());
        Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        if (bucketProperty.isPresent()) {
            int bucketCount = bucketProperty.get().getBucketCount();
            Preconditions.checkArgument((bucketCount < 100000 ? 1 : 0) != 0, (Object)"bucketCount must be smaller than 100000");
            this.bucketCount = OptionalInt.of(bucketCount);
            this.bucketColumns = bucketProperty.get().getClusteredBy().stream().mapToInt(arg_0 -> ((Object2IntMap)dataColumnNameToIdMap).get(arg_0)).toArray();
            this.bucketColumnTypes = bucketProperty.get().getClusteredBy().stream().map(dataColumnNameToTypeMap::get).map(HiveType::getTypeInfo).collect(Collectors.toList());
            this.bucketWriters = new ArrayList<Int2ObjectMap<HiveRecordWriter>>();
        } else {
            this.bucketCount = OptionalInt.empty();
            this.bucketColumns = null;
            this.bucketColumnTypes = null;
            this.bucketWriters = null;
            this.writers = new HiveRecordWriter[0];
        }
        this.pageIndexer = pageIndexerFactory.createPageIndexer(this.partitionColumnTypes);
        this.partitionRow = Arrays.asList(new Object[this.partitionColumnNames.size()]);
        if (isCreateTable) {
            this.table = null;
            Optional<Path> writePath = locationService.writePathRoot(locationHandle);
            Preconditions.checkArgument((boolean)writePath.isPresent(), (Object)"CREATE TABLE must have a write path");
            this.conf = new JobConf(hdfsEnvironment.getConfiguration(writePath.get()));
        } else {
            Optional<Table> table = metastore.getTable(schemaName, tableName);
            if (!table.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table %s.%s was dropped during insert", schemaName, tableName));
            }
            this.table = table.get();
            Path hdfsEnvironmentPath = locationService.writePathRoot(locationHandle).orElseGet(() -> locationService.targetPathRoot(locationHandle));
            this.conf = new JobConf(hdfsEnvironment.getConfiguration(hdfsEnvironmentPath));
        }
    }

    public Collection<Slice> finish() {
        ImmutableList.Builder partitionUpdates = ImmutableList.builder();
        if (!this.bucketCount.isPresent()) {
            for (HiveRecordWriter writer : this.writers) {
                if (writer == null) continue;
                writer.commit();
                PartitionUpdate partitionUpdate = writer.getPartitionUpdate();
                partitionUpdates.add((Object)Slices.wrappedBuffer((byte[])this.partitionUpdateCodec.toJsonBytes((Object)partitionUpdate)));
            }
        } else {
            for (Int2ObjectMap<HiveRecordWriter> writers : this.bucketWriters) {
                for (HiveRecordWriter writer : writers.values()) {
                    writer.commit();
                    PartitionUpdate partitionUpdate = writer.getPartitionUpdate();
                    partitionUpdates.add((Object)Slices.wrappedBuffer((byte[])this.partitionUpdateCodec.toJsonBytes((Object)partitionUpdate)));
                }
            }
        }
        return partitionUpdates.build();
    }

    public void abort() {
        if (!this.bucketCount.isPresent()) {
            for (HiveRecordWriter writer : this.writers) {
                if (writer == null) continue;
                writer.rollback();
            }
        } else {
            for (Int2ObjectMap<HiveRecordWriter> writers : this.bucketWriters) {
                for (HiveRecordWriter writer : writers.values()) {
                    writer.rollback();
                }
            }
        }
    }

    public CompletableFuture<?> appendPage(Page page, Block sampleWeightBlock) {
        if (page.getPositionCount() == 0) {
            return NOT_BLOCKED;
        }
        Block[] dataBlocks = this.getDataBlocks(page, sampleWeightBlock);
        Block[] partitionBlocks = this.getPartitionBlocks(page);
        int[] indexes = this.pageIndexer.indexPage(new Page(page.getPositionCount(), partitionBlocks));
        if (this.pageIndexer.getMaxIndex() >= this.maxOpenPartitions) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TOO_MANY_OPEN_PARTITIONS, "Too many open partitions");
        }
        if (!this.bucketCount.isPresent()) {
            if (this.pageIndexer.getMaxIndex() >= this.writers.length) {
                this.writers = Arrays.copyOf(this.writers, this.pageIndexer.getMaxIndex() + 1);
            }
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int writerIndex = indexes[position];
                HiveRecordWriter writer = this.writers[writerIndex];
                if (writer == null) {
                    for (int field = 0; field < partitionBlocks.length; ++field) {
                        Object value = HiveWriteUtils.getField(this.partitionColumnTypes.get(field), partitionBlocks[field], position);
                        this.partitionRow.set(field, value);
                    }
                    this.writers[writerIndex] = writer = this.createWriter(this.partitionRow, this.filePrefix + "_" + UUID.randomUUID());
                }
                writer.addRow(dataBlocks, position);
            }
        } else {
            int bucketCount = this.bucketCount.getAsInt();
            Block[] bucketBlocks = new Block[this.bucketColumns.length];
            for (int i = 0; i < this.bucketColumns.length; ++i) {
                bucketBlocks[i] = page.getBlock(this.bucketColumns[i]);
            }
            Page bucketColumnsPage = new Page(page.getPositionCount(), bucketBlocks);
            for (int i = this.bucketWriters.size(); i <= this.pageIndexer.getMaxIndex(); ++i) {
                this.bucketWriters.add((Int2ObjectMap<HiveRecordWriter>)new Int2ObjectOpenHashMap());
            }
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int bucket;
                int writerIndex = indexes[position];
                Int2ObjectMap<HiveRecordWriter> writers = this.bucketWriters.get(writerIndex);
                HiveRecordWriter writer = (HiveRecordWriter)writers.get(bucket = HiveBucketing.getHiveBucket(this.bucketColumnTypes, bucketColumnsPage, position, bucketCount));
                if (writer == null) {
                    if (this.bucketWriterCount >= this.maxOpenPartitions) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TOO_MANY_OPEN_PARTITIONS, "Too many open writers for partitions and buckets");
                    }
                    ++this.bucketWriterCount;
                    for (int field = 0; field < partitionBlocks.length; ++field) {
                        Object value = HiveWriteUtils.getField(this.partitionColumnTypes.get(field), partitionBlocks[field], position);
                        this.partitionRow.set(field, value);
                    }
                    writer = this.createWriter(this.partitionRow, this.filePrefix + "_bucket-" + Strings.padStart((String)Integer.toString(bucket), (int)BUCKET_NUMBER_PADDING, (char)'0'));
                    writers.put(bucket, (Object)writer);
                }
                writer.addRow(dataBlocks, position);
            }
        }
        return NOT_BLOCKED;
    }

    private HiveRecordWriter createWriter(List<Object> partitionRow, String fileName) {
        String serDe;
        String outputFormat;
        Path write;
        Path target;
        Properties schema;
        boolean isNew;
        Preconditions.checkArgument((partitionRow.size() == this.partitionColumnNames.size() ? 1 : 0) != 0, (Object)"size of partitionRow is different from partitionColumnNames");
        List partitionValues = partitionRow.stream().map(value -> value == null ? "__HIVE_DEFAULT_PARTITION__" : value.toString()).collect(Collectors.toList());
        Optional<Object> partitionName = !this.partitionColumnNames.isEmpty() ? Optional.of(FileUtils.makePartName(this.partitionColumnNames, partitionValues)) : Optional.empty();
        Optional<Object> partition = Optional.empty();
        if (!partitionRow.isEmpty() && this.table != null) {
            partition = this.metastore.getPartition(this.schemaName, this.tableName, (String)partitionName.get());
        }
        if (!partition.isPresent()) {
            if (this.table == null) {
                isNew = true;
                schema = new Properties();
                schema.setProperty("columns", this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.joining(",")));
                schema.setProperty("columns.types", this.dataColumns.stream().map(DataColumn::getHiveType).map(HiveType::getHiveTypeName).collect(Collectors.joining(":")));
                target = this.locationService.targetPath(this.locationHandle, partitionName);
                write = this.locationService.writePath(this.locationHandle, partitionName).get();
                if (partitionName.isPresent() && !target.equals((Object)write) && HiveWriteUtils.pathExists(this.hdfsEnvironment, target)) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for new partition '%s' of table '%s.%s' already exists: %s", partitionName, this.schemaName, this.tableName, target));
                }
            } else {
                if (partitionName.isPresent()) {
                    isNew = true;
                } else {
                    if (this.bucketCount.isPresent()) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Can not insert into bucketed unpartitioned Hive table");
                    }
                    if (this.immutablePartitions) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Unpartitioned Hive tables are immutable");
                    }
                    isNew = false;
                }
                schema = MetaStoreUtils.getSchema((StorageDescriptor)this.table.getSd(), (StorageDescriptor)this.table.getSd(), (Map)this.table.getParameters(), (String)this.schemaName, (String)this.tableName, (List)this.table.getPartitionKeys());
                target = this.locationService.targetPath(this.locationHandle, partitionName);
                write = this.locationService.writePath(this.locationHandle, partitionName).orElse(target);
            }
            if (partitionName.isPresent()) {
                outputFormat = this.partitionStorageFormat.getOutputFormat();
                serDe = this.partitionStorageFormat.getSerDe();
            } else {
                outputFormat = this.tableStorageFormat.getOutputFormat();
                serDe = this.tableStorageFormat.getSerDe();
            }
        } else {
            if (this.bucketCount.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Can not insert into existing partitions of bucketed Hive table");
            }
            if (this.immutablePartitions) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Hive partitions are immutable");
            }
            isNew = false;
            HiveWriteUtils.checkPartitionIsWritable((String)partitionName.get(), (Partition)partition.get());
            StorageDescriptor storageDescriptor = ((Partition)partition.get()).getSd();
            outputFormat = storageDescriptor.getOutputFormat();
            serDe = storageDescriptor.getSerdeInfo().getSerializationLib();
            schema = MetaStoreUtils.getSchema((Partition)((Partition)partition.get()), (Table)this.table);
            target = this.locationService.targetPath(this.locationHandle, (Partition)partition.get(), (String)partitionName.get());
            write = this.locationService.writePath(this.locationHandle, partitionName).orElse(target);
        }
        return new HiveRecordWriter(this.schemaName, this.tableName, (String)partitionName.orElse(""), this.compress, isNew, this.dataColumns, outputFormat, serDe, schema, fileName + this.getFileExtension(outputFormat), write.toString(), target.toString(), this.typeManager, this.conf);
    }

    private String getFileExtension(String outputFormat) {
        if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.COMPRESSRESULT) || !HiveIgnoreKeyTextOutputFormat.class.getName().equals(outputFormat)) {
            return "";
        }
        String compressionCodecClass = this.conf.get("mapred.output.compression.codec");
        if (compressionCodecClass == null) {
            return new DefaultCodec().getDefaultExtension();
        }
        try {
            Class<CompressionCodec> codecClass = this.conf.getClassByName(compressionCodecClass).asSubclass(CompressionCodec.class);
            return ((CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)this.conf)).getDefaultExtension();
        }
        catch (ClassNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Compression codec not found: " + compressionCodecClass, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Failed to load compression codec: " + compressionCodecClass, (Throwable)e);
        }
    }

    private Block[] getDataBlocks(Page page, Block sampleWeightBlock) {
        Block[] blocks = new Block[this.dataColumnInputIndex.length + (sampleWeightBlock != null ? 1 : 0)];
        for (int i = 0; i < this.dataColumnInputIndex.length; ++i) {
            int dataColumn = this.dataColumnInputIndex[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        if (sampleWeightBlock != null) {
            blocks[blocks.length - 1] = sampleWeightBlock;
        }
        return blocks;
    }

    private Block[] getPartitionBlocks(Page page) {
        Block[] blocks = new Block[this.partitionColumnsInputIndex.length];
        for (int i = 0; i < this.partitionColumnsInputIndex.length; ++i) {
            int dataColumn = this.partitionColumnsInputIndex[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return blocks;
    }

    @VisibleForTesting
    public static class DataColumn {
        private final String name;
        private final Type type;
        private final HiveType hiveType;

        public DataColumn(String name, Type type, HiveType hiveType) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public HiveType getHiveType() {
            return this.hiveType;
        }
    }

    @VisibleForTesting
    public static class HiveRecordWriter {
        private final String partitionName;
        private final boolean isNew;
        private final String fileName;
        private final String writePath;
        private final String targetPath;
        private final int fieldCount;
        private final Serializer serializer;
        private final FileSinkOperator.RecordWriter recordWriter;
        private final SettableStructObjectInspector tableInspector;
        private final List<StructField> structFields;
        private final Object row;
        private final HiveWriteUtils.FieldSetter[] setters;

        public HiveRecordWriter(String schemaName, String tableName, String partitionName, boolean compress, boolean isNew, List<DataColumn> inputColumns, String outputFormat, String serDe, Properties schema, String fileName, String writePath, String targetPath, TypeManager typeManager, JobConf conf) {
            this.partitionName = partitionName;
            this.isNew = isNew;
            this.fileName = fileName;
            this.writePath = writePath;
            this.targetPath = targetPath;
            List fileColumnNames = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)schema.getProperty("columns", ""));
            List<HiveType> fileColumnHiveTypes = HiveType.toHiveTypes(schema.getProperty("columns.types", ""));
            Map inputColumnMap = inputColumns.stream().collect(Collectors.toMap(DataColumn::getName, Function.identity()));
            Sets.SetView missingColumns = Sets.difference(inputColumnMap.keySet(), new HashSet(fileColumnNames));
            if (!missingColumns.isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table %s.%s does not have columns %s", schema, tableName, missingColumns));
            }
            if (fileColumnNames.size() != fileColumnHiveTypes.size()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Partition '%s' in table '%s.%s' has mismatched metadata for column names and types", partitionName, schemaName, tableName));
            }
            for (int fileIndex = 0; fileIndex < fileColumnNames.size(); ++fileIndex) {
                HiveType inputHiveType;
                String columnName = (String)fileColumnNames.get(fileIndex);
                HiveType fileColumnHiveType = fileColumnHiveTypes.get(fileIndex);
                if (fileColumnHiveType.equals(inputHiveType = ((DataColumn)inputColumnMap.get(columnName)).getHiveType())) continue;
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The column '%s' in table '%s.%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", columnName, schemaName, tableName, inputHiveType, partitionName, columnName, fileColumnHiveType));
            }
            this.fieldCount = fileColumnNames.size();
            if (serDe.equals(LazyBinaryColumnarSerDe.class.getName())) {
                serDe = OptimizedLazyBinaryColumnarSerde.class.getName();
            }
            this.serializer = HiveRecordWriter.initializeSerializer((Configuration)conf, schema, serDe);
            this.recordWriter = HiveWriteUtils.createRecordWriter(new Path(writePath, fileName), conf, compress, schema, outputFormat);
            List<Type> fileColumnTypes = fileColumnHiveTypes.stream().map(hiveType -> hiveType.getType(typeManager)).collect(Collectors.toList());
            this.tableInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)fileColumnNames, HiveWriteUtils.getRowColumnInspectors(fileColumnTypes));
            this.structFields = ImmutableList.copyOf((Collection)inputColumns.stream().map(DataColumn::getName).map(arg_0 -> ((SettableStructObjectInspector)this.tableInspector).getStructFieldRef(arg_0)).collect(Collectors.toList()));
            this.row = this.tableInspector.create();
            this.setters = new HiveWriteUtils.FieldSetter[this.structFields.size()];
            for (int i = 0; i < this.setters.length; ++i) {
                this.setters[i] = HiveWriteUtils.createFieldSetter(this.tableInspector, this.row, this.structFields.get(i), inputColumns.get(i).getType());
            }
        }

        public void addRow(Block[] columns, int position) {
            for (int field = 0; field < this.fieldCount; ++field) {
                if (columns[field].isNull(position)) {
                    this.tableInspector.setStructFieldData(this.row, this.structFields.get(field), null);
                    continue;
                }
                this.setters[field].setField(columns[field], position);
            }
            try {
                this.recordWriter.write(this.serializer.serialize(this.row, (ObjectInspector)this.tableInspector));
            }
            catch (IOException | SerDeException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, e);
            }
        }

        public void commit() {
            try {
                this.recordWriter.close(false);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
            }
        }

        public void rollback() {
            try {
                this.recordWriter.close(true);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
            }
        }

        public PartitionUpdate getPartitionUpdate() {
            return new PartitionUpdate(this.partitionName, this.isNew, this.writePath, this.targetPath, (List<String>)ImmutableList.of((Object)this.fileName));
        }

        private static Serializer initializeSerializer(Configuration conf, Properties properties, String serializerName) {
            try {
                Serializer result = (Serializer)Class.forName(serializerName).getConstructor(new Class[0]).newInstance(new Object[0]);
                result.initialize(conf, properties);
                return result;
            }
            catch (ReflectiveOperationException | SerDeException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitionName", (Object)this.partitionName).add("writePath", (Object)this.writePath).add("fileName", (Object)this.fileName).toString();
        }
    }
}

