/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class HiveTableProperties {
    public static final String STORAGE_FORMAT_PROPERTY = "format";
    public static final String PARTITIONED_BY_PROPERTY = "partitioned_by";
    public static final String CLUSTERED_BY_PROPERTY = "clustered_by";
    public static final String BUCKET_COUNT_PROPERTY = "bucket_count";
    private final List<PropertyMetadata<?>> tableProperties;

    @Inject
    public HiveTableProperties(TypeManager typeManager, HiveClientConfig config) {
        this.tableProperties = ImmutableList.of((Object)new PropertyMetadata(STORAGE_FORMAT_PROPERTY, "Hive storage format for the table", (Type)VarcharType.VARCHAR, HiveStorageFormat.class, (Object)config.getHiveStorageFormat(), false, value -> HiveStorageFormat.valueOf(((String)value).toUpperCase(Locale.ENGLISH))), (Object)new PropertyMetadata(PARTITIONED_BY_PROPERTY, "Partition columns", typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)VarcharType.VARCHAR.getTypeSignature()), (List)ImmutableList.of()), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)((List)value).stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList()))), (Object)new PropertyMetadata(CLUSTERED_BY_PROPERTY, "Bucketing columns", typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)VarcharType.VARCHAR.getTypeSignature()), (List)ImmutableList.of()), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)((List)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(Collectors.toList()))), (Object)PropertyMetadata.integerSessionProperty((String)BUCKET_COUNT_PROPERTY, (String)"Number of buckets", (Integer)0, (boolean)false));
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static HiveStorageFormat getHiveStorageFormat(Map<String, Object> tableProperties) {
        return (HiveStorageFormat)((Object)tableProperties.get(STORAGE_FORMAT_PROPERTY));
    }

    public static List<String> getPartitionedBy(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(PARTITIONED_BY_PROPERTY);
    }

    public static Optional<HiveBucketProperty> getBucketProperty(Map<String, Object> tableProperties) {
        List clusteredBy = (List)tableProperties.get(CLUSTERED_BY_PROPERTY);
        int bucketCount = (Integer)tableProperties.get(BUCKET_COUNT_PROPERTY);
        if (clusteredBy.isEmpty() && bucketCount == 0) {
            return Optional.empty();
        }
        if (bucketCount < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "bucket_count must be greater than zero");
        }
        if (clusteredBy.isEmpty() || bucketCount == 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "clustered_by and bucket_count must appear at the same time");
        }
        return Optional.of(new HiveBucketProperty(clusteredBy, bucketCount));
    }
}

