/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import java.util.Objects;

public class PartitionOfflineException
extends PrestoException {
    private final SchemaTableName tableName;
    private final String partition;

    public PartitionOfflineException(SchemaTableName tableName, String partition) {
        this(tableName, partition, String.format("Table '%s' partition '%s' is offline", tableName, partition));
    }

    public PartitionOfflineException(SchemaTableName tableName, String partition, String message) {
        super((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_OFFLINE, message);
        if (tableName == null) {
            throw new NullPointerException("tableName is null");
        }
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partition = Objects.requireNonNull(partition, "partition is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public String getPartition() {
        return this.partition;
    }
}

