/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.metastore.HivePrivilege;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.weakref.jmx.Managed;

public interface HiveMetastore {
    public static final String DEFAULT_DATABASE_NAME = "default";

    public void createTable(Table var1);

    public void dropTable(String var1, String var2);

    public void alterTable(String var1, String var2, Table var3);

    @Managed
    public void flushCache();

    public List<String> getAllDatabases();

    public Optional<List<String>> getAllTables(String var1);

    public Optional<List<String>> getAllViews(String var1);

    public Optional<Database> getDatabase(String var1);

    public void addPartitions(String var1, String var2, List<Partition> var3);

    public void dropPartition(String var1, String var2, List<String> var3);

    public void dropPartitionByName(String var1, String var2, String var3);

    public Optional<List<String>> getPartitionNames(String var1, String var2);

    public Optional<List<String>> getPartitionNamesByParts(String var1, String var2, List<String> var3);

    public Optional<Partition> getPartition(String var1, String var2, String var3);

    public Optional<Map<String, Partition>> getPartitionsByNames(String var1, String var2, List<String> var3);

    public Optional<Table> getTable(String var1, String var2);

    public Set<String> getRoles(String var1);

    public Set<HivePrivilege> getDatabasePrivileges(String var1, String var2);

    public Set<HivePrivilege> getTablePrivileges(String var1, String var2, String var3);

    public void grantTablePrivileges(String var1, String var2, String var3, Set<PrivilegeGrantInfo> var4);

    public boolean hasPrivilegeWithGrantOptionOnTable(String var1, String var2, String var3, HivePrivilege var4);

    default public boolean isDatabaseOwner(String user, String databaseName) {
        if (DEFAULT_DATABASE_NAME.equalsIgnoreCase(databaseName)) {
            return true;
        }
        Optional<Database> databaseMetadata = this.getDatabase(databaseName);
        if (!databaseMetadata.isPresent()) {
            return false;
        }
        Database database = databaseMetadata.get();
        if (database.getOwnerType() == PrincipalType.USER && user.equals(database.getOwnerName())) {
            return true;
        }
        return database.getOwnerType() == PrincipalType.ROLE && this.getRoles(user).contains(database.getOwnerName());
    }

    default public boolean isTableOwner(String user, String databaseName, String tableName) {
        Optional<Table> table = this.getTable(databaseName, tableName);
        return table.isPresent() && user.equals(table.get().getOwner());
    }
}

