/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.spi.security.Privilege;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;

public enum HivePrivilege {
    SELECT,
    INSERT,
    UPDATE,
    DELETE,
    OWNERSHIP,
    GRANT;


    public static Set<HivePrivilege> parsePrivilege(PrivilegeGrantInfo userGrant) {
        String name;
        switch (name = userGrant.getPrivilege().toUpperCase(Locale.ENGLISH)) {
            case "ALL": {
                return ImmutableSet.copyOf((Object[])HivePrivilege.values());
            }
            case "SELECT": {
                return ImmutableSet.of((Object)((Object)SELECT));
            }
            case "INSERT": {
                return ImmutableSet.of((Object)((Object)INSERT));
            }
            case "UPDATE": {
                return ImmutableSet.of((Object)((Object)UPDATE));
            }
            case "DELETE": {
                return ImmutableSet.of((Object)((Object)DELETE));
            }
            case "OWNERSHIP": {
                return ImmutableSet.of((Object)((Object)OWNERSHIP));
            }
        }
        return ImmutableSet.of();
    }

    public static HivePrivilege toHivePrivilege(Privilege privilege) {
        switch (privilege) {
            case SELECT: {
                return SELECT;
            }
            case INSERT: {
                return INSERT;
            }
            case DELETE: {
                return DELETE;
            }
        }
        return null;
    }
}

