/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.orc.AbstractOrcDataSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import io.airlift.units.DataSize;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;

public class HdfsOrcDataSource
extends AbstractOrcDataSource {
    private final FSDataInputStream inputStream;

    public HdfsOrcDataSource(String name, long size, DataSize maxMergeDistance, DataSize maxReadSize, DataSize streamBufferSize, FSDataInputStream inputStream) {
        super(name, size, maxMergeDistance, maxReadSize, streamBufferSize);
        this.inputStream = inputStream;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        try {
            this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (Exception e) {
            String message = String.format("HDFS error reading from %s at position %s", new Object[]{this, position});
            if (e.getClass().getSimpleName().equals("BlockMissingException")) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, message, (Throwable)e);
        }
    }
}

