/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcRecordReader;
import com.facebook.presto.orc.memory.AggregatedMemoryContext;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class OrcPageSource
implements ConnectorPageSource {
    private static final int NULL_ENTRY_SIZE = 0;
    private final OrcRecordReader recordReader;
    private final OrcDataSource orcDataSource;
    private final List<String> columnNames;
    private final List<Type> types;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private int batchId;
    private boolean closed;
    private final AggregatedMemoryContext systemMemoryContext;

    public OrcPageSource(OrcRecordReader recordReader, OrcDataSource orcDataSource, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, AggregatedMemoryContext systemMemoryContext) {
        this.recordReader = Objects.requireNonNull(recordReader, "recordReader is null");
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        ImmutableMap partitionKeysByName = Maps.uniqueIndex((Iterable)Objects.requireNonNull(partitionKeys, "partitionKeys is null"), HivePartitionKey::getName);
        int size = Objects.requireNonNull(columns, "columns is null").size();
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            String name = column.getName();
            Type type = typeManager.getType(column.getTypeSignature());
            namesBuilder.add((Object)name);
            typesBuilder.add((Object)type);
            this.hiveColumnIndexes[columnIndex] = column.getHiveColumnIndex();
            if (column.isPartitionKey()) {
                int i;
                int i2;
                HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(name);
                Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"No value provided for partition key %s", (Object[])new Object[]{name});
                byte[] bytes = partitionKey.getValue().getBytes(StandardCharsets.UTF_8);
                BlockBuilder blockBuilder = type instanceof FixedWidthType ? type.createBlockBuilder(new BlockBuilderStatus(), 1024) : type.createBlockBuilder(new BlockBuilderStatus(), 1024, bytes.length);
                if (HiveUtil.isHiveNull(bytes)) {
                    for (int i3 = 0; i3 < 1024; ++i3) {
                        blockBuilder.appendNull();
                    }
                } else if (type.equals(BooleanType.BOOLEAN)) {
                    boolean value = HiveUtil.booleanPartitionKey(partitionKey.getValue(), name);
                    for (i2 = 0; i2 < 1024; ++i2) {
                        BooleanType.BOOLEAN.writeBoolean(blockBuilder, value);
                    }
                } else if (type.equals(BigintType.BIGINT)) {
                    long value = HiveUtil.bigintPartitionKey(partitionKey.getValue(), name);
                    for (i = 0; i < 1024; ++i) {
                        BigintType.BIGINT.writeLong(blockBuilder, value);
                    }
                } else if (type.equals(DoubleType.DOUBLE)) {
                    double value = HiveUtil.doublePartitionKey(partitionKey.getValue(), name);
                    for (i = 0; i < 1024; ++i) {
                        DoubleType.DOUBLE.writeDouble(blockBuilder, value);
                    }
                } else if (type.equals(VarcharType.VARCHAR)) {
                    Slice value = Slices.wrappedBuffer((byte[])bytes);
                    for (i2 = 0; i2 < 1024; ++i2) {
                        VarcharType.VARCHAR.writeSlice(blockBuilder, value);
                    }
                } else if (type.equals(DateType.DATE)) {
                    long value = HiveUtil.datePartitionKey(partitionKey.getValue(), name);
                    for (i = 0; i < 1024; ++i) {
                        DateType.DATE.writeLong(blockBuilder, value);
                    }
                } else if (type.equals(TimestampType.TIMESTAMP)) {
                    long value = HiveUtil.timestampPartitionKey(partitionKey.getValue(), hiveStorageTimeZone, name);
                    for (i = 0; i < 1024; ++i) {
                        TimestampType.TIMESTAMP.writeLong(blockBuilder, value);
                    }
                } else {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for partition key: %s", type.getDisplayName(), name));
                }
                this.constantBlocks[columnIndex] = blockBuilder.build();
                continue;
            }
            if (recordReader.isColumnPresent(column.getHiveColumnIndex())) continue;
            BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), 1024, 0);
            for (int i = 0; i < 1024; ++i) {
                blockBuilder.appendNull();
            }
            this.constantBlocks[columnIndex] = blockBuilder.build();
        }
        this.types = typesBuilder.build();
        this.columnNames = namesBuilder.build();
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    public long getTotalBytes() {
        return this.recordReader.getSplitLength();
    }

    public long getCompletedBytes() {
        return this.orcDataSource.getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            ++this.batchId;
            int batchSize = this.recordReader.nextBatch();
            if (batchSize <= 0) {
                this.close();
                return null;
            }
            Block[] blocks = new Block[this.hiveColumnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                Type type = this.types.get(fieldId);
                blocks[fieldId] = this.constantBlocks[fieldId] != null ? this.constantBlocks[fieldId].getRegion(0, batchSize) : new LazyBlock(batchSize, (LazyBlockLoader)new OrcBlockLoader(this.hiveColumnIndexes[fieldId], type));
            }
            return new Page(batchSize, blocks);
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnNames", this.columnNames).add("types", this.types).toString();
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryContext.getBytes();
    }

    protected void closeWithSuppression(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        try {
            this.close();
        }
        catch (RuntimeException e) {
            throwable.addSuppressed(e);
        }
    }

    private final class OrcBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final int columnIndex;
        private final Type type;
        private boolean loaded;

        public OrcBlockLoader(int columnIndex, Type type) {
            this.expectedBatchId = OrcPageSource.this.batchId;
            this.columnIndex = columnIndex;
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState((OrcPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                Block block = OrcPageSource.this.recordReader.readBlock(this.type, this.columnIndex);
                lazyBlock.setBlock(block);
            }
            catch (IOException e) {
                if (e instanceof OrcCorruptionException) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
                }
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

