/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.parquet.ParquetTypeUtils;
import com.facebook.presto.hive.parquet.reader.ParquetReader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;
import parquet.column.ColumnDescriptor;
import parquet.schema.MessageType;

class ParquetPageSource
implements ConnectorPageSource {
    private static final int MAX_VECTOR_LENGTH = 1024;
    private static final long GUESSED_MEMORY_USAGE = new DataSize(16.0, DataSize.Unit.MEGABYTE).toBytes();
    private final ParquetReader parquetReader;
    private final MessageType requestedSchema;
    private final List<String> columnNames;
    private final List<Type> types;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private final long totalBytes;
    private long completedBytes;
    private int batchId;
    private boolean closed;
    private long readTimeNanos;

    public ParquetPageSource(ParquetReader parquetReader, MessageType fileSchema, MessageType requestedSchema, Path path, long totalBytes, Properties splitSchema, List<HiveColumnHandle> columns, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, boolean useParquetColumnNames) {
        Objects.requireNonNull(path, "path is null");
        Preconditions.checkArgument((totalBytes >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Objects.requireNonNull(splitSchema, "splitSchema is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.parquetReader = parquetReader;
        this.requestedSchema = requestedSchema;
        this.totalBytes = totalBytes;
        ImmutableMap partitionKeysByName = Maps.uniqueIndex((Iterable)Objects.requireNonNull(partitionKeys, "partitionKeys is null"), HivePartitionKey::getName);
        int size = Objects.requireNonNull(columns, "columns is null").size();
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            String name = column.getName();
            Type type = typeManager.getType(column.getTypeSignature());
            namesBuilder.add((Object)name);
            typesBuilder.add((Object)type);
            this.hiveColumnIndexes[columnIndex] = column.getHiveColumnIndex();
            if (column.isPartitionKey()) {
                int i;
                int i2;
                HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(name);
                Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"No value provided for partition key %s", (Object[])new Object[]{name});
                byte[] bytes = partitionKey.getValue().getBytes(StandardCharsets.UTF_8);
                BlockBuilder blockBuilder = type instanceof FixedWidthType ? type.createBlockBuilder(new BlockBuilderStatus(), 1024) : type.createBlockBuilder(new BlockBuilderStatus(), 1024, bytes.length);
                if (HiveUtil.isHiveNull(bytes)) {
                    for (int i3 = 0; i3 < 1024; ++i3) {
                        blockBuilder.appendNull();
                    }
                } else if (type.equals(BooleanType.BOOLEAN)) {
                    boolean value = HiveUtil.booleanPartitionKey(partitionKey.getValue(), name);
                    for (i2 = 0; i2 < 1024; ++i2) {
                        BooleanType.BOOLEAN.writeBoolean(blockBuilder, value);
                    }
                } else if (type.equals(BigintType.BIGINT)) {
                    long value = HiveUtil.bigintPartitionKey(partitionKey.getValue(), name);
                    for (i = 0; i < 1024; ++i) {
                        BigintType.BIGINT.writeLong(blockBuilder, value);
                    }
                } else if (type.equals(DoubleType.DOUBLE)) {
                    double value = HiveUtil.doublePartitionKey(partitionKey.getValue(), name);
                    for (i = 0; i < 1024; ++i) {
                        DoubleType.DOUBLE.writeDouble(blockBuilder, value);
                    }
                } else if (type.equals(VarcharType.VARCHAR)) {
                    Slice value = Slices.wrappedBuffer((byte[])bytes);
                    for (i2 = 0; i2 < 1024; ++i2) {
                        VarcharType.VARCHAR.writeSlice(blockBuilder, value);
                    }
                } else if (type.equals(TimestampType.TIMESTAMP)) {
                    long value = HiveUtil.timestampPartitionKey(partitionKey.getValue(), hiveStorageTimeZone, name);
                    for (i = 0; i < 1024; ++i) {
                        TimestampType.TIMESTAMP.writeLong(blockBuilder, value);
                    }
                } else if (type.equals(DateType.DATE)) {
                    long value = HiveUtil.datePartitionKey(partitionKey.getValue(), name);
                    for (i = 0; i < 1024; ++i) {
                        DateType.DATE.writeLong(blockBuilder, value);
                    }
                } else {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for partition key: %s", type.getDisplayName(), name));
                }
                this.constantBlocks[columnIndex] = blockBuilder.build();
                continue;
            }
            if (ParquetTypeUtils.getParquetType(column, fileSchema, useParquetColumnNames) != null) continue;
            BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), 1024);
            for (int i = 0; i < 1024; ++i) {
                blockBuilder.appendNull();
            }
            this.constantBlocks[columnIndex] = blockBuilder.build();
        }
        this.types = typesBuilder.build();
        this.columnNames = namesBuilder.build();
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.closed;
    }

    public long getSystemMemoryUsage() {
        return GUESSED_MEMORY_USAGE;
    }

    public Page getNextPage() {
        try {
            ++this.batchId;
            long start = System.nanoTime();
            int batchSize = this.parquetReader.nextBatch();
            this.readTimeNanos += System.nanoTime() - start;
            if (this.closed || batchSize <= 0) {
                this.close();
                return null;
            }
            Block[] blocks = new Block[this.hiveColumnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                Type type = this.types.get(fieldId);
                if (this.constantBlocks[fieldId] != null) {
                    blocks[fieldId] = this.constantBlocks[fieldId].getRegion(0, batchSize);
                    continue;
                }
                int fieldIndex = this.requestedSchema.getFieldIndex(this.columnNames.get(fieldId));
                ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.requestedSchema.getColumns().get(fieldIndex);
                blocks[fieldId] = new LazyBlock(batchSize, (LazyBlockLoader)new ParquetBlockLoader(columnDescriptor, type));
            }
            Page page = new Page(batchSize, blocks);
            long newCompletedBytes = (long)((float)this.totalBytes * this.parquetReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
            return page;
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (e == throwable) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.parquetReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private final class ParquetBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final ColumnDescriptor columnDescriptor;
        private final Type type;
        private boolean loaded;

        public ParquetBlockLoader(ColumnDescriptor columnDescriptor, Type type) {
            this.expectedBatchId = ParquetPageSource.this.batchId;
            this.columnDescriptor = columnDescriptor;
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState((ParquetPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                Block block = ParquetPageSource.this.parquetReader.readBlock(this.columnDescriptor, this.type);
                lazyBlock.setBlock(block);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

