/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.parquet.HdfsParquetDataSource;
import com.facebook.presto.hive.parquet.ParquetPageSource;
import com.facebook.presto.hive.parquet.ParquetTypeUtils;
import com.facebook.presto.hive.parquet.predicate.ParquetPredicate;
import com.facebook.presto.hive.parquet.predicate.ParquetPredicateUtils;
import com.facebook.presto.hive.parquet.reader.ParquetMetadataReader;
import com.facebook.presto.hive.parquet.reader.ParquetReader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.schema.MessageType;

public class ParquetPageSourceFactory
implements HivePageSourceFactory {
    private static final Set<String> PARQUET_SERDE_CLASS_NAMES = ImmutableSet.builder().add((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe").add((Object)"parquet.hive.serde.ParquetHiveSerDe").build();
    private final TypeManager typeManager;
    private final boolean useParquetColumnNames;

    @Inject
    public ParquetPageSourceFactory(TypeManager typeManager, HiveClientConfig config) {
        this(typeManager, Objects.requireNonNull(config, "hiveClientConfig is null").isUseParquetColumnNames());
    }

    public ParquetPageSourceFactory(TypeManager typeManager, boolean useParquetColumnNames) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.useParquetColumnNames = useParquetColumnNames;
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone) {
        if (!HiveSessionProperties.isParquetOptimizedReaderEnabled(session)) {
            return Optional.empty();
        }
        if (!PARQUET_SERDE_CLASS_NAMES.contains(HiveUtil.getDeserializerClassName(schema))) {
            return Optional.empty();
        }
        if (!ParquetPageSourceFactory.columnTypeSupported(columns)) {
            return Optional.empty();
        }
        return Optional.of(ParquetPageSourceFactory.createParquetPageSource(configuration, path, start, length, schema, columns, partitionKeys, this.useParquetColumnNames, hiveStorageTimeZone, this.typeManager, HiveSessionProperties.isParquetPredicatePushdownEnabled(session), effectivePredicate));
    }

    public static ParquetPageSource createParquetPageSource(Configuration configuration, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns, List<HivePartitionKey> partitionKeys, boolean useParquetColumnNames, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, boolean predicatePushdownEnabled, TupleDomain<HiveColumnHandle> effectivePredicate) {
        HdfsParquetDataSource dataSource = HdfsParquetDataSource.buildHdfsParquetDataSource(path, configuration, start, length);
        try {
            ParquetMetadata parquetMetadata = ParquetMetadataReader.readFooter(configuration, path);
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            List fields = columns.stream().filter(column -> !column.isPartitionKey()).map(column -> ParquetTypeUtils.getParquetType(column, fileSchema, useParquetColumnNames)).filter(Objects::nonNull).collect(Collectors.toList());
            MessageType requestedSchema = new MessageType(fileSchema.getName(), fields);
            List<Object> blocks = new ArrayList<BlockMetaData>();
            for (BlockMetaData block2 : parquetMetadata.getBlocks()) {
                long firstDataPage = ((ColumnChunkMetaData)block2.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < start || firstDataPage >= start + length) continue;
                blocks.add(block2);
            }
            if (predicatePushdownEnabled) {
                ParquetPredicate parquetPredicate = ParquetPredicateUtils.buildParquetPredicate(columns, effectivePredicate, fileMetaData.getSchema(), typeManager);
                blocks = blocks.stream().filter(block -> ParquetPredicateUtils.predicateMatches(parquetPredicate, block, configuration, dataSource, requestedSchema, effectivePredicate)).collect(Collectors.toList());
            }
            ParquetReader parquetReader = new ParquetReader(fileMetaData.getSchema(), fileMetaData.getKeyValueMetaData(), requestedSchema, blocks, configuration, dataSource);
            return new ParquetPageSource(parquetReader, fileSchema, requestedSchema, path, length, schema, columns, partitionKeys, effectivePredicate, hiveStorageTimeZone, typeManager, useParquetColumnNames);
        }
        catch (Exception e) {
            try {
                dataSource.close();
            }
            catch (IOException fileMetaData) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)((Object)e);
            }
            String message = String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e.getClass().getSimpleName().equals("BlockMissingException")) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static boolean columnTypeSupported(List<HiveColumnHandle> columns) {
        return columns.stream().map(HiveColumnHandle::getTypeSignature).map(TypeSignature::getBase).allMatch(base -> "bigint".equals(base) || "boolean".equals(base) || "double".equals(base) || "timestamp".equals(base) || "varchar".equals(base) || "varbinary".equals(base) || "date".equals(base));
    }
}

