/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.predicate;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.parquet.ParquetCodecFactory;
import com.facebook.presto.hive.parquet.ParquetDataSource;
import com.facebook.presto.hive.parquet.predicate.ParquetDictionaryDescriptor;
import com.facebook.presto.hive.parquet.predicate.ParquetPredicate;
import com.facebook.presto.hive.parquet.predicate.TupleDomainParquetPredicate;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import parquet.bytes.BytesInput;
import parquet.column.ColumnDescriptor;
import parquet.column.Encoding;
import parquet.column.page.DictionaryPage;
import parquet.column.statistics.Statistics;
import parquet.format.DictionaryPageHeader;
import parquet.format.PageHeader;
import parquet.format.PageType;
import parquet.format.Util;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ColumnPath;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.schema.MessageType;

public final class ParquetPredicateUtils {
    private static final int PARQUET_DATA_TRIPLE = 3;

    private ParquetPredicateUtils() {
    }

    public static ParquetPredicate buildParquetPredicate(List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, MessageType fileSchema, TypeManager typeManager) {
        ImmutableList.Builder columnReferences = ImmutableList.builder();
        for (HiveColumnHandle column : columns) {
            if (column.isPartitionKey()) continue;
            int parquetFieldIndex = ParquetPredicateUtils.lookupParquetColumn(column, fileSchema);
            Type type = typeManager.getType(column.getTypeSignature());
            columnReferences.add(new TupleDomainParquetPredicate.ColumnReference<HiveColumnHandle>(column, parquetFieldIndex, type));
        }
        return new TupleDomainParquetPredicate<HiveColumnHandle>(effectivePredicate, (List<TupleDomainParquetPredicate.ColumnReference<HiveColumnHandle>>)columnReferences.build());
    }

    private static int lookupParquetColumn(HiveColumnHandle column, MessageType fileSchema) {
        int parquetFieldIndex;
        for (parquetFieldIndex = 0; parquetFieldIndex < fileSchema.getColumns().size(); ++parquetFieldIndex) {
            String[] path = ((ColumnDescriptor)fileSchema.getColumns().get(parquetFieldIndex)).getPath();
            String columnName = path[path.length - 1];
            if (column.getName().equals(columnName)) break;
        }
        return parquetFieldIndex;
    }

    public static boolean predicateMatches(ParquetPredicate parquetPredicate, BlockMetaData block, Configuration configuration, ParquetDataSource dataSource, MessageType requestedSchema, TupleDomain<HiveColumnHandle> effectivePredicate) {
        Map<Integer, Statistics<?>> columnStatistics = ParquetPredicateUtils.getStatisticsByColumnOrdinal(block);
        if (!parquetPredicate.matches(block.getRowCount(), columnStatistics)) {
            return false;
        }
        Map<Integer, ParquetDictionaryDescriptor> dictionaries = ParquetPredicateUtils.getDictionariesByColumnOrdinal(block, configuration, dataSource, requestedSchema, effectivePredicate);
        return parquetPredicate.matches(dictionaries);
    }

    private static Map<Integer, Statistics<?>> getStatisticsByColumnOrdinal(BlockMetaData blockMetadata) {
        ImmutableMap.Builder statistics = ImmutableMap.builder();
        for (int ordinal = 0; ordinal < blockMetadata.getColumns().size(); ++ordinal) {
            Statistics columnStatistics = ((ColumnChunkMetaData)blockMetadata.getColumns().get(ordinal)).getStatistics();
            if (columnStatistics == null) continue;
            statistics.put((Object)ordinal, (Object)columnStatistics);
        }
        return statistics.build();
    }

    private static Map<Integer, ParquetDictionaryDescriptor> getDictionariesByColumnOrdinal(BlockMetaData blockMetadata, Configuration configuration, ParquetDataSource dataSource, MessageType requestedSchema, TupleDomain<HiveColumnHandle> effectivePredicate) {
        ParquetCodecFactory codecFactory = new ParquetCodecFactory(configuration);
        ImmutableMap.Builder dictionaries = ImmutableMap.builder();
        block2: for (int ordinal = 0; ordinal < blockMetadata.getColumns().size(); ++ordinal) {
            ColumnChunkMetaData columnChunkMetaData = (ColumnChunkMetaData)blockMetadata.getColumns().get(ordinal);
            for (int i = 0; i < requestedSchema.getColumns().size(); ++i) {
                ColumnDescriptor columnDescriptor = (ColumnDescriptor)requestedSchema.getColumns().get(i);
                if (!ParquetPredicateUtils.isColumnPredicate(columnDescriptor, effectivePredicate) || !columnChunkMetaData.getPath().equals((Object)ColumnPath.get((String[])columnDescriptor.getPath())) || !ParquetPredicateUtils.isOnlyDictionaryEncodingPages(columnChunkMetaData.getEncodings())) continue;
                try {
                    int totalSize = Ints.checkedCast((long)columnChunkMetaData.getTotalSize());
                    byte[] buffer = new byte[totalSize];
                    dataSource.readFully(columnChunkMetaData.getStartingPos(), buffer);
                    DictionaryPage dictionaryPage = ParquetPredicateUtils.readDictionaryPage(buffer, codecFactory, columnChunkMetaData.getCodec());
                    dictionaries.put((Object)ordinal, (Object)new ParquetDictionaryDescriptor(columnDescriptor, dictionaryPage));
                }
                catch (IOException iOException) {}
                continue block2;
            }
        }
        return dictionaries.build();
    }

    private static DictionaryPage readDictionaryPage(byte[] data, ParquetCodecFactory codecFactory, CompressionCodecName codecName) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            PageHeader pageHeader = Util.readPageHeader((InputStream)inputStream);
            if (pageHeader.type != PageType.DICTIONARY_PAGE) {
                return null;
            }
            BytesInput compressedData = BytesInput.from((byte[])data, (int)(data.length - inputStream.available()), (int)pageHeader.getCompressed_page_size());
            ParquetCodecFactory.BytesDecompressor decompressor = codecFactory.getDecompressor(codecName);
            BytesInput decompressed = decompressor.decompress(compressedData, pageHeader.getUncompressed_page_size());
            DictionaryPageHeader dicHeader = pageHeader.getDictionary_page_header();
            Encoding encoding = Encoding.valueOf((String)dicHeader.getEncoding().name());
            int dictionarySize = dicHeader.getNum_values();
            return new DictionaryPage(decompressed, dictionarySize, encoding);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    private static boolean isColumnPredicate(ColumnDescriptor columnDescriptor, TupleDomain<HiveColumnHandle> effectivePredicate) {
        String[] columnPath = columnDescriptor.getPath();
        String columnName = columnPath[columnPath.length - 1];
        return ((Map)effectivePredicate.getDomains().get()).keySet().stream().map(HiveColumnHandle::getName).anyMatch(columnName::equals);
    }

    private static boolean isOnlyDictionaryEncodingPages(Set<Encoding> encodings) {
        if (encodings.size() > 3) {
            return false;
        }
        return encodings.stream().anyMatch(Encoding::usesDictionary);
    }
}

