/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.reader.ParquetColumnReader;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slices;
import parquet.column.ColumnDescriptor;
import parquet.io.api.Binary;

public class ParquetBinaryColumnReader
extends ParquetColumnReader {
    public ParquetBinaryColumnReader(ColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    public BlockBuilder createBlockBuilder() {
        return VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus(), this.nextBatchSize);
    }

    @Override
    public void readValues(BlockBuilder blockBuilder, int valueNumber) {
        for (int i = 0; i < valueNumber; ++i) {
            if (this.definitionReader.readLevel() == this.columnDescriptor.getMaxDefinitionLevel()) {
                Binary binary = this.valuesReader.readBytes();
                if (binary.length() == 0) {
                    VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.EMPTY_SLICE);
                    continue;
                }
                VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])binary.getBytes()));
                continue;
            }
            blockBuilder.appendNull();
        }
    }

    @Override
    public void skipValues(int offsetNumber) {
        for (int i = 0; i < offsetNumber; ++i) {
            if (this.definitionReader.readLevel() != this.columnDescriptor.getMaxDefinitionLevel()) continue;
            this.valuesReader.readBytes();
        }
    }
}

