/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.reader.ParquetColumnReader;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BooleanType;
import parquet.column.ColumnDescriptor;

public class ParquetBooleanColumnReader
extends ParquetColumnReader {
    public ParquetBooleanColumnReader(ColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    public BlockBuilder createBlockBuilder() {
        return BooleanType.BOOLEAN.createBlockBuilder(new BlockBuilderStatus(), this.nextBatchSize);
    }

    @Override
    public void readValues(BlockBuilder blockBuilder, int valueNumber) {
        for (int i = 0; i < valueNumber; ++i) {
            if (this.definitionReader.readLevel() == this.columnDescriptor.getMaxDefinitionLevel()) {
                BooleanType.BOOLEAN.writeBoolean(blockBuilder, this.valuesReader.readBoolean());
                continue;
            }
            blockBuilder.appendNull();
        }
    }

    @Override
    public void skipValues(int offsetNumber) {
        for (int i = 0; i < offsetNumber; ++i) {
            if (this.definitionReader.readLevel() != this.columnDescriptor.getMaxDefinitionLevel()) continue;
            this.valuesReader.readBoolean();
        }
    }
}

