/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.ParquetCodecFactory;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import parquet.bytes.BytesInput;
import parquet.column.Encoding;
import parquet.column.page.DataPage;
import parquet.column.page.DataPageV1;
import parquet.column.page.DataPageV2;
import parquet.column.page.DictionaryPage;
import parquet.column.page.PageReader;
import parquet.column.statistics.Statistics;

class ParquetColumnChunkPageReader
implements PageReader {
    private final ParquetCodecFactory.BytesDecompressor decompressor;
    private final long valueCount;
    private final List<DataPage> compressedPages;
    private final DictionaryPage compressedDictionaryPage;

    public ParquetColumnChunkPageReader(ParquetCodecFactory.BytesDecompressor decompressor, List<DataPage> compressedPages, DictionaryPage compressedDictionaryPage) {
        this.decompressor = decompressor;
        this.compressedPages = new LinkedList<DataPage>(compressedPages);
        this.compressedDictionaryPage = compressedDictionaryPage;
        int count = 0;
        for (DataPage page : compressedPages) {
            count += page.getValueCount();
        }
        this.valueCount = count;
    }

    public long getTotalValueCount() {
        return this.valueCount;
    }

    public DataPage readPage() {
        if (this.compressedPages.isEmpty()) {
            return null;
        }
        DataPage compressedPage = this.compressedPages.remove(0);
        try {
            if (compressedPage instanceof DataPageV1) {
                DataPageV1 dataPageV1 = (DataPageV1)compressedPage;
                return new DataPageV1(this.decompressor.decompress(dataPageV1.getBytes(), dataPageV1.getUncompressedSize()), dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), dataPageV1.getStatistics(), dataPageV1.getRlEncoding(), dataPageV1.getDlEncoding(), dataPageV1.getValueEncoding());
            }
            DataPageV2 dataPageV2 = (DataPageV2)compressedPage;
            if (!dataPageV2.isCompressed()) {
                return dataPageV2;
            }
            int uncompressedSize = Ints.checkedCast((long)((long)dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().size() - dataPageV2.getRepetitionLevels().size()));
            return DataPageV2.uncompressed((int)dataPageV2.getRowCount(), (int)dataPageV2.getNullCount(), (int)dataPageV2.getValueCount(), (BytesInput)dataPageV2.getRepetitionLevels(), (BytesInput)dataPageV2.getDefinitionLevels(), (Encoding)dataPageV2.getDataEncoding(), (BytesInput)this.decompressor.decompress(dataPageV2.getData(), uncompressedSize), (Statistics)dataPageV2.getStatistics());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not decompress page", e);
        }
    }

    public DictionaryPage readDictionaryPage() {
        if (this.compressedDictionaryPage == null) {
            return null;
        }
        try {
            return new DictionaryPage(this.decompressor.decompress(this.compressedDictionaryPage.getBytes(), this.compressedDictionaryPage.getUncompressedSize()), this.compressedDictionaryPage.getDictionarySize(), this.compressedDictionaryPage.getEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading dictionary page", e);
        }
    }
}

