/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.ParquetCodecFactory;
import com.facebook.presto.hive.parquet.ParquetCorruptionException;
import com.facebook.presto.hive.parquet.ParquetDataSource;
import com.facebook.presto.hive.parquet.ParquetValidationUtils;
import com.facebook.presto.hive.parquet.reader.ParquetColumnChunk;
import com.facebook.presto.hive.parquet.reader.ParquetColumnChunkDescriptor;
import com.facebook.presto.hive.parquet.reader.ParquetColumnReader;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import parquet.column.ColumnDescriptor;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ColumnPath;
import parquet.schema.MessageType;

public class ParquetReader
implements Closeable {
    public static final int MAX_VECTOR_LENGTH = 1024;
    private final MessageType fileSchema;
    private final Map<String, String> extraMetadata;
    private final MessageType requestedSchema;
    private final List<BlockMetaData> blocks;
    private final ParquetDataSource dataSource;
    private final ParquetCodecFactory codecFactory;
    private int currentBlock;
    private BlockMetaData currentBlockMetadata;
    private long fileRowCount;
    private long currentPosition;
    private long currentGroupRowCount;
    private long nextRowInGroup;
    private Map<ColumnDescriptor, ParquetColumnReader> columnReadersMap = new HashMap<ColumnDescriptor, ParquetColumnReader>();

    public ParquetReader(MessageType fileSchema, Map<String, String> extraMetadata, MessageType requestedSchema, List<BlockMetaData> blocks, Configuration configuration, ParquetDataSource dataSource) throws IOException {
        this.fileSchema = fileSchema;
        this.extraMetadata = extraMetadata;
        this.requestedSchema = requestedSchema;
        this.blocks = blocks;
        this.dataSource = dataSource;
        this.codecFactory = new ParquetCodecFactory(configuration);
        for (BlockMetaData block : blocks) {
            this.fileRowCount += block.getRowCount();
        }
        this.initializeColumnReaders();
    }

    @Override
    public void close() throws IOException {
        try {
            this.dataSource.close();
        }
        finally {
            this.codecFactory.release();
        }
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.fileRowCount == 0L) {
            return 0.0f;
        }
        return (float)this.currentPosition / (float)this.fileRowCount;
    }

    public long getPosition() {
        return this.currentPosition;
    }

    public long getFileRowCount() {
        return this.fileRowCount;
    }

    public int nextBatch() throws IOException, InterruptedException {
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            return -1;
        }
        int batchSize = Ints.checkedCast((long)Math.min(1024L, this.currentGroupRowCount - this.nextRowInGroup));
        this.nextRowInGroup += (long)batchSize;
        this.currentPosition += (long)batchSize;
        for (ColumnDescriptor column : this.requestedSchema.getColumns()) {
            ParquetColumnReader columnReader = this.columnReadersMap.get(column);
            columnReader.prepareNextRead(batchSize);
        }
        return batchSize;
    }

    private boolean advanceToNextRowGroup() throws InterruptedException {
        if (this.currentBlock == this.blocks.size()) {
            return false;
        }
        this.currentBlockMetadata = this.blocks.get(this.currentBlock);
        ++this.currentBlock;
        long rowCount = this.currentBlockMetadata.getRowCount();
        this.nextRowInGroup = 0L;
        this.currentGroupRowCount = rowCount;
        this.columnReadersMap.clear();
        this.initializeColumnReaders();
        return true;
    }

    public Block readBlock(ColumnDescriptor columnDescriptor, Type type) throws IOException {
        ParquetColumnReader columnReader = this.columnReadersMap.get(columnDescriptor);
        if (columnReader.getPageReader() == null) {
            ParquetValidationUtils.validateParquet(this.currentBlockMetadata.getRowCount() > 0L, "Row group having 0 rows", new Object[0]);
            ColumnChunkMetaData metadata = this.getColumnChunkMetaData(columnDescriptor);
            long startingPosition = metadata.getStartingPos();
            int totalSize = Ints.checkedCast((long)metadata.getTotalSize());
            byte[] buffer = new byte[totalSize];
            this.dataSource.readFully(startingPosition, buffer);
            ParquetColumnChunkDescriptor descriptor = new ParquetColumnChunkDescriptor(columnDescriptor, metadata, startingPosition, totalSize);
            ParquetColumnChunk columnChunk = new ParquetColumnChunk(descriptor, buffer, 0, this.codecFactory);
            columnReader.setPageReader(columnChunk.readAllPages());
        }
        return columnReader.readBlock(type);
    }

    private ColumnChunkMetaData getColumnChunkMetaData(ColumnDescriptor columnDescriptor) throws IOException {
        for (ColumnChunkMetaData metadata : this.currentBlockMetadata.getColumns()) {
            if (!metadata.getPath().equals((Object)ColumnPath.get((String[])columnDescriptor.getPath()))) continue;
            return metadata;
        }
        throw new ParquetCorruptionException("Malformed Parquet file. Could not find column metadata %s", columnDescriptor);
    }

    private void initializeColumnReaders() {
        for (ColumnDescriptor column : this.requestedSchema.getColumns()) {
            this.columnReadersMap.put(column, ParquetColumnReader.createReader(column));
        }
    }
}

