/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.util.ResumableTask;
import io.airlift.log.Logger;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class ResumableTasks {
    private static final Logger log = Logger.get(ResumableTasks.class);

    private ResumableTasks() {
    }

    public static void submit(Executor executor, ResumableTask task) {
        AtomicReference<Runnable> runnableReference = new AtomicReference<Runnable>();
        Runnable runnable = () -> {
            ResumableTask.TaskStatus status = ResumableTasks.safeProcessTask(task);
            if (!status.isFinished()) {
                status.getContinuationFuture().thenRun(() -> executor.execute((Runnable)runnableReference.get()));
            }
        };
        runnableReference.set(runnable);
        executor.execute(runnable);
    }

    private static ResumableTask.TaskStatus safeProcessTask(ResumableTask task) {
        try {
            return task.process();
        }
        catch (Throwable t) {
            log.warn(t, "ResumableTask completed exceptionally");
            return ResumableTask.TaskStatus.finished();
        }
    }
}

