/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.util.buffer;

public class FastBooleanBuffer {
    private boolean[][] buffers = new boolean[16][];
    private int buffersCount;
    private int currentBufferIndex = -1;
    private boolean[] currentBuffer;
    private int offset;
    private int size;
    private final int minChunkLen;

    public FastBooleanBuffer() {
        this.minChunkLen = 1024;
    }

    public FastBooleanBuffer(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        this.minChunkLen = size;
    }

    private void needNewBuffer(int newSize) {
        int delta = newSize - this.size;
        int newBufferSize = Math.max(this.minChunkLen, delta);
        ++this.currentBufferIndex;
        this.currentBuffer = new boolean[newBufferSize];
        this.offset = 0;
        if (this.currentBufferIndex >= this.buffers.length) {
            int newLen = this.buffers.length << 1;
            boolean[][] newBuffers = new boolean[newLen][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            this.buffers = newBuffers;
        }
        this.buffers[this.currentBufferIndex] = this.currentBuffer;
        ++this.buffersCount;
    }

    public FastBooleanBuffer append(boolean[] array, int off, int len) {
        int part;
        int end = off + len;
        if (off < 0 || len < 0 || end > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return this;
        }
        int newSize = this.size + len;
        int remaining = len;
        if (this.currentBuffer != null) {
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            remaining -= part;
            this.offset += part;
            this.size += part;
        }
        if (remaining > 0) {
            this.needNewBuffer(newSize);
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            this.offset += part;
            this.size += part;
        }
        return this;
    }

    public FastBooleanBuffer append(boolean[] array) {
        return this.append(array, 0, array.length);
    }

    public FastBooleanBuffer append(boolean element) {
        if (this.currentBuffer == null || this.offset == this.currentBuffer.length) {
            this.needNewBuffer(this.size + 1);
        }
        this.currentBuffer[this.offset] = element;
        ++this.offset;
        ++this.size;
        return this;
    }

    public FastBooleanBuffer append(FastBooleanBuffer buff) {
        if (buff.size == 0) {
            return this;
        }
        for (int i = 0; i < buff.currentBufferIndex; ++i) {
            this.append(buff.buffers[i]);
        }
        this.append(buff.currentBuffer, 0, buff.offset);
        return this;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int index() {
        return this.currentBufferIndex;
    }

    public int offset() {
        return this.offset;
    }

    public boolean[] array(int index) {
        return this.buffers[index];
    }

    public void clear() {
        this.size = 0;
        this.offset = 0;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
        this.buffersCount = 0;
    }

    public boolean[] toArray() {
        int pos = 0;
        boolean[] array = new boolean[this.size];
        if (this.currentBufferIndex == -1) {
            return array;
        }
        for (int i = 0; i < this.currentBufferIndex; ++i) {
            int len = this.buffers[i].length;
            System.arraycopy(this.buffers[i], 0, array, pos, len);
            pos += len;
        }
        System.arraycopy(this.buffers[this.currentBufferIndex], 0, array, pos, this.offset);
        return array;
    }

    public boolean[] toArray(int start, int len) {
        int remaining = len;
        int pos = 0;
        boolean[] array = new boolean[len];
        if (len == 0) {
            return array;
        }
        int i = 0;
        while (start >= this.buffers[i].length) {
            start -= this.buffers[i].length;
            ++i;
        }
        while (i < this.buffersCount) {
            boolean[] buf = this.buffers[i];
            int c = Math.min(buf.length - start, remaining);
            System.arraycopy(buf, start, array, pos, c);
            pos += c;
            if ((remaining -= c) == 0) break;
            start = 0;
            ++i;
        }
        return array;
    }

    public boolean get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ndx = 0;
        boolean[] b;
        while (index >= (b = this.buffers[ndx]).length) {
            ++ndx;
            index -= b.length;
        }
        return b[index];
    }
}

