/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.util.collection;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeEnumeration<T>
implements Enumeration<T> {
    protected final List<Enumeration<T>> allEnumerations = new ArrayList<Enumeration<T>>();
    protected int currentEnumeration = -1;

    public CompositeEnumeration() {
    }

    public CompositeEnumeration(Enumeration<T> ... enumerations) {
        for (Enumeration<T> enumeration : enumerations) {
            this.add(enumeration);
        }
    }

    public void add(Enumeration<T> enumeration) {
        if (this.allEnumerations.contains(enumeration)) {
            throw new IllegalArgumentException("Duplicate enumeration");
        }
        this.allEnumerations.add(enumeration);
    }

    @Override
    public boolean hasMoreElements() {
        if (this.currentEnumeration == -1) {
            this.currentEnumeration = 0;
        }
        for (int i = this.currentEnumeration; i < this.allEnumerations.size(); ++i) {
            Enumeration<T> enumeration = this.allEnumerations.get(i);
            if (!enumeration.hasMoreElements()) continue;
            this.currentEnumeration = i;
            return true;
        }
        return false;
    }

    @Override
    public T nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        return this.allEnumerations.get(this.currentEnumeration).nextElement();
    }
}

