/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;

public class HiveIndex {
    public static final Log l4j = LogFactory.getLog("HiveIndex");
    public static String INDEX_TABLE_CREATETIME = "hive.index.basetbl.dfs.lastModifiedTime";

    public static IndexType getIndexType(String name) {
        IndexType[] types;
        for (IndexType type : types = IndexType.values()) {
            if (!type.getName().equals(name.toLowerCase())) continue;
            return type;
        }
        return null;
    }

    public static IndexType getIndexTypeByClassName(String className) {
        IndexType[] types;
        for (IndexType type : types = IndexType.values()) {
            if (!type.getHandlerClsName().equals(className)) continue;
            return type;
        }
        return null;
    }

    public static enum IndexType {
        AGGREGATE_TABLE("aggregate", "org.apache.hadoop.hive.ql.AggregateIndexHandler"),
        COMPACT_SUMMARY_TABLE("compact", "org.apache.hadoop.hive.ql.index.compact.CompactIndexHandler"),
        BITMAP_TABLE("bitmap", "org.apache.hadoop.hive.ql.index.bitmap.BitmapIndexHandler");

        private final String indexTypeName;
        private final String handlerClsName;

        private IndexType(String indexType, String className) {
            this.indexTypeName = indexType;
            this.handlerClsName = className;
        }

        public String getName() {
            return this.indexTypeName;
        }

        public String getHandlerClsName() {
            return this.handlerClsName;
        }
    }
}

